/**
Copyright (C) 2025 Digital Venture Consultants (info@dvc.ventures)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package ventures.dvc.karbon.provider

import ventures.dvc.karbon.location.ForecastLocation

public const val FORECAST_BLOBSTORE_API: String = "https://carbonawarecomputing.blob.core.windows.net"


public interface ForecastProviderConfiguration {
    public val baseUrl: String

    public fun forecastsUrl(location: ForecastLocation): String =
        "$baseUrl/forecasts/${location.code}.json"
}

public fun ForecastProviderConfiguration(
    baseUrl: String = FORECAST_BLOBSTORE_API,
): ForecastProviderConfiguration = CoreForecastProviderConfiguration(baseUrl)


private data class CoreForecastProviderConfiguration(
    override val baseUrl: String,
) : ForecastProviderConfiguration