/**
Copyright (C) 2025 Digital Venture Consultants (info@dvc.ventures)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package ventures.dvc.karbon.provider.ktor

import io.ktor.client.statement.*
import io.ktor.http.*
import ventures.dvc.karbon.provider.ForecastHash
import ventures.dvc.karbon.provider.toIfNoneMatchHeaderValue

internal fun HeadersBuilder.ifNoneMatch(hash: ForecastHash) {
    set("If-None-Match", hash.toIfNoneMatchHeaderValue())
}

internal fun HttpResponse.isOk() = status == HttpStatusCode.OK
internal fun HttpResponse.isNotModified() = status == HttpStatusCode.NotModified
internal fun HttpResponse.isNotFound() = status == HttpStatusCode.NotFound


internal fun HttpResponse.forecastHash(): ForecastHash =
    headers["ETag"]
        ?.takeIf { it.isNotBlank() }
        ?.let { ForecastHash.Hash(it) }
        ?: ForecastHash.None