/*
 * Decompiled with CFR 0.152.
 */
package ventures.dvc.karbon.provider.restclient;

import arrow.core.NonFatalOrThrowKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClient;
import ventures.dvc.karbon.location.ForecastLocation;
import ventures.dvc.karbon.provider.ForecastHash;
import ventures.dvc.karbon.provider.ForecastProviderConfiguration;
import ventures.dvc.karbon.provider.ValidateKeyProvider;
import ventures.dvc.karbon.provider.ValidateKeyRequest;
import ventures.dvc.karbon.provider.ValidateKeyResponse;
import ventures.dvc.karbon.provider.restclient.RestClientExtensionsKt;
import ventures.dvc.karbon.provider.restclient.RestClientValidateKeyOperationKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096B\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lventures/dvc/karbon/provider/restclient/RestClientValidateKeyOperation;", "Lventures/dvc/karbon/provider/ValidateKeyProvider;", "configuration", "Lventures/dvc/karbon/provider/ForecastProviderConfiguration;", "client", "Lorg/springframework/web/client/RestClient;", "<init>", "(Lventures/dvc/karbon/provider/ForecastProviderConfiguration;Lorg/springframework/web/client/RestClient;)V", "invoke", "Lventures/dvc/karbon/provider/ValidateKeyResponse;", "request", "Lventures/dvc/karbon/provider/ValidateKeyRequest;", "(Lventures/dvc/karbon/provider/ValidateKeyRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateKey", "location", "Lventures/dvc/karbon/location/ForecastLocation;", "hash", "Lventures/dvc/karbon/provider/ForecastHash;", "karbon-provider-restclient"})
public final class RestClientValidateKeyOperation
implements ValidateKeyProvider {
    @NotNull
    private final ForecastProviderConfiguration configuration;
    @NotNull
    private final RestClient client;

    public RestClientValidateKeyOperation(@NotNull ForecastProviderConfiguration configuration, @NotNull RestClient client) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.configuration = configuration;
        this.client = client;
    }

    @Nullable
    public Object invoke(@NotNull ValidateKeyRequest request, @NotNull Continuation<? super ValidateKeyResponse> $completion) {
        ValidateKeyResponse validateKeyResponse;
        try {
            validateKeyResponse = this.validateKey(request.getKey().getLocation(), request.getKey().getHash());
        }
        catch (Throwable t) {
            NonFatalOrThrowKt.nonFatalOrThrow((Throwable)t);
            validateKeyResponse = (ValidateKeyResponse)new ValidateKeyResponse.None(request.getKey().getLocation());
        }
        return validateKeyResponse;
    }

    private final ValidateKeyResponse validateKey(ForecastLocation location, ForecastHash hash) {
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        ValidateKeyResponse validateKeyResponse = (ValidateKeyResponse)this.client.head().uri(this.configuration.forecastsUrl(location), new Object[0]).accept(mediaTypeArray).headers(arg_0 -> RestClientValidateKeyOperation.validateKey$lambda$0(hash, arg_0)).exchange((arg_0, arg_1) -> RestClientValidateKeyOperation.validateKey$lambda$1(location, hash, arg_0, arg_1));
        if (validateKeyResponse == null) {
            validateKeyResponse = (ValidateKeyResponse)new ValidateKeyResponse.None(location);
        }
        return validateKeyResponse;
    }

    private static final void validateKey$lambda$0(ForecastHash $hash, HttpHeaders headers) {
        Intrinsics.checkNotNull((Object)headers);
        RestClientExtensionsKt.ifNoneMatch(headers, $hash);
    }

    private static final ValidateKeyResponse validateKey$lambda$1(ForecastLocation $location, ForecastHash $hash, HttpRequest httpRequest, ClientHttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return RestClientExtensionsKt.isOk(response) ? RestClientValidateKeyOperationKt.access$toModifiedOrNone(response, $location) : (RestClientExtensionsKt.isNotModified(response) ? (ValidateKeyResponse)new ValidateKeyResponse.Valid($location, $hash) : (ValidateKeyResponse)new ValidateKeyResponse.None($location));
    }
}

