/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.generator;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.Context;
import xyz.block.ftl.Ignore;
import xyz.block.ftl.Ingress;
import xyz.block.ftl.Verb;
import xyz.block.ftl.generator.ModuleGenerator;
import xyz.block.ftl.v1.schema.Array;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.DataRef;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.Map;
import xyz.block.ftl.v1.schema.MetadataIngress;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Schema;
import xyz.block.ftl.v1.schema.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001f\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J&\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b\u00a8\u0006 "}, d2={"Lxyz/block/ftl/generator/ModuleGenerator;", "", "()V", "buildDataClass", "Lcom/squareup/kotlinpoet/TypeSpec;", "type", "Lxyz/block/ftl/v1/schema/Data;", "namespace", "", "buildVerbFunction", "Lcom/squareup/kotlinpoet/FunSpec;", "className", "verb", "Lxyz/block/ftl/v1/schema/Verb;", "generateModule", "Lcom/squareup/kotlinpoet/FileSpec;", "module", "Lxyz/block/ftl/v1/schema/Module;", "moduleClientSuffix", "generateModule$ftl_generator", "getTypeClass", "Lcom/squareup/kotlinpoet/TypeName;", "Lxyz/block/ftl/v1/schema/Type;", "prepareFtlRoot", "", "buildDir", "run", "schema", "Lxyz/block/ftl/v1/schema/Schema;", "outputDirectory", "Ljava/io/File;", "Companion", "ftl-generator"})
@SourceDebugExtension(value={"SMAP\nModuleGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleGenerator.kt\nxyz/block/ftl/generator/ModuleGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n766#2:208\n857#2,2:209\n1855#2,2:211\n1603#2,9:214\n1855#2:223\n1856#2:225\n1612#2:226\n1855#2,2:227\n1603#2,9:229\n1855#2:238\n1856#2:240\n1612#2:241\n1855#2,2:242\n1855#2,2:244\n1855#2,2:246\n1#3:213\n1#3:224\n1#3:239\n*S KotlinDebug\n*F\n+ 1 ModuleGenerator.kt\nxyz/block/ftl/generator/ModuleGenerator\n*L\n26#1:208\n26#1:209,2\n26#1:211,2\n53#1:214,9\n53#1:223\n53#1:225\n53#1:226\n54#1:227,2\n56#1:229,9\n56#1:238\n56#1:240\n56#1:241\n57#1:242,2\n69#1:244,2\n100#1:246,2\n53#1:224\n56#1:239\n*E\n"})
public final class ModuleGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DEFAULT_MODULE_CLIENT_SUFFIX = "Module";

    /*
     * WARNING - void declaration
     */
    public final void run(@NotNull Schema schema, @NotNull File outputDirectory, @NotNull String module, @NotNull String moduleClientSuffix) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleClientSuffix, (String)"moduleClientSuffix");
        String fqOutputDir = outputDirectory.getAbsolutePath();
        Intrinsics.checkNotNull((Object)fqOutputDir);
        this.prepareFtlRoot(fqOutputDir, module);
        File sourcesDest = new File(fqOutputDir, "generated-sources");
        Path path = Path.of(sourcesDest.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Iterable $this$filter$iv = schema.getModules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module it = (Module)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)module))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            FileSpec file = this.generateModule$ftl_generator(it, moduleClientSuffix);
            file.writeTo(sourcesDest);
            String string = "Generated module: " + fqOutputDir + '/' + it.getName() + '/' + file.getName() + ".kt";
            System.out.println((Object)string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileSpec generateModule$ftl_generator(@NotNull Module module, @NotNull String moduleClientSuffix) {
        void $this$mapNotNullTo$iv$iv;
        Object element$iv2;
        Iterator $this$mapNotNullTo$iv$iv2;
        String string;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleClientSuffix, (String)"moduleClientSuffix");
        String namespace = "ftl." + module.getName();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = module.getName();
        if (((CharSequence)string2).length() > 0) {
            void p12;
            char c = string2.charAt(0);
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = stringBuilder;
            int n = 0;
            String string3 = CharsKt.titlecase((char)p12);
            stringBuilder = stringBuilder3;
            StringBuilder stringBuilder4 = stringBuilder2.append((Object)string3);
            String p12 = string2;
            n = 1;
            String string4 = p12.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder4.append(string4).toString();
        } else {
            string = string2;
        }
        String className = stringBuilder.append(string).append(moduleClientSuffix).toString();
        FileSpec.Builder file = FileSpec.Companion.builder(namespace, className).addFileComment("Code generated by FTL-Generator, do not edit.", new Object[0]);
        List it = module.getComments();
        boolean bl = false;
        file.addFileComment("\n", new Object[0]);
        file.addFileComment(CollectionsKt.joinToString$default((Iterable)it, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
        TypeSpec.Builder moduleClass = TypeSpec.Companion.classBuilder(className).addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Ignore.class)).build()).primaryConstructor(FunSpec.Companion.constructorBuilder().build());
        Iterable $this$mapNotNull$iv = module.getDecls();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Data it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Decl it2 = (Decl)element$iv$iv;
            boolean bl3 = false;
            if (it2.getData_() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List types = (List)destination$iv$iv;
        Iterable $this$forEach$iv = types;
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Data it3 = (Data)element$iv2;
            boolean bl5 = false;
            file.addType(this.buildDataClass(it3, namespace));
        }
        Iterable $this$mapNotNull$iv2 = module.getDecls();
        boolean $i$f$mapNotNull2 = false;
        element$iv2 = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            xyz.block.ftl.v1.schema.Verb it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl6 = false;
            Decl it4 = (Decl)element$iv$iv;
            boolean bl7 = false;
            if (it4.getVerb() == null) continue;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List verbs = (List)destination$iv$iv2;
        Iterable $this$forEach$iv2 = verbs;
        boolean $i$f$forEach4 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            xyz.block.ftl.v1.schema.Verb it5 = (xyz.block.ftl.v1.schema.Verb)element$iv3;
            boolean bl9 = false;
            moduleClass.addFunction(this.buildVerbFunction(className, it5));
        }
        file.addType(moduleClass.build());
        return file.build();
    }

    public static /* synthetic */ FileSpec generateModule$ftl_generator$default(ModuleGenerator moduleGenerator, Module module, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = DEFAULT_MODULE_CLIENT_SUFFIX;
        }
        return moduleGenerator.generateModule$ftl_generator(module, string);
    }

    private final TypeSpec buildDataClass(Data type, String namespace) {
        KModifier[] kModifierArray = new KModifier[]{KModifier.DATA};
        TypeSpec.Builder dataClassBuilder = TypeSpec.Companion.classBuilder(type.getName()).addModifiers(kModifierArray).addKdoc(CollectionsKt.joinToString$default((Iterable)type.getComments(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
        FunSpec.Builder dataConstructorBuilder = FunSpec.Companion.constructorBuilder();
        Iterable $this$forEach$iv = type.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Type it;
            Field field = (Field)element$iv;
            boolean bl = false;
            dataClassBuilder.addKdoc(CollectionsKt.joinToString$default((Iterable)field.getComments(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            if (field.getType() == null) continue;
            boolean bl2 = false;
            dataConstructorBuilder.addParameter(field.getName(), this.getTypeClass(it, namespace), new KModifier[0]);
            dataClassBuilder.addProperty(PropertySpec.Companion.builder(field.getName(), this.getTypeClass(it, namespace), new KModifier[0]).initializer(field.getName(), new Object[0]).build());
        }
        if (type.getFields().isEmpty()) {
            dataConstructorBuilder.addParameter(ParameterSpec.Companion.builder("_empty", Reflection.getOrCreateKotlinClass(Unit.class), new KModifier[0]).defaultValue("Unit", new Object[0]).build());
            dataClassBuilder.addProperty(PropertySpec.Companion.builder("_empty", Reflection.getOrCreateKotlinClass(Unit.class), new KModifier[0]).initializer("_empty", new Object[0]).build());
        }
        dataClassBuilder.primaryConstructor(dataConstructorBuilder.build());
        return dataClassBuilder.build();
    }

    private final FunSpec buildVerbFunction(String className, xyz.block.ftl.v1.schema.Verb verb) {
        DataRef it;
        FunSpec.Builder verbFunBuilder = FunSpec.Companion.builder(verb.getName()).addKdoc(CollectionsKt.joinToString$default((Iterable)verb.getComments(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]).addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Verb.class)).build());
        Iterable $this$forEach$iv = verb.getMetadata();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataIngress it2;
            xyz.block.ftl.v1.schema.Metadata metadata = (xyz.block.ftl.v1.schema.Metadata)element$iv;
            boolean bl = false;
            if (metadata.getIngress() == null) continue;
            boolean bl2 = false;
            Object[] objectArray = new Object[1];
            String[] stringArray = new String[]{StringsKt.replaceBefore$default((String)it2.getMethod(), (String)".", (String)"", null, (int)4, null)};
            objectArray[0] = new ClassName("xyz.block.ftl.Method", stringArray);
            AnnotationSpec.Builder builder = AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Ingress.class)).addMember("%T", objectArray);
            objectArray = new Object[]{it2.getPath()};
            verbFunBuilder.addAnnotation(builder.addMember("%S", objectArray).build());
        }
        verbFunBuilder.addParameter("context", Reflection.getOrCreateKotlinClass(Context.class), new KModifier[0]);
        DataRef dataRef = verb.getRequest();
        if (dataRef != null) {
            it = dataRef;
            boolean bl = false;
            verbFunBuilder.addParameter("req", (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)it.getName(), null, (int)2, null), new KModifier[0]);
        }
        DataRef dataRef2 = verb.getResponse();
        if (dataRef2 != null) {
            it = dataRef2;
            boolean bl = false;
            FunSpec.Builder.returns$default((FunSpec.Builder)verbFunBuilder, (TypeName)((TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)it.getName(), null, (int)2, null)), null, (int)2, null);
        }
        String message = "Verb stubs should not be called directly, instead use context.call(" + className + "::" + verb.getName() + ", ...)";
        Object[] objectArray = new Object[]{message};
        verbFunBuilder.addCode("throw NotImplementedError(%S)", objectArray);
        return verbFunBuilder.build();
    }

    private final TypeName getTypeClass(Type type, String namespace) {
        TypeName typeName;
        if (type.getInt() != null) {
            String[] stringArray = new String[]{"Long"};
            typeName = (TypeName)new ClassName("kotlin", stringArray);
        } else if (type.getFloat() != null) {
            String[] stringArray = new String[]{"Float"};
            typeName = (TypeName)new ClassName("kotlin", stringArray);
        } else if (type.getString() != null) {
            String[] stringArray = new String[]{"String"};
            typeName = (TypeName)new ClassName("kotlin", stringArray);
        } else if (type.getBool() != null) {
            String[] stringArray = new String[]{"Boolean"};
            typeName = (TypeName)new ClassName("kotlin", stringArray);
        } else if (type.getTime() != null) {
            String[] stringArray = new String[]{"OffsetDateTime"};
            typeName = (TypeName)new ClassName("java.time", stringArray);
        } else if (type.getArray() != null) {
            Array array = type.getArray();
            if (array == null || (array = array.getElement()) == null) {
                throw new IllegalArgumentException("Missing element type in kotlin array generator");
            }
            Array element = array;
            TypeName elementType = this.getTypeClass((Type)element, namespace);
            String[] stringArray = new String[]{"ArrayList"};
            ClassName arrayList = new ClassName("kotlin.collections", stringArray);
            stringArray = new TypeName[]{elementType};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(arrayList, (TypeName[])stringArray);
        } else if (type.getMap() != null) {
            String[] elementType = new String[]{"Map"};
            ClassName map = new ClassName("kotlin.collections", elementType);
            Map map2 = type.getMap();
            if (map2 == null || (map2 = map2.getKey()) == null) {
                throw new IllegalArgumentException("Missing map key in kotlin map generator");
            }
            Map key = map2;
            Map map3 = type.getMap();
            if (map3 == null || (map3 = map3.getValue_()) == null) {
                throw new IllegalArgumentException("Missing map value in kotlin map generator");
            }
            Map value = map3;
            TypeName[] typeNameArray = new TypeName[]{this.getTypeClass((Type)key, namespace), this.getTypeClass((Type)value, namespace)};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(map, typeNameArray);
        } else if (type.getDataRef() != null) {
            String module = null;
            module = type.getDataRef().getModule();
            String[] stringArray = (String[])type.getDataRef().getModule();
            if (stringArray.length() == 0) {
                boolean bl = false;
                module = namespace;
            }
            stringArray = new String[]{type.getDataRef().getName()};
            typeName = (TypeName)new ClassName(module, stringArray);
        } else {
            throw new IllegalArgumentException("Unknown type in kotlin generator");
        }
        return typeName;
    }

    private final void prepareFtlRoot(String buildDir, String module) {
        Path path = Path.of(buildDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        object = new String[]{"ftl.toml"};
        Path path3 = Path.of(buildDir, (String[])object);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        PathsKt.writeText$default((Path)path3, (CharSequence)StringsKt.trimIndent((String)("\n      module = \"" + module + "\"\n      language = \"kotlin\"\n      deploy = [\"main\", \"classes\", \"dependency\", \"classpath.txt\"]\n      schema = \"schema.pb\"\n      ")), null, (OpenOption[])new OpenOption[0], (int)2, null);
        object = new String[]{"detekt.yml"};
        Path path4 = Path.of(buildDir, (String[])object);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"of(...)");
        PathsKt.writeText$default((Path)path4, (CharSequence)StringsKt.trimIndent((String)("\n      SchemaExtractorRuleSet:\n        ExtractSchemaRule:\n          active: true\n          output: " + buildDir + "\n      ")), null, (OpenOption[])new OpenOption[0], (int)2, null);
        object = new String[]{"main"};
        Path mainFile = Path.of(buildDir, (String[])object);
        Intrinsics.checkNotNull((Object)mainFile);
        PathsKt.writeText$default((Path)mainFile, (CharSequence)"#!/bin/bash\nexec java -cp \"classes:$(cat classpath.txt)\" xyz.block.ftl.main.MainKt", null, (OpenOption[])new OpenOption[0], (int)2, null);
        object = mainFile;
        Object object2 = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE};
        object2 = SetsKt.setOf((Object[])object2);
        Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions((Path)object, (Set<PosixFilePermission>)object2), (String)"setPosixFilePermissions(...)");
    }
}

