/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.schemaextractor;

import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.rules.KotlinCoreEnvironmentTest;
import io.gitlab.arturbosch.detekt.test.RuleExtensionsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import xyz.block.ftl.schemaextractor.ExtractSchemaRule;
import xyz.block.ftl.schemaextractor.ExtractSchemaRuleTest;
import xyz.block.ftl.v1.schema.Any;
import xyz.block.ftl.v1.schema.Array;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.DataRef;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.IngressPathComponent;
import xyz.block.ftl.v1.schema.IngressPathLiteral;
import xyz.block.ftl.v1.schema.Map;
import xyz.block.ftl.v1.schema.MetadataCalls;
import xyz.block.ftl.v1.schema.MetadataIngress;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Position;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.TypeParameter;
import xyz.block.ftl.v1.schema.Verb;
import xyz.block.ftl.v1.schema.VerbRef;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@KotlinCoreEnvironmentTest
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest;", "", "env", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "cleanup", "", "extracts schema", "fails if http ingress without http request-response types", "fails if invalid schema type is included", "setup", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nExtractSchemaRuleTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractSchemaRuleTest.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,340:1\n124#2:341\n137#2,14:342\n124#2:356\n137#2,14:357\n*S KotlinDebug\n*F\n+ 1 ExtractSchemaRuleTest.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest\n*L\n293#1:341\n293#1:342,14\n329#1:356\n329#1:357,14\n*E\n"})
public final class ExtractSchemaRuleTest {
    @NotNull
    private final KotlinCoreEnvironment env;

    public ExtractSchemaRuleTest(@NotNull KotlinCoreEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.env = env;
    }

    @BeforeEach
    public final void setup() {
        File dependenciesDir = new File("src/test/kotlin/xyz/block/ftl/schemaextractor/testdata/dependencies");
        Object object = dependenciesDir.listFiles(ExtractSchemaRuleTest::setup$lambda$0);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object dependencies = object;
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)this.env.getConfiguration(), (List)dependencies);
    }

    @Test
    public final void extracts schema() {
        String code = "\n        package ftl.echo\n\n        import ftl.builtin.HttpRequest\n        import ftl.builtin.HttpResponse\n        import ftl.time.TimeModuleClient\n        import ftl.time.TimeRequest\n        import ftl.time.TimeResponse\n        import xyz.block.ftl.Alias\n        import xyz.block.ftl.Context\n        import xyz.block.ftl.Ingress\n        import xyz.block.ftl.Method\n        import xyz.block.ftl.Verb\n\n        class InvalidInput(val field: String) : Exception()\n\n        data class MapValue(val value: String)\n        data class EchoMessage(val message: String, val metadata: Map<String, MapValue>? = null)\n\n        /**\n         * Request to echo a message.\n         */\n        data class EchoRequest<T>(val t: T, val name: String, @Alias(\"stf\") val stuff: Any)\n        data class EchoResponse(val messages: List<EchoMessage>)\n\n        /**\n         * Echo module.\n         */\n        class Echo {\n           /**\n            * Echoes the given message.\n            */\n            @Throws(InvalidInput::class)\n            @Verb\n            @Ingress(Method.GET, \"/echo\")\n            fun echo(context: Context, req: HttpRequest<EchoRequest<String>>): HttpResponse<EchoResponse> {\n                callTime(context)\n\n                return HttpResponse<EchoResponse>(\n                  status = 200,\n                  headers = mapOf(\"Get\" to arrayListOf(\"Header from FTL\")),\n                  body = EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n                )\n            }\n\n            fun callTime(context: Context): TimeResponse {\n                return context.call(TimeModuleClient::time, TimeRequest)\n            }\n        }\n        ";
        RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (String)code);
        File file = new File("schema.pb");
        Module module = (Module)Module.ADAPTER.decode((InputStream)new FileInputStream(file));
        String[] stringArray = CollectionsKt.listOf((Object)"/**\n         * Echo module.\n         */");
        Object[] objectArray = new Decl[5];
        objectArray[0] = new Decl(new Data(null, null, "MapValue", CollectionsKt.listOf((Object)new Field(null, "value", null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, null, 16379, null), null, null, 53, null)), null, null, null, 115, null), null, null, null, 14, null);
        Object[] objectArray2 = new Field[]{new Field(null, "message", null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, null, 16379, null), null, null, 53, null), new Field(null, "metadata", null, new Type(null, null, null, null, null, null, null, new Map(null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, null, 16379, null), new Type(null, null, null, null, null, null, null, null, new DataRef(null, "MapValue", "echo", null, null, 25, null), null, null, null, null, null, 16127, null), null, 9, null), null, null, null, null, null, null, 16255, null), null, null, 53, null)};
        objectArray[1] = new Decl(new Data(null, null, "EchoMessage", CollectionsKt.listOf((Object[])objectArray2), null, null, null, 115, null), null, null, null, 14, null);
        Object object = new Field[]{new Field(null, "t", null, new Type(null, null, null, null, null, null, null, null, null, null, null, new TypeParameter(null, "T", null, 5, null), null, null, 14335, null), null, null, 53, null), new Field(null, "name", null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, null, 16379, null), null, null, 53, null), new Field(null, "stuff", null, new Type(null, null, null, null, null, null, null, null, null, null, new Any(null, null, 3, null), null, null, null, 15359, null), "stf", null, 37, null)};
        objectArray2 = CollectionsKt.listOf((Object[])object);
        object = CollectionsKt.listOf((Object)"/**\n         * Request to echo a message.\n         */");
        List list = CollectionsKt.listOf((Object)new TypeParameter(null, "T", null, 5, null));
        objectArray[2] = new Decl(new Data(null, (List)object, "EchoRequest", (List)objectArray2, null, list, null, 81, null), null, null, null, 14, null);
        objectArray[3] = new Decl(new Data(null, null, "EchoResponse", CollectionsKt.listOf((Object)new Field(null, "messages", null, new Type(null, null, null, null, null, null, new Array(null, new Type(null, null, null, null, null, null, null, null, new DataRef(null, "EchoMessage", "echo", null, null, 25, null), null, null, null, null, null, 16127, null), null, 5, null), null, null, null, null, null, null, null, 16319, null), null, null, 53, null)), null, null, null, 115, null), null, null, null, 14, null);
        object = CollectionsKt.listOf((Object)new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, null, 16379, null));
        objectArray2 = CollectionsKt.listOf((Object)new Type(null, null, null, null, null, null, null, null, new DataRef(null, "EchoRequest", "echo", (List)object, null, 17, null), null, null, null, null, null, 16127, null));
        Type type = new Type(null, null, null, null, null, null, null, null, new DataRef(null, "HttpRequest", "builtin", (List)objectArray2, null, 17, null), null, null, null, null, null, 16127, null);
        objectArray2 = new xyz.block.ftl.v1.schema.Metadata[]{new xyz.block.ftl.v1.schema.Metadata(null, new MetadataIngress(null, "http", "GET", CollectionsKt.listOf((Object)new IngressPathComponent(new IngressPathLiteral(null, "echo", null, 5, null), null, null, 6, null)), null, 17, null), null, null, 13, null), new xyz.block.ftl.v1.schema.Metadata(new MetadataCalls(null, CollectionsKt.listOf((Object)new VerbRef(null, "time", "time", null, 9, null)), null, 5, null), null, null, null, 14, null)};
        objectArray[4] = new Decl(null, new Verb(null, null, "echo", CollectionsKt.listOf((Object)"/**\n            * Echoes the given message.\n            */"), type, new Type(null, null, null, null, null, null, null, null, new DataRef(null, "HttpResponse", "builtin", CollectionsKt.listOf((Object)new Type(null, null, null, null, null, null, null, null, new DataRef(null, "EchoResponse", "echo", null, null, 25, null), null, null, null, null, null, 16127, null)), null, 17, null), null, null, null, null, null, 16127, null), CollectionsKt.listOf((Object[])objectArray2), null, 131, null), null, null, 13, null);
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        Module expected = new Module(null, null, (List)stringArray, false, "echo", list2, null, 75, null);
        stringArray = new String[]{".*hashCode$"};
        Assertions.assertThat((Object)module).usingRecursiveComparison().withEqualsForType((arg_0, arg_1) -> ExtractSchemaRuleTest.extracts_schema$lambda$1((Function2)extracts schema.1.INSTANCE, arg_0, arg_1), Position.class).ignoringFieldsMatchingRegexes(stringArray).isEqualTo((Object)expected);
    }

    @Test
    public final void fails if invalid schema type is included() {
        Throwable throwable;
        Throwable throwable2;
        String code = "\n        package ftl.echo\n\n        import ftl.time.TimeModuleClient\n        import ftl.time.TimeRequest\n        import ftl.time.TimeResponse\n        import xyz.block.ftl.Context\n        import xyz.block.ftl.Ingress\n        import xyz.block.ftl.Method\n        import xyz.block.ftl.Verb\n\n        class InvalidInput(val field: String) : Exception()\n\n        data class EchoMessage(val message: String, val metadata: Map<String, String>? = null)\n\n        /**\n         * Request to echo a message.\n         */\n        data class EchoRequest(val name: Char)\n        data class EchoResponse(val messages: List<EchoMessage>)\n\n        /**\n         * Echo module.\n         */\n        class Echo {\n           /**\n            * Echoes the given message.\n            */\n            @Throws(InvalidInput::class)\n            @Verb\n            @Ingress(Method.GET, \"/echo\")\n            fun echo(context: Context, req: EchoRequest): EchoResponse {\n                callTime(context)\n                return EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n            }\n\n            fun callTime(context: Context): TimeResponse {\n                return context.call(TimeModuleClient::time, TimeRequest)\n            }\n        }\n        ";
        String message$iv = "kotlin.Char type is not supported in FTL schema";
        boolean $i$f$assertThrows = false;
        Function0 message$iv$iv = (Function0)new /* Unavailable Anonymous Inner Class!! */;
        boolean $i$f$assertThrows2 = false;
        try {
            boolean bl = false;
            RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (String)code);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv$iv) {
            throwable2 = caught$iv$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv$iv = throwable;
        throwable2 = message$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)((Executable)new /* Unavailable Anonymous Inner Class!! */), (Supplier)((Supplier)new /* Unavailable Anonymous Inner Class!! */)), (String)"Assertions.assertThrows(\u2026  Supplier(message)\n    )");
    }

    @Test
    public final void fails if http ingress without http request-response types() {
        Throwable throwable;
        Throwable throwable2;
        String code = "\n        package ftl.echo\n\n        import xyz.block.ftl.Context\n        import xyz.block.ftl.Ingress\n        import xyz.block.ftl.Method\n        import xyz.block.ftl.Verb\n\n        /**\n         * Request to echo a message.\n         */\n        data class EchoRequest(val name: String)\n        data class EchoResponse(val message: String)\n\n        /**\n         * Echo module.\n         */\n        class Echo {\n           /**\n            * Echoes the given message.\n            */\n            @Throws(InvalidInput::class)\n            @Verb\n            @Ingress(Method.GET, \"/echo\")\n            fun echo(context: Context, req: EchoRequest): EchoResponse {\n                return EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n            }\n        }\n        ";
        String message$iv = "HTTP @Ingress-annotated echo request must be ftl.builtin.HttpRequest";
        boolean $i$f$assertThrows = false;
        Function0 message$iv$iv = (Function0)new /* Unavailable Anonymous Inner Class!! */;
        boolean $i$f$assertThrows2 = false;
        try {
            boolean bl = false;
            RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (String)code);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv$iv) {
            throwable2 = caught$iv$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv$iv = throwable;
        throwable2 = message$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)((Executable)new /* Unavailable Anonymous Inner Class!! */), (Supplier)((Supplier)new /* Unavailable Anonymous Inner Class!! */)), (String)"Assertions.assertThrows(\u2026  Supplier(message)\n    )");
    }

    @AfterEach
    public final void cleanup() {
        File file = new File("schema.pb");
        file.delete();
    }

    private static final boolean setup$lambda$0(File file) {
        Intrinsics.checkNotNull((Object)file);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"kt");
    }

    private static final boolean extracts_schema$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }
}

