/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.client;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.client.VerbServiceClientInterceptor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"makeGrpcClient", "Lio/grpc/ManagedChannel;", "endpoint", "", "ftl-runtime"})
public final class GrpcKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final ManagedChannel makeGrpcClient(@NotNull String endpoint) {
        int n;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        URL url = new URL(endpoint);
        if (url.getPort() == -1) {
            String string = url.getProtocol();
            if (Intrinsics.areEqual((Object)string, (Object)"http")) {
                n = 80;
            } else {
                if (!Intrinsics.areEqual((Object)string, (Object)"https")) throw new IllegalArgumentException("Unsupported protocol: " + url.getProtocol());
                n = 443;
            }
        } else {
            n = url.getPort();
        }
        int port = n;
        ClientInterceptor[] clientInterceptorArray = new ClientInterceptor[]{new VerbServiceClientInterceptor()};
        NettyChannelBuilder builder = (NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)new InetSocketAddress(url.getHost(), port)).keepAliveTime(5L, TimeUnit.SECONDS).intercept(clientInterceptorArray);
        if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)"http")) {
            builder = builder.usePlaintext();
        }
        ManagedChannel managedChannel = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"build(...)");
        return managedChannel;
    }
}

