/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.schemaextractor;

import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.rules.KotlinCoreEnvironmentTest;
import io.gitlab.arturbosch.detekt.test.RuleExtensionsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import xyz.block.ftl.schemaextractor.ExtractSchemaRule;
import xyz.block.ftl.schemaextractor.ExtractSchemaRuleTest;
import xyz.block.ftl.v1.schema.Any;
import xyz.block.ftl.v1.schema.Array;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.DataRef;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.IngressPathComponent;
import xyz.block.ftl.v1.schema.IngressPathLiteral;
import xyz.block.ftl.v1.schema.Map;
import xyz.block.ftl.v1.schema.MetadataAlias;
import xyz.block.ftl.v1.schema.MetadataCalls;
import xyz.block.ftl.v1.schema.MetadataIngress;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Optional;
import xyz.block.ftl.v1.schema.Position;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.TypeParameter;
import xyz.block.ftl.v1.schema.Verb;
import xyz.block.ftl.v1.schema.VerbRef;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@KotlinCoreEnvironmentTest
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest;", "", "env", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "cleanup", "", "extracts schema", "fails if http ingress without http request-response types", "fails if invalid schema type is included", "setup", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nExtractSchemaRuleTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractSchemaRuleTest.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,375:1\n100#2,7:376\n100#2,7:383\n*S KotlinDebug\n*F\n+ 1 ExtractSchemaRuleTest.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest\n*L\n328#1:376,7\n363#1:383,7\n*E\n"})
public final class ExtractSchemaRuleTest {
    @NotNull
    private final KotlinCoreEnvironment env;

    public ExtractSchemaRuleTest(@NotNull KotlinCoreEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.env = env;
    }

    @BeforeEach
    public final void setup() {
        File dependenciesDir = new File("src/test/kotlin/xyz/block/ftl/schemaextractor/testdata/dependencies");
        Object object = dependenciesDir.listFiles(ExtractSchemaRuleTest::setup$lambda$0);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object dependencies = object;
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)this.env.getConfiguration(), (List)dependencies);
    }

    @Test
    public final void extracts schema() {
        String code = "\n      // Echo module.\n      package ftl.echo\n\n      import ftl.builtin.Empty\n      import ftl.builtin.HttpRequest\n      import ftl.builtin.HttpResponse\n      import ftl.time.time as verb\n      import ftl.time.other\n      import ftl.time.TimeRequest\n      import ftl.time.TimeResponse\n      import xyz.block.ftl.Json\n      import xyz.block.ftl.Context\n      import xyz.block.ftl.HttpIngress\n      import xyz.block.ftl.Method\n      import xyz.block.ftl.Module\n      import xyz.block.ftl.Verb\n\n      class InvalidInput(val field: String) : Exception()\n\n      data class MapValue(val value: String)\n      data class EchoMessage(val message: String, val metadata: Map<String, MapValue>? = null)\n\n      /**\n       * Request to echo a message.\n       *\n       * More comments.\n       */\n      data class EchoRequest<T>(\n        val t: T,\n        val name: String,\n        @Json(\"stf\") val stuff: Any,\n       )\n      data class EchoResponse(val messages: List<EchoMessage>)\n\n      /**\n       * Echoes the given message.\n       */\n      @Throws(InvalidInput::class)\n      @Verb\n      @HttpIngress(Method.GET, \"/echo\")\n      fun echo(context: Context, req: HttpRequest<EchoRequest<String>>): HttpResponse<EchoResponse, String> {\n        callTime(context)\n\n        return HttpResponse(\n          status = 200,\n          headers = mapOf(\"Get\" to arrayListOf(\"Header from FTL\")),\n          body = EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n        )\n      }\n\n      @Verb\n      fun empty(context: Context, req: Empty): Empty {\n        return builtin.Empty()\n      }\n\n      fun callTime(context: Context): TimeResponse {\n        context.call(::empty, builtin.Empty())\n        context.call(::other, builtin.Empty())\n        // commented out call is ignored:\n        //context.call(::foo, builtin.Empty())\n        return context.call(::verb, builtin.Empty())\n      }\n    ";
        RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (String)code);
        File file = new File("schema.pb");
        Module module = (Module)Module.ADAPTER.decode((InputStream)new FileInputStream(file));
        String[] stringArray = CollectionsKt.listOf((Object)"Echo module.");
        Object[] objectArray = new Decl[6];
        objectArray[0] = new Decl(new Data(null, null, "MapValue", CollectionsKt.listOf((Object)new Field(null, "value", null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, 8187, null), null, null, 53, null)), null, null, null, 115, null), null, null, null, null, 30, null);
        Object[] objectArray2 = new Field[]{new Field(null, "message", null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, 8187, null), null, null, 53, null), new Field(null, "metadata", null, new Type(null, null, null, null, null, null, null, null, null, null, null, new Optional(null, new Type(null, null, null, null, null, null, null, new Map(null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, 8187, null), new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "MapValue", "echo", null, null, 25, null), null, null, 7167, null), null, 9, null), null, null, null, null, null, 8063, null), null, 5, null), null, 6143, null), null, null, 53, null)};
        objectArray[1] = new Decl(new Data(null, null, "EchoMessage", CollectionsKt.listOf((Object[])objectArray2), null, null, null, 115, null), null, null, null, null, 30, null);
        Object[] objectArray3 = new Field[]{new Field(null, "t", null, new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "T", null, null, null, 29, null), null, null, 7167, null), null, null, 53, null), new Field(null, "name", null, new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, 8187, null), null, null, 53, null), new Field(null, "stuff", null, new Type(null, null, null, null, null, null, null, null, new Any(null, null, 3, null), null, null, null, null, 7935, null), CollectionsKt.listOf((Object)new xyz.block.ftl.v1.schema.Metadata(null, null, null, new MetadataAlias(null, 0L, "stf", null, 11, null), null, 23, null)), null, 37, null)};
        objectArray2 = CollectionsKt.listOf((Object[])objectArray3);
        Object object = new String[]{"Request to echo a message.", "", "More comments."};
        objectArray3 = CollectionsKt.listOf((Object[])object);
        object = CollectionsKt.listOf((Object)new TypeParameter(null, "T", null, 5, null));
        objectArray[2] = new Decl(new Data(null, (List)objectArray3, "EchoRequest", (List)objectArray2, null, (List)object, null, 81, null), null, null, null, null, 30, null);
        objectArray[3] = new Decl(new Data(null, null, "EchoResponse", CollectionsKt.listOf((Object)new Field(null, "messages", null, new Type(null, null, null, null, null, null, new Array(null, new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "EchoMessage", "echo", null, null, 25, null), null, null, 7167, null), null, 5, null), null, null, null, null, null, null, 8127, null), null, null, 53, null)), null, null, null, 115, null), null, null, null, null, 30, null);
        objectArray3 = CollectionsKt.listOf((Object)new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, 8187, null));
        objectArray2 = CollectionsKt.listOf((Object)new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "EchoRequest", "echo", (List)objectArray3, null, 17, null), null, null, 7167, null));
        Type type = new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "HttpRequest", "builtin", (List)objectArray2, null, 17, null), null, null, 7167, null);
        objectArray2 = new Type[]{new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "EchoResponse", "echo", null, null, 25, null), null, null, 7167, null), new Type(null, null, new xyz.block.ftl.v1.schema.String(null, null, 3, null), null, null, null, null, null, null, null, null, null, null, 8187, null)};
        Type type2 = new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "HttpResponse", "builtin", CollectionsKt.listOf((Object[])objectArray2), null, 17, null), null, null, 7167, null);
        objectArray2 = new xyz.block.ftl.v1.schema.Metadata[2];
        objectArray2[0] = new xyz.block.ftl.v1.schema.Metadata(null, new MetadataIngress(null, "http", "GET", CollectionsKt.listOf((Object)new IngressPathComponent(new IngressPathLiteral(null, "echo", null, 5, null), null, null, 6, null)), null, 17, null), null, null, null, 29, null);
        objectArray3 = new VerbRef[]{new VerbRef(null, "empty", "echo", null, 9, null), new VerbRef(null, "other", "time", null, 9, null), new VerbRef(null, "time", "time", null, 9, null)};
        objectArray2[1] = new xyz.block.ftl.v1.schema.Metadata(new MetadataCalls(null, CollectionsKt.listOf((Object[])objectArray3), null, 5, null), null, null, null, null, 30, null);
        objectArray[4] = new Decl(null, new Verb(null, null, "echo", CollectionsKt.listOf((Object)"Echoes the given message."), type, type2, CollectionsKt.listOf((Object[])objectArray2), null, 131, null), null, null, null, 29, null);
        objectArray[5] = new Decl(null, new Verb(null, null, "empty", null, new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "Empty", "builtin", null, null, 25, null), null, null, 7167, null), new Type(null, null, null, null, null, null, null, null, null, null, new DataRef(null, "Empty", "builtin", null, null, 25, null), null, null, 7167, null), null, null, 203, null), null, null, null, 29, null);
        List list = CollectionsKt.listOf((Object[])objectArray);
        Module expected = new Module(null, null, (List)stringArray, false, "echo", list, null, 75, null);
        stringArray = new String[]{".*hashCode$"};
        Assertions.assertThat((Object)module).usingRecursiveComparison().withEqualsForType((arg_0, arg_1) -> ExtractSchemaRuleTest.extracts_schema$lambda$1((Function2)extracts schema.1.INSTANCE, arg_0, arg_1), Position.class).ignoringFieldsMatchingRegexes(stringArray).isEqualTo((Object)expected);
    }

    @Test
    public final void fails if invalid schema type is included() {
        Throwable throwable;
        Throwable throwable2;
        String code = "/**\n * Echo module.\n */\npackage ftl.echo\n\nimport ftl.builtin.Empty\nimport ftl.time.time\nimport ftl.time.TimeRequest\nimport ftl.time.TimeResponse\nimport xyz.block.ftl.Context\nimport xyz.block.ftl.Method\nimport xyz.block.ftl.Verb\n\nclass InvalidInput(val field: String) : Exception()\n\ndata class EchoMessage(val message: String, val metadata: Map<String, String>? = null)\n\n/**\n * Request to echo a message.\n */\ndata class EchoRequest(val name: Char)\ndata class EchoResponse(val messages: List<EchoMessage>)\n\n/**\n * Echoes the given message.\n */\n@Throws(InvalidInput::class)\n@Verb\nfun echo(context: Context, req: EchoRequest): EchoResponse {\n  callTime(context)\n  return EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n}\n\nfun callTime(context: Context): TimeResponse {\n  return context.call(::time, Empty())\n}\n";
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (String)code);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Throwable throwable3 = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)((Executable)new /* Unavailable Anonymous Inner Class!! */));
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable3, (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        String string = ((IllegalArgumentException)throwable3).getMessage();
        Intrinsics.checkNotNull((Object)string);
        String message = string;
        AssertionsKt.assertContains$default((CharSequence)message, (CharSequence)"Expected type to be a data class or builtin.Empty, but was kotlin.Char", (boolean)false, null, (int)12, null);
    }

    @Test
    public final void fails if http ingress without http request-response types() {
        Throwable throwable;
        Throwable throwable2;
        String code = "\n /**\n * Echo module.\n */\npackage ftl.echo\n\nimport xyz.block.ftl.Context\nimport xyz.block.ftl.HttpIngress\nimport xyz.block.ftl.Method\nimport xyz.block.ftl.Verb\n\n/**\n * Request to echo a message.\n */\ndata class EchoRequest(val name: String)\ndata class EchoResponse(val message: String)\n\n/**\n * Echoes the given message.\n */\n@Throws(InvalidInput::class)\n@Verb\n@HttpIngress(Method.GET, \"/echo\")\nfun echo(context: Context, req: EchoRequest): EchoResponse {\n  return EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n}\n        ";
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (String)code);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Throwable throwable3 = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)((Executable)new /* Unavailable Anonymous Inner Class!! */));
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable3, (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        String string = ((IllegalArgumentException)throwable3).getMessage();
        Intrinsics.checkNotNull((Object)string);
        String message = string;
        AssertionsKt.assertContains$default((CharSequence)message, (CharSequence)"@HttpIngress-annotated echo request must be ftl.builtin.HttpRequest", (boolean)false, null, (int)12, null);
    }

    @AfterEach
    public final void cleanup() {
        File file = new File("schema.pb");
        file.delete();
    }

    private static final boolean setup$lambda$0(File file) {
        Intrinsics.checkNotNull((Object)file);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"kt");
    }

    private static final boolean extracts_schema$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }
}

