/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"FORMATTER", "Ljava/time/format/DateTimeFormatter;", "makeGson", "Lcom/google/gson/Gson;", "ftl-runtime"})
public final class SerializerKt {
    @NotNull
    private static final DateTimeFormatter FORMATTER;

    @NotNull
    public static final Gson makeGson() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)OffsetDateTime.class), SerializerKt::makeGson$lambda$0).registerTypeAdapter((Type)((Object)OffsetDateTime.class), SerializerKt::makeGson$lambda$1).registerTypeAdapter((Type)((Object)byte[].class), SerializerKt::makeGson$lambda$2).registerTypeAdapter((Type)((Object)byte[].class), SerializerKt::makeGson$lambda$3).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        return gson;
    }

    private static final JsonElement makeGson$lambda$0(OffsetDateTime src, Type type, JsonSerializationContext jsonSerializationContext) {
        return (JsonElement)new JsonPrimitive(FORMATTER.format(src));
    }

    private static final OffsetDateTime makeGson$lambda$1(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) {
        return OffsetDateTime.parse(json.getAsString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private static final JsonElement makeGson$lambda$2(byte[] src, Type type, JsonSerializationContext jsonSerializationContext) {
        return (JsonElement)new JsonPrimitive(Base64.getEncoder().encodeToString(src));
    }

    private static final byte[] makeGson$lambda$3(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) {
        return Base64.getDecoder().decode(json.getAsString());
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        Intrinsics.checkNotNull((Object)dateTimeFormatter);
        FORMATTER = dateTimeFormatter;
    }
}

