/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.registry;

import com.google.gson.Gson;
import ftl.test.VerbRequest;
import ftl.test.VerbResponse;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.block.ftl.Context;
import xyz.block.ftl.client.LoopbackVerbServiceClient;
import xyz.block.ftl.client.VerbServiceClient;
import xyz.block.ftl.registry.Ref;
import xyz.block.ftl.registry.Registry;
import xyz.block.ftl.serializer.SerializerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/block/ftl/registry/RegistryTest;", "", "()V", "gson", "Lcom/google/gson/Gson;", "verbRef", "Lxyz/block/ftl/registry/Ref;", "invoke", "", "moduleName", "registerAll", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nRegistryTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryTest.kt\nxyz/block/ftl/registry/RegistryTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1045#2:44\n*S KotlinDebug\n*F\n+ 1 RegistryTest.kt\nxyz/block/ftl/registry/RegistryTest\n*L\n31#1:44\n*E\n"})
public final class RegistryTest {
    @NotNull
    private final Gson gson = SerializerKt.makeGson();
    @NotNull
    private final Ref verbRef = new Ref("test", "verb");

    @Test
    public final void moduleName() {
        Registry registry = new Registry("ftl.test");
        registry.registerAll();
        Assertions.assertEquals((Object)"test", (Object)registry.getModuleName());
    }

    @Test
    public final void registerAll() {
        Registry registry = new Registry("ftl.test");
        registry.registerAll();
        Object[] objectArray = new Ref[]{new Ref("test", "echo"), new Ref("test", "time"), new Ref("test", "verb")};
        Iterable $this$sortedBy$iv = registry.getRefs();
        boolean $i$f$sortedBy = false;
        AssertionsKt.assertContentEquals$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */)), null, (int)4, null);
    }

    @Test
    public final void invoke() {
        Registry registry = new Registry("ftl.test");
        registry.registerAll();
        Context context = new Context("ftl.test", (VerbServiceClient)new LoopbackVerbServiceClient(registry));
        String string = this.gson.toJson((Object)new VerbRequest("test"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String result = registry.invoke(context, this.verbRef, string);
        Assertions.assertEquals((Object)result, (Object)this.gson.toJson((Object)new VerbResponse("test")));
    }
}

