/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.registry;

import ch.qos.logback.classic.Logger;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.Closeable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.ftl.Context;
import xyz.block.ftl.Cron;
import xyz.block.ftl.HttpIngress;
import xyz.block.ftl.Ignore;
import xyz.block.ftl.Verb;
import xyz.block.ftl.logging.Logging;
import xyz.block.ftl.registry.Ref;
import xyz.block.ftl.registry.RegistryKt;
import xyz.block.ftl.registry.VerbHandle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0003J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001dJ\f\u0010!\u001a\u00020\"*\u00020#H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lxyz/block/ftl/registry/Registry;", "", "jvmModuleName", "", "(Ljava/lang/String;)V", "ftlModuleName", "getJvmModuleName", "()Ljava/lang/String;", "logger", "Lch/qos/logback/classic/Logger;", "moduleName", "getModuleName", "refs", "", "Lxyz/block/ftl/registry/Ref;", "kotlin.jvm.PlatformType", "getRefs", "()Ljava/util/List;", "verbs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lxyz/block/ftl/registry/VerbHandle;", "invoke", "context", "Lxyz/block/ftl/Context;", "verbRef", "request", "list", "", "maybeRegisterVerb", "", "function", "Lkotlin/reflect/KFunction;", "registerAll", "hasVerbAnnotation", "", "Ljava/lang/reflect/Method;", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Registry.kt\nxyz/block/ftl/registry/Registry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n1373#2:105\n1461#2,5:106\n766#2:111\n857#2,2:112\n1855#2,2:114\n12474#3,2:116\n*S KotlinDebug\n*F\n+ 1 Registry.kt\nxyz/block/ftl/registry/Registry\n*L\n47#1:105\n47#1:106,5\n49#1:111\n49#1:112,2\n51#1:114,2\n65#1:116,2\n*E\n"})
public final class Registry {
    @NotNull
    private final String jvmModuleName;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<Ref, VerbHandle<?>> verbs;
    @Nullable
    private String ftlModuleName;

    public Registry(@NotNull String jvmModuleName) {
        Intrinsics.checkNotNullParameter((Object)jvmModuleName, (String)"jvmModuleName");
        this.jvmModuleName = jvmModuleName;
        this.logger = Logging.Companion.logger(Reflection.getOrCreateKotlinClass(Registry.class));
        this.verbs = new ConcurrentHashMap();
    }

    public /* synthetic */ Registry(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "ftl";
        }
        this(string);
    }

    @NotNull
    public final String getJvmModuleName() {
        return this.jvmModuleName;
    }

    @NotNull
    public final String getModuleName() {
        if (this.ftlModuleName == null) {
            throw new IllegalStateException("FTL module name not set, call one of the register* methods first");
        }
        String string = this.ftlModuleName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void registerAll() {
        this.logger.debug("Scanning for Verbs in " + this.jvmModuleName + "...");
        Object object = new String[]{this.jvmModuleName};
        object = (Closeable)new ClassGraph().enableAllInfo().acceptPackages(object).scan();
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object it;
            void $this$flatMapTo$iv$iv;
            ScanResult scanResult = (ScanResult)object;
            boolean bl = false;
            ClassInfoList classInfoList = scanResult.getAllClasses();
            Intrinsics.checkNotNullExpressionValue((Object)classInfoList, (String)"getAllClasses(...)");
            Iterable $this$flatMap$iv = (Iterable)classInfoList;
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (ClassInfo)element$iv$iv;
                boolean bl2 = false;
                Class clazz = it.loadClass();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"loadClass(...)");
                Method[] methodArray = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getKotlinClass((Class)clazz)).getDeclaredMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
                Sequence list$iv$iv = ArraysKt.asSequence((Object[])methodArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Method)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(this.hasVerbAnnotation((Method)it) && !((AccessibleObject)it).isAnnotationPresent(Ignore.class))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KFunction verb;
                Method it2 = (Method)element$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it2);
                Intrinsics.checkNotNull((Object)ReflectJvmMapping.getKotlinFunction((Method)it2));
                this.maybeRegisterVerb(verb);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public final List<Ref> getRefs() {
        Set set = this.verbs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    private final boolean hasVerbAnnotation(Method $this$hasVerbAnnotation) {
        boolean bl;
        block1: {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Verb.class), Reflection.getOrCreateKotlinClass(HttpIngress.class), Reflection.getOrCreateKotlinClass(Cron.class)};
            KClass[] $this$any$iv = kClassArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                KClass element$iv;
                KClass it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!$this$hasVerbAnnotation.isAnnotationPresent(JvmClassMappingKt.getJavaClass((KClass)it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final void maybeRegisterVerb(KFunction<?> function) {
        if (this.ftlModuleName == null) {
            this.ftlModuleName = RegistryKt.ftlModuleFromJvmModule(this.jvmModuleName, function);
        }
        this.logger.debug("      @Verb " + function.getName() + "()");
        String string = this.ftlModuleName;
        Intrinsics.checkNotNull((Object)string);
        Ref verbRef = new Ref(string, function.getName());
        VerbHandle verbHandle = new VerbHandle(function);
        if (this.verbs.containsKey(verbRef)) {
            throw new IllegalArgumentException("Duplicate Verb " + verbRef);
        }
        ((Map)this.verbs).put(verbRef, verbHandle);
    }

    @NotNull
    public final Set<Ref> list() {
        Set set = this.verbs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public final String invoke(@NotNull Context context, @NotNull Ref verbRef, @NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)verbRef, (String)"verbRef");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        VerbHandle<?> verbHandle = this.verbs.get(verbRef);
        if (verbHandle == null) {
            throw new IllegalArgumentException("Unknown verb: " + verbRef);
        }
        VerbHandle<?> verb = verbHandle;
        return verb.invokeVerbInternal(context, request);
    }

    public Registry() {
        this(null, 1, null);
    }
}

