/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.schemaextractor;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.DeclarationUtilKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import xyz.block.ftl.Database;
import xyz.block.ftl.Ignore;
import xyz.block.ftl.schemaextractor.ExtractSchemaRuleKt;
import xyz.block.ftl.schemaextractor.ModuleData;
import xyz.block.ftl.schemaextractor.SchemaExtractor;
import xyz.block.ftl.secrets.Secret;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.ErrorList;
import xyz.block.ftl.v1.schema.Module;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0014\u0010#\u001a\u00020$*\u00020\u000e2\u0006\u0010%\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lxyz/block/ftl/schemaextractor/ExtractSchemaRule;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "extractor", "Lxyz/block/ftl/schemaextractor/SchemaExtractor;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "modules", "", "", "Lxyz/block/ftl/schemaextractor/ModuleData;", "output", "getOutput", "()Ljava/lang/String;", "output$delegate", "Lkotlin/properties/ReadOnlyProperty;", "postVisit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "preVisit", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "writeFile", "content", "", "filename", "toModule", "Lxyz/block/ftl/v1/schema/Module;", "moduleName", "Companion", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nExtractSchemaRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractSchemaRule.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,818:1\n1747#2,3:819\n1045#2:823\n1#3:822\n*S KotlinDebug\n*F\n+ 1 ExtractSchemaRule.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRule\n*L\n140#1:819,3\n194#1:823\n*E\n"})
public final class ExtractSchemaRule
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty output$delegate;
    @NotNull
    private final Map<String, ModuleData> modules;
    @NotNull
    private SchemaExtractor extractor;
    @NotNull
    private final Issue issue;
    @NotNull
    public static final String SCHEMA_OUT = "schema.pb";
    @NotNull
    public static final String ERRORS_OUT = "errors.pb";

    public ExtractSchemaRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.output$delegate = ConfigPropertyKt.config((Object)".");
        this.modules = new LinkedHashMap();
        this.extractor = new SchemaExtractor(this.modules);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Performance, "Verifies and extracts FTL Schema", Debt.Companion.getFIVE_MINS());
    }

    private final String getOutput() {
        return (String)this.output$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    protected void preVisit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.extractor.setBindingContext(this.getBindingContext());
        this.extractor.addModuleComments(root);
    }

    public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
            if (!ExtractSchemaRuleKt.access$isVerbAnnotation(annotationEntry, this.getBindingContext())) {
                return;
            }
            KtDeclaration ktDeclaration = DeclarationUtilKt.containingNonLocalDeclaration((KtElement)((KtElement)annotationEntry));
            Intrinsics.checkNotNull((Object)ktDeclaration);
            List list = ktDeclaration.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqName fqName;
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)it);
                    String string = annotationDescriptor != null && (fqName = annotationDescriptor.getFqName()) != null ? fqName.asString() : null;
                    if (!Intrinsics.areEqual(string, (Object)Reflection.getOrCreateKotlinClass(Ignore.class).getQualifiedName())) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        PsiElement element = annotationEntry.getParent().getParent();
        if (element instanceof KtNamedFunction) {
            this.extractor.addVerbToSchema((KtNamedFunction)element);
        } else if (element instanceof KtClass) {
            if (((KtClass)element).isData()) {
                this.extractor.addDataToSchema((KtClass)element);
            } else if (((KtClass)element).isEnum()) {
                this.extractor.addEnumToSchema((KtClass)element);
            }
        }
    }

    public void visitProperty(@NotNull KtProperty property) {
        FqName fqName;
        KotlinType kotlinType;
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        DeclarationDescriptor declarationDescriptor = CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors((KtDeclaration)((KtDeclaration)property), (BindingContext)this.getBindingContext());
        String string = declarationDescriptor != null && (propertyDescriptor = SyntheticFieldDescriptorKt.getReferencedProperty((DeclarationDescriptor)declarationDescriptor)) != null && (kotlinType = propertyDescriptor.getReturnType()) != null && (fqName = TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType)) != null ? fqName.asString() : null;
        if (Intrinsics.areEqual(string, (Object)Reflection.getOrCreateKotlinClass(Database.class).getQualifiedName())) {
            this.extractor.addDatabaseToSchema(property);
        } else if (Intrinsics.areEqual(string, (Object)Reflection.getOrCreateKotlinClass(Secret.class).getQualifiedName())) {
            this.extractor.addSecretToSchema(property);
        } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(xyz.block.ftl.config.Config.class).getQualifiedName())) {
            this.extractor.addConfigToSchema(property);
        }
    }

    protected void postVisit(@NotNull KtFile root) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            ErrorList errors = this.extractor.getErrors();
            if (!((Collection)errors.getErrors()).isEmpty()) {
                this.writeFile(errors.encode(), ERRORS_OUT);
                throw new IllegalStateException("could not extract schema");
            }
            String moduleName = SchemaExtractor.Companion.extractModuleName((KtElement)root);
            ModuleData moduleData = this.modules.get(moduleName);
            if (moduleData == null) break block1;
            ModuleData it = moduleData;
            boolean bl = false;
            this.writeFile(this.toModule(it, moduleName).encode(), SCHEMA_OUT);
        }
    }

    private final void writeFile(byte[] content, String filename) {
        File file;
        File f = file = new File(this.getOutput());
        boolean bl = false;
        Path path = Path.of(f.getAbsolutePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        File outputDirectory = file;
        File file2 = new File(outputDirectory.getAbsolutePath(), filename);
        file2.createNewFile();
        FileOutputStream os = new FileOutputStream(file2);
        os.write(content);
        os.close();
    }

    private final Module toModule(ModuleData $this$toModule, String moduleName) {
        Iterable $this$sortedBy$iv = $this$toModule.getDecls();
        boolean $i$f$sortedBy = false;
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Decl it = (Decl)((Object)a);
                boolean bl = false;
                boolean bl2 = it.getData_() == null;
                it = (Decl)((Object)b);
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(it.getData_() == null));
            }
        });
        List<String> list2 = $this$toModule.getComments();
        return new Module(null, null, list2, false, moduleName, list, null, 75, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ExtractSchemaRule.class, "output", "getOutput()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lxyz/block/ftl/schemaextractor/ExtractSchemaRule$Companion;", "", "()V", "ERRORS_OUT", "", "SCHEMA_OUT", "ftl-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

