/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.schemaextractor;

import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.test.RuleExtensionsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import xyz.block.ftl.schemaextractor.ExtractSchemaRule;
import xyz.block.ftl.v1.schema.Array;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.DataRef;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.Map;
import xyz.block.ftl.v1.schema.MetadataCalls;
import xyz.block.ftl.v1.schema.MetadataIngress;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.String;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.Verb;
import xyz.block.ftl.v1.schema.VerbRef;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Disabled
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest;", "", "env", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "cleanup", "", "extracts schema", "fails if invalid schema type is included", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nExtractSchemaRuleTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractSchemaRuleTest.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,243:1\n124#2:244\n137#2,14:245\n*S KotlinDebug\n*F\n+ 1 ExtractSchemaRuleTest.kt\nxyz/block/ftl/schemaextractor/ExtractSchemaRuleTest\n*L\n232#1:244\n232#1:245,14\n*E\n"})
public final class ExtractSchemaRuleTest {
    @NotNull
    private final KotlinCoreEnvironment env;

    public ExtractSchemaRuleTest(@NotNull KotlinCoreEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (java.lang.String)"env");
        this.env = env;
    }

    @Test
    public final void extracts schema() {
        java.lang.String code = "\n        package ftl.echo\n\n        import ftl.time.TimeModuleClient\n        import ftl.time.TimeRequest\n        import ftl.time.TimeResponse\n        import xyz.block.ftl.Context\n        import xyz.block.ftl.Ingress\n        import xyz.block.ftl.Method\n        import xyz.block.ftl.Verb\n\n        class InvalidInput(val field: String) : Exception()\n\n        data class MapValue(val value: String)\n        data class EchoMessage(val message: String, val metadata: Map<String, MapValue>? = null)\n\n        /**\n         * Request to echo a message.\n         */\n        data class EchoRequest(val name: String)\n        data class EchoResponse(val messages: List<EchoMessage>)\n\n        /**\n         * Echo module.\n         */\n        class Echo {\n           /**\n            * Echoes the given message.\n            */\n            @Throws(InvalidInput::class)\n            @Verb\n            @Ingress(Method.GET, \"/echo\")\n            fun echo(context: Context, req: EchoRequest): EchoResponse {\n                callTime(context)\n                return EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n            }\n\n            fun callTime(context: Context): TimeResponse {\n                return context.call(TimeModuleClient::time, TimeRequest())\n            }\n        }\n        ";
        RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (java.lang.String)code);
        File file = new File("schema.pb");
        Module module = (Module)Module.ADAPTER.decode((InputStream)new FileInputStream(file));
        Object[] objectArray = new Decl[5];
        objectArray[0] = new Decl(new Data(null, "EchoRequest", CollectionsKt.listOf((Object)new Field(null, "name", null, new Type(null, null, new String(null, 1, null), null, null, null, null, null, null, null, 1019, null), null, 21, null)), null, CollectionsKt.listOf((Object)"/**\n         * Request to echo a message.\n         */"), null, 41, null), null, null, 6, null);
        objectArray[1] = new Decl(new Data(null, "MapValue", CollectionsKt.listOf((Object)new Field(null, "value", null, new Type(null, null, new String(null, 1, null), null, null, null, null, null, null, null, 1019, null), null, 21, null)), null, null, null, 57, null), null, null, 6, null);
        Object[] objectArray2 = new Field[]{new Field(null, "message", null, new Type(null, null, new String(null, 1, null), null, null, null, null, null, null, null, 1019, null), null, 21, null), new Field(null, "metadata", null, new Type(null, null, null, null, null, null, new Map(new Type(null, null, new String(null, 1, null), null, null, null, null, null, null, null, 1019, null), new Type(null, null, null, null, null, null, null, null, new DataRef(null, "MapValue", "echo", null, 9, null), null, 767, null), null, 4, null), null, null, null, 959, null), null, 21, null)};
        objectArray[2] = new Decl(new Data(null, "EchoMessage", CollectionsKt.listOf((Object[])objectArray2), null, null, null, 57, null), null, null, 6, null);
        objectArray[3] = new Decl(new Data(null, "EchoResponse", CollectionsKt.listOf((Object)new Field(null, "messages", null, new Type(null, null, null, null, null, new Array(new Type(null, null, null, null, null, null, null, null, new DataRef(null, "EchoMessage", "echo", null, 9, null), null, 767, null), null, 2, null), null, null, null, null, 991, null), null, 21, null)), null, null, null, 57, null), null, null, 6, null);
        objectArray2 = new xyz.block.ftl.v1.schema.Metadata[]{new xyz.block.ftl.v1.schema.Metadata(null, new MetadataIngress(null, "GET", "/echo", null, 9, null), null, 5, null), new xyz.block.ftl.v1.schema.Metadata(new MetadataCalls(null, CollectionsKt.listOf((Object)new VerbRef(null, "time", "time", null, 9, null)), null, 5, null), null, null, 6, null)};
        objectArray[4] = new Decl(null, new Verb(null, null, "echo", CollectionsKt.listOf((Object)"/**\n            * Echoes the given message.\n            */"), new DataRef(null, "EchoRequest", "echo", null, 9, null), new DataRef(null, "EchoResponse", "echo", null, 9, null), CollectionsKt.listOf((Object[])objectArray2), null, 131, null), null, 5, null);
        Module expected = new Module(null, null, "echo", CollectionsKt.listOf((Object)"/**\n         * Echo module.\n         */"), CollectionsKt.listOf((Object[])objectArray), null, 35, null);
        Assertions.assertEquals((Object)expected, (Object)module);
    }

    @Test
    public final void fails if invalid schema type is included() {
        Throwable throwable;
        Throwable throwable2;
        java.lang.String code = "\n        package ftl.echo\n\n        import ftl.time.TimeModuleClient\n        import ftl.time.TimeRequest\n        import ftl.time.TimeResponse\n        import xyz.block.ftl.Context\n        import xyz.block.ftl.Ingress\n        import xyz.block.ftl.Method\n        import xyz.block.ftl.Verb\n\n        class InvalidInput(val field: String) : Exception()\n\n        data class EchoMessage(val message: String, val metadata: Map<String, String>? = null)\n\n        /**\n         * Request to echo a message.\n         */\n        data class EchoRequest(val name: Any)\n        data class EchoResponse(val messages: List<EchoMessage>)\n\n        /**\n         * Echo module.\n         */\n        class Echo {\n           /**\n            * Echoes the given message.\n            */\n            @Throws(InvalidInput::class)\n            @Verb\n            @Ingress(Method.GET, \"/echo\")\n            fun echo(context: Context, req: EchoRequest): EchoResponse {\n                callTime(context)\n                return EchoResponse(messages = listOf(EchoMessage(message = \"Hello!\")))\n            }\n\n            fun callTime(context: Context): TimeResponse {\n                return context.call(TimeModuleClient::time, TimeRequest())\n            }\n        }\n        ";
        java.lang.String message$iv = "kotlin.Any type is not supported in FTL schema";
        boolean $i$f$assertThrows = false;
        Function0 message$iv$iv = (Function0)new /* Unavailable Anonymous Inner Class!! */;
        boolean $i$f$assertThrows2 = false;
        try {
            boolean bl = false;
            RuleExtensionsKt.compileAndLintWithContext((BaseRule)((BaseRule)new ExtractSchemaRule(Config.Companion.getEmpty())), (KotlinCoreEnvironment)this.env, (java.lang.String)code);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv$iv) {
            throwable2 = caught$iv$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv$iv = throwable;
        throwable2 = message$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)((Executable)new /* Unavailable Anonymous Inner Class!! */), (Supplier)((Supplier)new /* Unavailable Anonymous Inner Class!! */)), (java.lang.String)"Assertions.assertThrows(\u2026  Supplier(message)\n    )");
    }

    @AfterEach
    public final void cleanup() {
        File file = new File("schema.pb");
        file.delete();
    }
}

