/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.server;

import io.grpc.stub.StreamObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.Context;
import xyz.block.ftl.client.VerbServiceClient;
import xyz.block.ftl.registry.Registry;
import xyz.block.ftl.registry.RegistryKt;
import xyz.block.ftl.v1.CallRequest;
import xyz.block.ftl.v1.CallResponse;
import xyz.block.ftl.v1.PingRequest;
import xyz.block.ftl.v1.PingResponse;
import xyz.block.ftl.v1.VerbServiceWireGrpc;
import xyz.block.ftl.v1.schema.VerbRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lxyz/block/ftl/server/Server;", "Lxyz/block/ftl/v1/VerbServiceWireGrpc$VerbServiceImplBase;", "registry", "Lxyz/block/ftl/registry/Registry;", "routingClient", "Lxyz/block/ftl/client/VerbServiceClient;", "jvmModule", "", "(Lxyz/block/ftl/registry/Registry;Lxyz/block/ftl/client/VerbServiceClient;Ljava/lang/String;)V", "getJvmModule", "()Ljava/lang/String;", "getRegistry", "()Lxyz/block/ftl/registry/Registry;", "getRoutingClient", "()Lxyz/block/ftl/client/VerbServiceClient;", "Call", "", "request", "Lxyz/block/ftl/v1/CallRequest;", "response", "Lio/grpc/stub/StreamObserver;", "Lxyz/block/ftl/v1/CallResponse;", "Ping", "Lxyz/block/ftl/v1/PingRequest;", "Lxyz/block/ftl/v1/PingResponse;", "ftl-runtime"})
public final class Server
extends VerbServiceWireGrpc.VerbServiceImplBase {
    @NotNull
    private final Registry registry;
    @NotNull
    private final VerbServiceClient routingClient;
    @NotNull
    private final String jvmModule;

    public Server(@NotNull Registry registry, @NotNull VerbServiceClient routingClient, @NotNull String jvmModule) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)routingClient, (String)"routingClient");
        Intrinsics.checkNotNullParameter((Object)jvmModule, (String)"jvmModule");
        this.registry = registry;
        this.routingClient = routingClient;
        this.jvmModule = jvmModule;
    }

    public /* synthetic */ Server(Registry registry, VerbServiceClient verbServiceClient, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = RegistryKt.getDefaultJvmModuleName();
        }
        this(registry, verbServiceClient, string);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final VerbServiceClient getRoutingClient() {
        return this.routingClient;
    }

    @NotNull
    public final String getJvmModule() {
        return this.jvmModule;
    }

    public void Ping(@NotNull PingRequest request, @NotNull StreamObserver<PingResponse> response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        response.onNext((Object)new PingResponse(null, null, 3, null));
        response.onCompleted();
    }

    public void Call(@NotNull CallRequest request, @NotNull StreamObserver<CallResponse> response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        VerbRef verbRef = request.getVerb();
        if (verbRef == null) {
            response.onError((Throwable)new IllegalArgumentException("verb is required"));
            return;
        }
        String out = this.registry.invoke(new Context(this.jvmModule, this.routingClient), RegistryKt.toModel((VerbRef)verbRef), request.getBody().utf8());
        response.onNext((Object)new CallResponse(ByteString.Companion.encodeUtf8(out), null, null, 6, null));
        response.onCompleted();
    }
}

