/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.registry;

import com.google.gson.Gson;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import xyz.block.ftl.Context;
import xyz.block.ftl.client.LoopbackVerbServiceClient;
import xyz.block.ftl.client.VerbServiceClient;
import xyz.block.ftl.registry.ExampleVerb;
import xyz.block.ftl.registry.Registry;
import xyz.block.ftl.registry.RenamedVerb;
import xyz.block.ftl.registry.VerbRef;
import xyz.block.ftl.registry.VerbRequest;
import xyz.block.ftl.registry.VerbResponse;
import xyz.block.ftl.serializer.SerializerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lxyz/block/ftl/registry/RegistryTest;", "", "()V", "gson", "Lcom/google/gson/Gson;", "renamedVerbRef", "Lxyz/block/ftl/registry/VerbRef;", "verbRef", "invoke", "", "moduleName", "register", "registerAll", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nRegistryTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryTest.kt\nxyz/block/ftl/registry/RegistryTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1045#2:84\n*S KotlinDebug\n*F\n+ 1 RegistryTest.kt\nxyz/block/ftl/registry/RegistryTest\n*L\n61#1:84\n*E\n"})
public final class RegistryTest {
    @NotNull
    private final Gson gson = SerializerKt.makeGson();
    @NotNull
    private final VerbRef verbRef = new VerbRef("registry", "verb");
    @NotNull
    private final VerbRef renamedVerbRef = new VerbRef("registry", "something");

    @Test
    public final void moduleName() {
        Registry registry = new Registry("xyz.block.ftl");
        registry.register(Reflection.getOrCreateKotlinClass(ExampleVerb.class));
        Assertions.assertEquals((Object)"registry", (Object)registry.getModuleName());
    }

    @Test
    public final void register() {
        Registry registry = new Registry("xyz.block.ftl");
        registry.register(Reflection.getOrCreateKotlinClass(ExampleVerb.class));
        registry.register(Reflection.getOrCreateKotlinClass(RenamedVerb.class));
        Object[] objectArray = new VerbRef[]{this.renamedVerbRef, this.verbRef};
        Iterable $this$sortedBy$iv = registry.getRefs();
        boolean $i$f$sortedBy = false;
        AssertionsKt.assertContentEquals$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */)), null, (int)4, null);
    }

    @Test
    public final void invoke() {
        Registry registry = new Registry("xyz.block.ftl");
        registry.register(Reflection.getOrCreateKotlinClass(ExampleVerb.class));
        Context context = new Context("xyz.block.ftl", (VerbServiceClient)new LoopbackVerbServiceClient(registry));
        String string = this.gson.toJson((Object)new VerbRequest("test"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String result = registry.invoke(context, this.verbRef, string);
        Assertions.assertEquals((Object)result, (Object)this.gson.toJson((Object)new VerbResponse("test")));
    }

    @Disabled(value="Verbs defined in the tests don't seem to be stable.")
    @Test
    public final void registerAll() {
        Registry registry = new Registry("xyz.block");
        registry.registerAll();
    }
}

