/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.registry;

import ch.qos.logback.classic.Logger;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.ftl.Context;
import xyz.block.ftl.Ignore;
import xyz.block.ftl.Verb;
import xyz.block.ftl.logging.Logging;
import xyz.block.ftl.registry.RegistryKt;
import xyz.block.ftl.registry.VerbHandle;
import xyz.block.ftl.registry.VerbRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0003J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dJ.\u0010\u001e\u001a\u00020\u001f\"\b\b\u0000\u0010 *\u00020\u00012\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u0002H 0\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0016\u0010%\u001a\u00020\u001f2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\"J\u0006\u0010&\u001a\u00020\u001fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lxyz/block/ftl/registry/Registry;", "", "jvmModuleName", "", "(Ljava/lang/String;)V", "ftlModuleName", "getJvmModuleName", "()Ljava/lang/String;", "logger", "Lch/qos/logback/classic/Logger;", "moduleName", "getModuleName", "refs", "", "Lxyz/block/ftl/registry/VerbRef;", "kotlin.jvm.PlatformType", "getRefs", "()Ljava/util/List;", "verbs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lxyz/block/ftl/registry/VerbHandle;", "has", "", "verbRef", "invoke", "context", "Lxyz/block/ftl/Context;", "request", "list", "", "maybeRegisterVerb", "", "C", "klass", "Lkotlin/reflect/KClass;", "function", "Lkotlin/reflect/KFunction;", "register", "registerAll", "ftl-runtime"})
@SourceDebugExtension(value={"SMAP\nRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Registry.kt\nxyz/block/ftl/registry/Registry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,119:1\n1855#2:120\n288#2,2:123\n766#2:125\n857#2:126\n288#2,2:129\n858#2:131\n1855#2,2:132\n1856#2:134\n288#2,2:136\n29#3:121\n20#3:122\n29#3:127\n20#3:128\n20#3:135\n*S KotlinDebug\n*F\n+ 1 Registry.kt\nxyz/block/ftl/registry/Registry\n*L\n63#1:120\n65#1:123,2\n69#1:125\n69#1:126\n69#1:129,2\n69#1:131\n70#1:132,2\n63#1:134\n77#1:136,2\n65#1:121\n65#1:122\n69#1:127\n69#1:128\n77#1:135\n*E\n"})
public final class Registry {
    @NotNull
    private final String jvmModuleName;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<VerbRef, VerbHandle<?>> verbs;
    @Nullable
    private String ftlModuleName;

    public Registry(@NotNull String jvmModuleName) {
        Intrinsics.checkNotNullParameter((Object)jvmModuleName, (String)"jvmModuleName");
        this.jvmModuleName = jvmModuleName;
        this.logger = Logging.Companion.logger(Reflection.getOrCreateKotlinClass(Registry.class));
        this.verbs = new ConcurrentHashMap();
    }

    public /* synthetic */ Registry(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = RegistryKt.getDefaultJvmModuleName();
        }
        this(string);
    }

    @NotNull
    public final String getJvmModuleName() {
        return this.jvmModuleName;
    }

    @NotNull
    public final String getModuleName() {
        if (this.ftlModuleName == null) {
            throw new IllegalStateException("FTL module name not set, call one of the register* methods first");
        }
        String string = this.ftlModuleName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void register(@NotNull KClass<? extends Object> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        int count = 0;
        for (KCallable member : klass.getMembers()) {
            if (!(member instanceof KFunction)) continue;
            this.maybeRegisterVerb(klass, (KFunction)member);
            ++count;
        }
        if (count == 0) {
            throw new IllegalArgumentException("Class " + klass.getQualifiedName() + " has no @Verb methods");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void registerAll() {
        this.logger.info("Scanning for Verbs in " + this.jvmModuleName + "...");
        var2_1 = new String[]{this.jvmModuleName};
        v0 = new ClassGraph().enableAllInfo().acceptPackages(var2_1).scan().getClassesWithMethodAnnotation(Verb.class);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getClassesWithMethodAnnotation(...)");
        $this$forEach$iv = (Iterable)v0;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block8: {
                it = (ClassInfo)element$iv;
                $i$a$-forEach-Registry$registerAll$1 = false;
                v1 = it.loadClass();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"loadClass(...)");
                kClass = JvmClassMappingKt.getKotlinClass((Class)v1);
                $this$hasAnnotation$iv /* !! */  = (KAnnotatedElement)kClass;
                $i$f$hasAnnotation = false;
                $this$findAnnotation$iv$iv = $this$hasAnnotation$iv /* !! */ ;
                $i$f$findAnnotation = false;
                $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                $i$f$firstOrNull = false;
                for (T element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                    it$iv$iv = (Annotation)element$iv$iv$iv;
                    $i$a$-firstOrNull-KAnnotatedElements$findAnnotation$1$iv$iv = false;
                    if (!(it$iv$iv instanceof Ignore)) continue;
                    v2 = element$iv$iv$iv;
                    break block8;
                }
                v2 = null;
            }
            if ((Annotation)v2 != null) continue;
            $this$hasAnnotation$iv /* !! */  = KClasses.getDeclaredFunctions((KClass)kClass);
            $i$f$filter = false;
            $this$findAnnotation$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block10: {
                    block9: {
                        func = (KFunction)element$iv$iv;
                        $i$a$-filter-Registry$registerAll$1$1 = false;
                        $this$hasAnnotation$iv = (KAnnotatedElement)func;
                        $i$f$hasAnnotation = false;
                        $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
                        $i$f$findAnnotation = false;
                        $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                        $i$f$firstOrNull = false;
                        for (T element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                            it$iv$iv = (Annotation)element$iv$iv$iv;
                            $i$a$-firstOrNull-KAnnotatedElements$findAnnotation$1$iv$iv = false;
                            if (!(it$iv$iv instanceof Verb)) continue;
                            v3 = element$iv$iv$iv;
                            break block9;
                        }
                        v3 = null;
                    }
                    v4 = (Annotation)v3 != null;
                    if (!v4) ** GOTO lbl-1000
                    $this$hasAnnotation$iv = (KAnnotatedElement)func;
                    $i$f$hasAnnotation = false;
                    $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
                    $i$f$findAnnotation = false;
                    $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                    $i$f$firstOrNull = false;
                    for (T element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                        it$iv$iv = (Annotation)element$iv$iv$iv;
                        $i$a$-firstOrNull-KAnnotatedElements$findAnnotation$1$iv$iv = false;
                        if (!(it$iv$iv instanceof Ignore)) continue;
                        v5 = element$iv$iv$iv;
                        break block10;
                    }
                    v5 = null;
                }
                if (!((Annotation)v5 != null)) {
                    v6 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = false;
                }
                if (!v6) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                verb = (KFunction)element$iv;
                $i$a$-forEach-Registry$registerAll$1$2 = false;
                this.maybeRegisterVerb(kClass, verb);
            }
        }
    }

    @NotNull
    public final List<VerbRef> getRefs() {
        Set set = this.verbs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    private final <C> void maybeRegisterVerb(KClass<? extends C> klass, KFunction<?> function) {
        String verbName;
        Object v0;
        block5: {
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)function;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof Verb)) continue;
                v0 = element$iv$iv;
                break block5;
            }
            v0 = null;
        }
        Verb verb = (Verb)((Annotation)v0);
        if (verb == null) {
            return;
        }
        Verb verbAnnotation = verb;
        String string = verbName = Intrinsics.areEqual((Object)verbAnnotation.name(), (Object)"") ? function.getName() : verbAnnotation.name();
        if (this.ftlModuleName == null) {
            String moduleName;
            String string2 = klass.getQualifiedName();
            if (string2 == null) {
                throw new IllegalArgumentException("Class must have a qualified name");
            }
            String qualifiedName = string2;
            this.ftlModuleName = moduleName = RegistryKt.ftlModuleFromJvmModule(this.jvmModuleName, qualifiedName);
        }
        this.logger.info("      @Verb " + function.getName() + "()");
        String string3 = this.ftlModuleName;
        Intrinsics.checkNotNull((Object)string3);
        VerbRef verbRef = new VerbRef(string3, verbName);
        VerbHandle verbHandle = new VerbHandle(klass, function);
        if (this.verbs.containsKey(verbRef)) {
            throw new IllegalArgumentException("Duplicate Verb " + verbRef);
        }
        ((Map)this.verbs).put(verbRef, verbHandle);
    }

    @NotNull
    public final Set<VerbRef> list() {
        Set set = this.verbs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return set;
    }

    public final boolean has(@NotNull VerbRef verbRef) {
        Intrinsics.checkNotNullParameter((Object)verbRef, (String)"verbRef");
        return this.verbs.containsKey(verbRef);
    }

    @NotNull
    public final String invoke(@NotNull Context context, @NotNull VerbRef verbRef, @NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)verbRef, (String)"verbRef");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        VerbHandle<?> verbHandle = this.verbs.get(verbRef);
        if (verbHandle == null) {
            throw new IllegalArgumentException("Unknown verb: " + verbRef);
        }
        VerbHandle<?> verb = verbHandle;
        return verb.invokeVerbInternal(context, request);
    }

    public Registry() {
        this(null, 1, null);
    }
}

