/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.javalang.deployment;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.GeneratedRef;
import xyz.block.ftl.Subscription;
import xyz.block.ftl.TypeAlias;
import xyz.block.ftl.TypeAliasMapper;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.VerbClientDefinition;
import xyz.block.ftl.VerbClientEmpty;
import xyz.block.ftl.VerbClientSink;
import xyz.block.ftl.VerbClientSource;
import xyz.block.ftl.deployment.JVMCodeGenerator;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.Enum;
import xyz.block.ftl.v1.schema.EnumVariant;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Topic;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.Verb;

public class JavaCodeGenerator
extends JVMCodeGenerator {
    public static final String CLIENT = "Client";
    public static final String PACKAGE_PREFIX = "ftl.";
    protected static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    protected void generateTypeAliasMapper(String module, String name, String packageName, Optional<String> nativeTypeAlias, Path outputDir) throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)(JavaCodeGenerator.className((String)name) + "TypeAliasMapper")).addAnnotation(AnnotationSpec.builder(TypeAlias.class).addMember("name", "\"" + name + "\"", new Object[0]).addMember("module", "\"" + module + "\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (nativeTypeAlias.isEmpty()) {
            TypeVariableName finalType = TypeVariableName.get((String)"T");
            typeBuilder.addTypeVariable(finalType);
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeAliasMapper.class), (TypeName[])new TypeName[]{finalType, ClassName.get(String.class)}));
        } else {
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeAliasMapper.class), (TypeName[])new TypeName[]{ClassName.bestGuess((String)nativeTypeAlias.get()), ClassName.get(String.class)}));
        }
        TypeSpec theType = typeBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)theType).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateTopicSubscription(Module module, Topic data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        String thisType = JavaCodeGenerator.className((String)(data.getName() + "Subscription"));
        TypeSpec.Builder dataBuilder = TypeSpec.annotationBuilder((String)thisType).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (data.getEvent().hasRef()) {
            dataBuilder.addJavadoc("Subscription to the topic of type {@link $L}", new Object[]{data.getEvent().getRef().getName()});
        }
        dataBuilder.addAnnotation(AnnotationSpec.builder(Retention.class).addMember("value", "java.lang.annotation.RetentionPolicy.RUNTIME", new Object[0]).build());
        dataBuilder.addAnnotation(AnnotationSpec.builder(Subscription.class).addMember("topic", "\"" + data.getName() + "\"", new Object[0]).addMember("module", "\"" + module.getName() + "\"", new Object[0]).addMember("name", "\"" + data.getName() + "Subscription\"", new Object[0]).build());
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)dataBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateEnum(Module module, Enum data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        String thisType = JavaCodeGenerator.className((String)data.getName());
        TypeSpec.Builder dataBuilder = TypeSpec.enumBuilder((String)thisType).addAnnotation(AnnotationSpec.builder(GeneratedRef.class).addMember("name", "\"" + data.getName() + "\"", new Object[0]).addMember("module", "\"" + module.getName() + "\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (EnumVariant i : data.getVariantsList()) {
            dataBuilder.addEnumConstant(i.getName());
        }
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)dataBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateDataObject(Module module, Data data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        String thisType = JavaCodeGenerator.className((String)data.getName());
        TypeSpec.Builder dataBuilder = TypeSpec.classBuilder((String)thisType).addAnnotation(AnnotationSpec.builder(GeneratedRef.class).addMember("name", "\"" + data.getName() + "\"", new Object[0]).addMember("module", "\"" + module.getName() + "\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder allConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        dataBuilder.addMethod(allConstructor.build());
        for (Object param : data.getTypeParametersList()) {
            dataBuilder.addTypeVariable(TypeVariableName.get((String)param.getName()));
        }
        TreeMap<String, Runnable> sortedFields = new TreeMap<String, Runnable>();
        for (Field i : data.getFieldsList()) {
            TypeName dataType = this.toAnnotatedJavaTypeName(i.getType(), typeAliasMap, nativeTypeAliasMap);
            String name = i.getName();
            String fieldName = this.toJavaName(name);
            dataBuilder.addField(dataType, fieldName, new Modifier[]{Modifier.PRIVATE});
            sortedFields.put(fieldName, () -> {
                allConstructor.addParameter(dataType, fieldName, new Modifier[0]);
                allConstructor.addCode("this.$L = $L;\n", new Object[]{fieldName, fieldName});
            });
            String methodName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            dataBuilder.addMethod(MethodSpec.methodBuilder((String)("set" + methodName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(dataType, fieldName, new Modifier[0]).returns((TypeName)ClassName.get((String)packageName, (String)thisType, (String[])new String[0])).addCode("this.$L = $L;\n", new Object[]{fieldName, fieldName}).addCode("return this;", new Object[0]).build());
            if (i.getType().hasBool()) {
                dataBuilder.addMethod(MethodSpec.methodBuilder((String)("is" + methodName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(dataType).addCode("return $L;", new Object[]{fieldName}).build());
                continue;
            }
            dataBuilder.addMethod(MethodSpec.methodBuilder((String)("get" + methodName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(dataType).addCode("return $L;", new Object[]{fieldName}).build());
        }
        if (!sortedFields.isEmpty()) {
            for (Runnable v : sortedFields.values()) {
                v.run();
            }
            dataBuilder.addMethod(allConstructor.build());
        }
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)dataBuilder.build()).build();
        javaFile.writeTo(outputDir);
    }

    protected void generateVerb(Module module, Verb verb, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Path outputDir) throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)(JavaCodeGenerator.className((String)verb.getName()) + CLIENT)).addAnnotation(AnnotationSpec.builder(VerbClientDefinition.class).addMember("name", "\"" + verb.getName() + "\"", new Object[0]).addMember("module", "\"" + module.getName() + "\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (verb.getRequest().hasUnit() && verb.getResponse().hasUnit()) {
            typeBuilder.addSuperinterface((TypeName)ClassName.get(VerbClientEmpty.class));
        } else if (verb.getRequest().hasUnit()) {
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VerbClientSource.class), (TypeName[])new TypeName[]{this.toJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap, true)}));
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"call").returns(this.toAnnotatedJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap)).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        } else if (verb.getResponse().hasUnit()) {
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VerbClientSink.class), (TypeName[])new TypeName[]{this.toJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap, true)}));
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"call").returns(TypeName.VOID).addParameter(this.toAnnotatedJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap), "value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        } else {
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VerbClient.class), (TypeName[])new TypeName[]{this.toJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap, true), this.toJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap, true)}));
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)"call").returns(this.toAnnotatedJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap)).addParameter(this.toAnnotatedJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap), "value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        }
        TypeSpec helloWorld = typeBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)helloWorld).build();
        javaFile.writeTo(outputDir);
    }

    private String toJavaName(String name) {
        if (JAVA_KEYWORDS.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private TypeName toAnnotatedJavaTypeName(Type type, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap) {
        TypeName results = this.toJavaTypeName(type, typeAliasMap, nativeTypeAliasMap, false);
        if (type.hasRef() || type.hasArray() || type.hasBytes() || type.hasString() || type.hasMap() || type.hasTime()) {
            return results.annotated(new AnnotationSpec[]{AnnotationSpec.builder(NotNull.class).build()});
        }
        return results;
    }

    private TypeName toJavaTypeName(Type type, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, boolean boxPrimitives) {
        if (type.hasArray()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.toJavaTypeName(type.getArray().getElement(), typeAliasMap, nativeTypeAliasMap, false)});
        }
        if (type.hasString()) {
            return ClassName.get(String.class);
        }
        if (type.hasOptional()) {
            return this.toJavaTypeName(type.getOptional().getType(), typeAliasMap, nativeTypeAliasMap, true);
        }
        if (type.hasRef()) {
            if (type.getRef().getModule().isEmpty()) {
                return TypeVariableName.get((String)type.getRef().getName());
            }
            JVMCodeGenerator.DeclRef key = new JVMCodeGenerator.DeclRef(type.getRef().getModule(), type.getRef().getName());
            if (nativeTypeAliasMap.containsKey(key)) {
                return ClassName.bestGuess((String)nativeTypeAliasMap.get(key));
            }
            if (typeAliasMap.containsKey(key)) {
                return this.toJavaTypeName(typeAliasMap.get(key), typeAliasMap, nativeTypeAliasMap, boxPrimitives);
            }
            List params = type.getRef().getTypeParametersList();
            ClassName className = ClassName.get((String)(PACKAGE_PREFIX + type.getRef().getModule()), (String)type.getRef().getName(), (String[])new String[0]);
            if (params.isEmpty()) {
                return className;
            }
            List<TypeName> javaTypes = params.stream().map(s -> s.hasUnit() ? WildcardTypeName.subtypeOf(Object.class) : this.toJavaTypeName((Type)s, typeAliasMap, nativeTypeAliasMap, true)).toList();
            return ParameterizedTypeName.get((ClassName)className, (TypeName[])javaTypes.toArray(new TypeName[javaTypes.size()]));
        }
        if (type.hasMap()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.toJavaTypeName(type.getMap().getKey(), typeAliasMap, nativeTypeAliasMap, true), this.toJavaTypeName(type.getMap().getValue(), typeAliasMap, nativeTypeAliasMap, true)});
        }
        if (type.hasTime()) {
            return ClassName.get(ZonedDateTime.class);
        }
        if (type.hasInt()) {
            return boxPrimitives ? ClassName.get(Long.class) : TypeName.LONG;
        }
        if (type.hasUnit()) {
            return TypeName.VOID;
        }
        if (type.hasBool()) {
            return boxPrimitives ? ClassName.get(Boolean.class) : TypeName.BOOLEAN;
        }
        if (type.hasFloat()) {
            return boxPrimitives ? ClassName.get(Double.class) : TypeName.DOUBLE;
        }
        if (type.hasBytes()) {
            return ArrayTypeName.of((TypeName)TypeName.BYTE);
        }
        if (type.hasAny()) {
            return TypeName.OBJECT;
        }
        throw new RuntimeException("Cannot generate Java type name: " + type);
    }
}

