/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.javalang.deployment;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.ConsumableTopic;
import xyz.block.ftl.EmptyVerb;
import xyz.block.ftl.Enum;
import xyz.block.ftl.EnumHolder;
import xyz.block.ftl.FunctionVerb;
import xyz.block.ftl.GeneratedRef;
import xyz.block.ftl.SQLQueryClient;
import xyz.block.ftl.SinkVerb;
import xyz.block.ftl.SourceVerb;
import xyz.block.ftl.Topic;
import xyz.block.ftl.TypeAlias;
import xyz.block.ftl.TypeAliasMapper;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.deployment.JVMCodeGenerator;
import xyz.block.ftl.deployment.PackageOutput;
import xyz.block.ftl.deployment.VerbType;
import xyz.block.ftl.schema.v1.AliasKind;
import xyz.block.ftl.schema.v1.Data;
import xyz.block.ftl.schema.v1.EnumVariant;
import xyz.block.ftl.schema.v1.Field;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataAlias;
import xyz.block.ftl.schema.v1.MetadataSQLQuery;
import xyz.block.ftl.schema.v1.Module;
import xyz.block.ftl.schema.v1.Type;
import xyz.block.ftl.schema.v1.Value;
import xyz.block.ftl.schema.v1.Verb;

public class JavaCodeGenerator
extends JVMCodeGenerator {
    public static final String CLIENT = "Client";
    public static final String PACKAGE_PREFIX = "ftl.";
    protected static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    protected void generateTypeAliasMapper(String module, xyz.block.ftl.schema.v1.TypeAlias typeAlias, String packageName, Optional<String> nativeTypeAlias, PackageOutput outputDir) throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)(JavaCodeGenerator.className((String)typeAlias.getName()) + "TypeAliasMapper")).addAnnotation(AnnotationSpec.builder(TypeAlias.class).addMember("name", "\"" + typeAlias.getName() + "\"", new Object[0]).addMember("module", "\"" + module + "\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)typeAlias.getCommentsList()), new Object[0]);
        if (nativeTypeAlias.isEmpty()) {
            TypeVariableName finalType = TypeVariableName.get((String)"T");
            typeBuilder.addTypeVariable(finalType);
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeAliasMapper.class), (TypeName[])new TypeName[]{finalType, ClassName.get(String.class)}));
        } else {
            typeBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeAliasMapper.class), (TypeName[])new TypeName[]{ClassName.bestGuess((String)nativeTypeAlias.get()), ClassName.get(String.class)}));
        }
        TypeSpec theType = typeBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)theType).build();
        javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
    }

    protected void generateTopicConsumer(Module module, xyz.block.ftl.schema.v1.Topic data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, PackageOutput outputDir) throws IOException {
        String thisType = JavaCodeGenerator.className((String)data.getName());
        TypeSpec.Builder dataBuilder = TypeSpec.interfaceBuilder((String)thisType).addModifiers(new Modifier[]{Modifier.PUBLIC});
        dataBuilder.addSuperinterface(ConsumableTopic.class);
        if (data.getEvent().hasRef()) {
            dataBuilder.addJavadoc("Topic {@link $L}", new Object[]{data.getEvent().getRef().getName()});
        }
        int partitions = 1;
        for (Metadata metadata : data.getMetadataList()) {
            if (!metadata.hasPartitions()) continue;
            partitions = (int)metadata.getPartitions().getPartitions();
            break;
        }
        dataBuilder.addAnnotation(AnnotationSpec.builder(Topic.class).addMember("name", "\"" + data.getName() + "\"", new Object[0]).addMember("module", "\"" + module.getName() + "\"", new Object[0]).addMember("partitions", String.valueOf(partitions), new Object[0]).build());
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)dataBuilder.build()).build();
        javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
    }

    protected void generateEnum(Module module, xyz.block.ftl.schema.v1.Enum ennum, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Map<JVMCodeGenerator.DeclRef, List<JVMCodeGenerator.EnumInfo>> enumVariantInfoMap, PackageOutput outputDir) throws IOException {
        String interfaceType = JavaCodeGenerator.className((String)ennum.getName());
        if (ennum.hasType()) {
            TypeSpec.Builder dataBuilder = TypeSpec.enumBuilder((String)interfaceType).addAnnotation(JavaCodeGenerator.getGeneratedRefAnnotation(module.getName(), ennum.getName())).addAnnotation(AnnotationSpec.builder(Enum.class).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ennum.getCommentsList()), new Object[0]);
            TypeName enumType = this.toAnnotatedJavaTypeName(ennum.getType(), typeAliasMap, nativeTypeAliasMap);
            dataBuilder.addField(enumType, "value", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            dataBuilder.addMethod(MethodSpec.constructorBuilder().addParameter(enumType, "value", new Modifier[0]).addStatement("this.value = value", new Object[0]).build());
            dataBuilder.addMethod(JavaCodeGenerator.makeGetMethod("Value", enumType, "return value"));
            String format = ennum.getType().hasString() ? "$S" : "$L";
            for (EnumVariant i : ennum.getVariantsList()) {
                Object value = this.toJavaValue(i.getValue());
                dataBuilder.addEnumConstant(JavaCodeGenerator.camelToUpperSnake((String)i.getName()), TypeSpec.anonymousClassBuilder((String)format, (Object[])new Object[]{value}).build());
            }
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)dataBuilder.build()).build();
            javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
        } else {
            TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)interfaceType).addAnnotation(JavaCodeGenerator.getGeneratedRefAnnotation(module.getName(), ennum.getName())).addAnnotation(AnnotationSpec.builder(Enum.class).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ennum.getCommentsList()), new Object[0]);
            Map<String, TypeName> variantValuesTypes = ennum.getVariantsList().stream().collect(Collectors.toMap(EnumVariant::getName, v -> this.toAnnotatedJavaTypeName(v.getValue().getTypeValue().getValue(), typeAliasMap, nativeTypeAliasMap)));
            for (EnumVariant variant : ennum.getVariantsList()) {
                String name = variant.getName();
                TypeName valueType = variantValuesTypes.get(name);
                interfaceBuilder.addMethod(MethodSpec.methodBuilder((String)("is" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(JsonIgnore.class).returns(TypeName.BOOLEAN).build());
                interfaceBuilder.addMethod(MethodSpec.methodBuilder((String)("get" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(JsonIgnore.class).returns(valueType).build());
                if (variant.getValue().getTypeValue().getValue().hasRef()) {
                    JVMCodeGenerator.DeclRef key = new JVMCodeGenerator.DeclRef(module.getName(), name);
                    List variantInfos = enumVariantInfoMap.computeIfAbsent(key, k -> new ArrayList());
                    variantInfos.add(new JVMCodeGenerator.EnumInfo(interfaceType, variant, ennum.getVariantsList()));
                    continue;
                }
                TypeSpec.Builder dataBuilder = TypeSpec.classBuilder((String)JavaCodeGenerator.className((String)name)).addAnnotation(JavaCodeGenerator.getGeneratedRefAnnotation(module.getName(), name)).addAnnotation(AnnotationSpec.builder(EnumHolder.class).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
                dataBuilder.addField(valueType, "value", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                dataBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("this.value = null", new Object[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
                dataBuilder.addMethod(MethodSpec.constructorBuilder().addParameter(valueType, "value", new Modifier[0]).addStatement("this.value = value", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
                JavaCodeGenerator.addTypeEnumInterfaceMethods(packageName, interfaceType, dataBuilder, name, valueType, variantValuesTypes, false);
                JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)dataBuilder.build()).build();
                javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
            }
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)interfaceBuilder.build()).build();
            javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
        }
    }

    protected void generateDataObject(Module module, Data data, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, Map<JVMCodeGenerator.DeclRef, List<JVMCodeGenerator.EnumInfo>> enumVariantInfoMap, PackageOutput outputDir) throws IOException {
        JVMCodeGenerator.DeclRef key;
        String thisType = JavaCodeGenerator.className((String)data.getName());
        TypeSpec.Builder dataBuilder = TypeSpec.classBuilder((String)thisType).addAnnotation(JavaCodeGenerator.getGeneratedRefAnnotation(module.getName(), data.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)data.getCommentsList()), new Object[0]);
        if (data.getMetadataList().stream().anyMatch(m -> m.hasGenerated())) {
            dataBuilder.addJavadoc("Generated data type for use with SQL query verbs", new Object[0]);
        }
        if (enumVariantInfoMap.containsKey(key = new JVMCodeGenerator.DeclRef(module.getName(), data.getName()))) {
            for (JVMCodeGenerator.EnumInfo enumInfo : enumVariantInfoMap.get(key)) {
                String name = enumInfo.variant().getName();
                ClassName variantTypeName = ClassName.get((String)packageName, (String)name, (String[])new String[0]);
                Map<String, TypeName> variantValuesTypes = enumInfo.otherVariants().stream().collect(Collectors.toMap(EnumVariant::getName, v -> this.toAnnotatedJavaTypeName(v.getValue().getTypeValue().getValue(), typeAliasMap, nativeTypeAliasMap)));
                JavaCodeGenerator.addTypeEnumInterfaceMethods(packageName, enumInfo.interfaceType(), dataBuilder, name, (TypeName)variantTypeName, variantValuesTypes, true);
            }
        }
        MethodSpec.Builder allConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        dataBuilder.addMethod(allConstructor.build());
        for (Object param : data.getTypeParametersList()) {
            dataBuilder.addTypeVariable(TypeVariableName.get((String)param.getName()));
        }
        TreeMap<String, Runnable> treeMap = new TreeMap<String, Runnable>();
        for (Field i : data.getFieldsList()) {
            TypeName dataType = this.toAnnotatedJavaTypeName(i.getType(), typeAliasMap, nativeTypeAliasMap);
            String name = i.getName();
            String fieldName = this.toJavaName(name);
            dataBuilder.addField(dataType, fieldName, new Modifier[]{Modifier.PRIVATE});
            treeMap.put(fieldName, () -> {
                allConstructor.addParameter(dataType, fieldName, new Modifier[0]);
                allConstructor.addCode("this.$L = $L;\n", new Object[]{fieldName, fieldName});
            });
            ArrayList<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
            List aliases = i.getMetadataList().stream().filter(Metadata::hasAlias).map(Metadata::getAlias).filter(m -> m.getKind() == AliasKind.ALIAS_KIND_JSON).map(MetadataAlias::getAlias).filter(s -> !s.equals(fieldName)).collect(Collectors.toList());
            if (!aliases.isEmpty()) {
                annotations.add(AnnotationSpec.builder(JsonAlias.class).addMember("value", "{$L}", new Object[]{String.join((CharSequence)",", aliases)}).build());
            }
            String methodName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            dataBuilder.addMethod(MethodSpec.methodBuilder((String)("set" + methodName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(dataType, fieldName, new Modifier[0]).returns((TypeName)ClassName.get((String)packageName, (String)thisType, (String[])new String[0])).addCode("this.$L = $L;\n", new Object[]{fieldName, fieldName}).addCode("return this;", new Object[0]).build());
            if (i.getType().hasBool()) {
                dataBuilder.addMethod(MethodSpec.methodBuilder((String)("is" + methodName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(dataType).addCode("return $L;", new Object[]{fieldName}).addAnnotations(annotations).build());
                continue;
            }
            dataBuilder.addMethod(MethodSpec.methodBuilder((String)("get" + methodName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(dataType).addCode("return $L;", new Object[]{fieldName}).addAnnotations(annotations).build());
        }
        if (!treeMap.isEmpty()) {
            for (Runnable v2 : treeMap.values()) {
                v2.run();
            }
            dataBuilder.addMethod(allConstructor.build());
        }
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)dataBuilder.build()).build();
        javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
    }

    protected void generateVerb(Module module, Verb verb, String packageName, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, PackageOutput outputDir) throws IOException {
        String verbName = verb.getName();
        TypeSpec.Builder clientBuilder = TypeSpec.interfaceBuilder((String)(JavaCodeGenerator.className((String)verbName) + CLIENT)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("A client for the $L.$L verb", new Object[]{module.getName(), verbName}).addAnnotation(AnnotationSpec.builder(VerbClient.class).addMember("module", "\"" + module.getName() + "\"", new Object[0]).addMember("name", "\"" + verb.getName() + "\"", new Object[0]).build());
        String comments = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)verb.getCommentsList());
        if (verb.getRequest().hasUnit() && verb.getResponse().hasUnit()) {
            clientBuilder.addSuperinterface((TypeName)ClassName.get(EmptyVerb.class));
            clientBuilder.addMethod(MethodSpec.methodBuilder((String)"call").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).build()).addJavadoc(comments, new Object[0]);
        } else if (verb.getRequest().hasUnit()) {
            clientBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SourceVerb.class), (TypeName[])new TypeName[]{this.toJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap, true)}));
            clientBuilder.addMethod(MethodSpec.methodBuilder((String)"call").returns(this.toBoxedAnnotatedJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap)).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addJavadoc(comments, new Object[0]).build());
        } else if (verb.getResponse().hasUnit()) {
            clientBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SinkVerb.class), (TypeName[])new TypeName[]{this.toJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap, true)}));
            clientBuilder.addMethod(MethodSpec.methodBuilder((String)"call").returns(TypeName.VOID).addParameter(this.toBoxedAnnotatedJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap), "value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addJavadoc(comments, new Object[0]).build());
        } else {
            clientBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(FunctionVerb.class), (TypeName[])new TypeName[]{this.toJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap, true), this.toJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap, true)}));
            clientBuilder.addMethod(MethodSpec.methodBuilder((String)"call").returns(this.toBoxedAnnotatedJavaTypeName(verb.getResponse(), typeAliasMap, nativeTypeAliasMap)).addParameter(this.toBoxedAnnotatedJavaTypeName(verb.getRequest(), typeAliasMap, nativeTypeAliasMap), "value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addJavadoc(comments, new Object[0]).build());
        }
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)clientBuilder.build()).build();
        javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
    }

    protected void generateSQLQueryVerb(Module module, Verb verb, String dbName, MetadataSQLQuery queryMetadata, String packageName, PackageOutput outputDir) throws IOException {
        CharSequence[] fields;
        List sqlFields;
        String verbName = verb.getName();
        TypeSpec.Builder clientBuilder = TypeSpec.interfaceBuilder((String)(JavaCodeGenerator.className((String)verbName) + CLIENT)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("A client for the $L.$L SQL query verb", new Object[]{module.getName(), verbName});
        Object methodName = verbName;
        if (JAVA_KEYWORDS.contains(verbName)) {
            methodName = verbName + "_";
        }
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder(SQLQueryClient.class).addMember("command", "$S", new Object[]{queryMetadata.getCommand()}).addMember("rawSQL", "\"$L\"", new Object[]{queryMetadata.getQuery()}).addMember("module", "$S", new Object[]{module.getName()}).addMember("dbName", "$S", new Object[]{dbName});
        MethodSpec.Builder callMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addJavadoc(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)verb.getCommentsList()), new Object[0]);
        VerbType verbType = VerbType.of((Verb)verb);
        if (verbType == VerbType.SOURCE || verbType == VerbType.VERB) {
            sqlFields = this.getOrderedSQLFields(module, verb.getResponse());
            fields = (String[])sqlFields.stream().map(m -> "\"" + m.metadata().getName() + "," + this.toJavaName(m.name()) + "\"").toArray(String[]::new);
            annotationBuilder.addMember("colToFieldName", "{$L}", new Object[]{String.join((CharSequence)",", fields)});
            callMethod.returns(this.toAnnotatedJavaTypeName(verb.getResponse(), new HashMap<JVMCodeGenerator.DeclRef, Type>(), new HashMap<JVMCodeGenerator.DeclRef, String>()));
        }
        if (verbType == VerbType.SINK || verbType == VerbType.VERB) {
            sqlFields = this.getOrderedSQLFields(module, verb.getRequest());
            fields = (String[])sqlFields.stream().map(m -> "\"" + this.toJavaName(m.name()) + "\"").toArray(String[]::new);
            annotationBuilder.addMember("fields", "{$L}", new Object[]{String.join((CharSequence)",", fields)});
            callMethod.addParameter(this.toAnnotatedJavaTypeName(verb.getRequest(), new HashMap<JVMCodeGenerator.DeclRef, Type>(), new HashMap<JVMCodeGenerator.DeclRef, String>()), "value", new Modifier[0]);
        }
        callMethod.addAnnotation(annotationBuilder.build());
        clientBuilder.addMethod(callMethod.build());
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)clientBuilder.build()).build();
        javaFile.writeTo((Appendable)outputDir.writeJava(javaFile.toJavaFileObject().getName()));
    }

    private String toJavaName(String name) {
        if (JAVA_KEYWORDS.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private TypeName toAnnotatedJavaTypeName(Type type, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap) {
        TypeName results = this.toJavaTypeName(type, typeAliasMap, nativeTypeAliasMap, false);
        if (type.hasRef() || type.hasArray() || type.hasBytes() || type.hasString() || type.hasMap() || type.hasTime()) {
            return results.annotated(new AnnotationSpec[]{AnnotationSpec.builder(NotNull.class).build()});
        }
        return results;
    }

    private TypeName toBoxedAnnotatedJavaTypeName(Type type, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap) {
        TypeName results = this.toJavaTypeName(type, typeAliasMap, nativeTypeAliasMap, true);
        if (type.hasRef() || type.hasArray() || type.hasBytes() || type.hasString() || type.hasMap() || type.hasTime()) {
            return results.annotated(new AnnotationSpec[]{AnnotationSpec.builder(NotNull.class).build()});
        }
        return results;
    }

    private TypeName toJavaTypeName(Type type, Map<JVMCodeGenerator.DeclRef, Type> typeAliasMap, Map<JVMCodeGenerator.DeclRef, String> nativeTypeAliasMap, boolean boxPrimitives) {
        if (type.hasArray()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.toJavaTypeName(type.getArray().getElement(), typeAliasMap, nativeTypeAliasMap, true)});
        }
        if (type.hasString()) {
            return ClassName.get(String.class);
        }
        if (type.hasOptional()) {
            return this.toJavaTypeName(type.getOptional().getType(), typeAliasMap, nativeTypeAliasMap, true);
        }
        if (type.hasRef()) {
            if (type.getRef().getModule().isEmpty()) {
                return TypeVariableName.get((String)type.getRef().getName());
            }
            JVMCodeGenerator.DeclRef key = new JVMCodeGenerator.DeclRef(type.getRef().getModule(), type.getRef().getName());
            if (nativeTypeAliasMap.containsKey(key)) {
                return ClassName.bestGuess((String)nativeTypeAliasMap.get(key));
            }
            if (typeAliasMap.containsKey(key)) {
                return this.toJavaTypeName(typeAliasMap.get(key), typeAliasMap, nativeTypeAliasMap, boxPrimitives);
            }
            List params = type.getRef().getTypeParametersList();
            ClassName className = ClassName.get((String)(PACKAGE_PREFIX + type.getRef().getModule()), (String)type.getRef().getName(), (String[])new String[0]);
            if (params.isEmpty()) {
                return className;
            }
            List<TypeName> javaTypes = params.stream().map(s -> s.hasUnit() ? WildcardTypeName.subtypeOf(Object.class) : this.toJavaTypeName((Type)s, typeAliasMap, nativeTypeAliasMap, true)).toList();
            return ParameterizedTypeName.get((ClassName)className, (TypeName[])javaTypes.toArray(new TypeName[javaTypes.size()]));
        }
        if (type.hasMap()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.toJavaTypeName(type.getMap().getKey(), typeAliasMap, nativeTypeAliasMap, true), this.toJavaTypeName(type.getMap().getValue(), typeAliasMap, nativeTypeAliasMap, true)});
        }
        if (type.hasTime()) {
            return ClassName.get(ZonedDateTime.class);
        }
        if (type.hasInt()) {
            return boxPrimitives ? ClassName.get(Long.class) : TypeName.LONG;
        }
        if (type.hasUnit()) {
            return TypeName.VOID;
        }
        if (type.hasBool()) {
            return boxPrimitives ? ClassName.get(Boolean.class) : TypeName.BOOLEAN;
        }
        if (type.hasFloat()) {
            return boxPrimitives ? ClassName.get(Double.class) : TypeName.DOUBLE;
        }
        if (type.hasBytes()) {
            return ArrayTypeName.of((TypeName)TypeName.BYTE);
        }
        if (type.hasAny()) {
            return TypeName.OBJECT;
        }
        throw new RuntimeException("Cannot generate Java type name: " + String.valueOf(type));
    }

    private Object toJavaValue(Value value) {
        if (value.hasIntValue()) {
            return value.getIntValue().getValue();
        }
        if (value.hasStringValue()) {
            return value.getStringValue().getValue();
        }
        if (value.hasTypeValue()) {
            throw new RuntimeException("Cannot generate TypeValue: " + String.valueOf(value));
        }
        throw new RuntimeException("Cannot generate Java value: " + String.valueOf(value));
    }

    private static void addTypeEnumInterfaceMethods(String packageName, String interfaceType, TypeSpec.Builder dataBuilder, String enumVariantName, TypeName variantTypeName, Map<String, TypeName> variantValuesTypes, boolean returnSelf) {
        dataBuilder.addSuperinterface((TypeName)ClassName.get((String)packageName, (String)interfaceType, (String[])new String[0]));
        dataBuilder.addMethod(JavaCodeGenerator.makeIsMethod(enumVariantName, true));
        dataBuilder.addMethod(JavaCodeGenerator.makeGetMethod(enumVariantName, variantTypeName, "return " + (returnSelf ? "this" : "value")));
        for (Map.Entry<String, TypeName> variant : variantValuesTypes.entrySet()) {
            if (variant.getKey().equals(enumVariantName)) continue;
            dataBuilder.addMethod(JavaCodeGenerator.makeIsMethod(variant.getKey(), false));
            dataBuilder.addMethod(JavaCodeGenerator.makeGetMethod(variant.getKey(), variant.getValue(), "throw new UnsupportedOperationException()"));
        }
    }

    @NotNull
    private static MethodSpec makeIsMethod(String name, boolean val) {
        return MethodSpec.methodBuilder((String)("is" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(JsonIgnore.class).returns(TypeName.BOOLEAN).addStatement("return " + val, new Object[0]).build();
    }

    @NotNull
    private static MethodSpec makeGetMethod(String name, TypeName enumType, String returnStatement) {
        return MethodSpec.methodBuilder((String)("get" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(JsonIgnore.class).returns(enumType).addStatement(returnStatement, new Object[0]).build();
    }

    @NotNull
    private static AnnotationSpec getGeneratedRefAnnotation(String module, String name) {
        return AnnotationSpec.builder(GeneratedRef.class).addMember("name", "\"" + name + "\"", new Object[0]).addMember("module", "\"" + module + "\"", new Object[0]).build();
    }
}

