/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.hotreload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import xyz.block.ftl.hotreload.RunnerInfo;

public class RunnerNotification {
    private static volatile Consumer<RunnerInfo> callback;
    private static volatile RunnerInfo info;
    private static final AtomicBoolean requiresNewRunnerDetails;
    private static final List<Runnable> runnerDetailsCallbacks;

    public static synchronized void setCallback(Consumer<RunnerInfo> callback) {
        if (RunnerNotification.callback != null) {
            throw new IllegalStateException("Callback already set");
        }
        if (info != null) {
            callback.accept(info);
            info = null;
        } else {
            RunnerNotification.callback = callback;
        }
    }

    public static synchronized void setRunnerInfo(RunnerInfo info) {
        if (callback != null) {
            callback.accept(info);
            callback = null;
        } else {
            RunnerNotification.info = info;
        }
    }

    public static synchronized void setRequiresNewRunnerDetails() {
        for (Runnable callback : runnerDetailsCallbacks) {
            callback.run();
        }
    }

    public static synchronized void onRunnerDetails(Runnable callback) {
        runnerDetailsCallbacks.add(callback);
    }

    static {
        requiresNewRunnerDetails = new AtomicBoolean(false);
        runnerDetailsCallbacks = Collections.synchronizedList(new ArrayList());
    }
}

