/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.hotreload;

import java.util.concurrent.atomic.AtomicLong;
import xyz.block.ftl.hotreload.RunnerInfo;

public class RunnerNotification {
    private static volatile RunnerCallback callback;
    private static volatile RunnerInfo info;
    private static final AtomicLong runnerVersion;

    public static long getRunnerVersion() {
        return runnerVersion.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incrementRunnerVersion() {
        long incremented = runnerVersion.incrementAndGet();
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerCallback callback = RunnerNotification.callback;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (callback != null) {
                callback.newRunnerVersion(incremented);
            }
            return incremented;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCallback(RunnerCallback callback) {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerNotification.callback = callback;
            RunnerInfo info = RunnerNotification.info;
            RunnerNotification.info = null;
            long runnerVersion = RunnerNotification.runnerVersion.get();
            // ** MonitorExit[var4_1] (shouldn't be in output)
            if (runnerVersion != -1L) {
                callback.newRunnerVersion(runnerVersion);
            }
            if (info != null) {
                callback.runnerDetails(info);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadStarted() {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerCallback cb = callback;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (cb != null) {
                cb.reloadStarted();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setRunnerInfo(RunnerInfo info) {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            boolean outdated = info.version() < runnerVersion.get();
            RunnerCallback callback = RunnerNotification.callback;
            if (callback == null) {
                RunnerNotification.info = info;
            }
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (callback != null) {
                callback.runnerDetails(info);
            }
            return outdated;
        }
    }

    static {
        runnerVersion = new AtomicLong(0L);
    }

    public static interface RunnerCallback {
        public void runnerDetails(RunnerInfo var1);

        public void reloadStarted();

        public void newRunnerVersion(long var1);
    }
}

