/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.hotreload;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeGenNotification {
    private static final Map<Path, Long> lastModified = new HashMap<Path, Long>();
    private static List<Path> schemaDirs = new ArrayList<Path>();

    public static synchronized void updateLastModified(List<Path> sd, List<Path> path) {
        for (Path p : path) {
            lastModified.put(p, p.toFile().lastModified());
        }
        schemaDirs = new ArrayList<Path>(sd);
        CodeGenNotification.class.notifyAll();
    }

    public static synchronized void waitForCodeGen() {
        boolean wait = false;
        for (Map.Entry<Path, Long> entry : lastModified.entrySet()) {
            if (entry.getKey().toFile().lastModified() == entry.getValue().longValue()) continue;
            wait = true;
            break;
        }
        block10: for (Path path : schemaDirs) {
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path);
                try {
                    for (Path path2 : stream) {
                        if (!path2.getFileName().toString().endsWith(".pb") || lastModified.containsKey(path2)) continue;
                        wait = true;
                        continue block10;
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (wait) {
            try {
                CodeGenNotification.class.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

