/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.hotreload;

import java.util.concurrent.atomic.AtomicReference;
import xyz.block.ftl.hotreload.RunnerInfo;

public class RunnerNotification {
    private static volatile RunnerCallback callback;
    private static volatile RunnerInfo info;
    private static final AtomicReference<String> currentDeploymentKey;

    public static String getDeploymentKey() {
        return currentDeploymentKey.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newDeploymentKey(String key) {
        currentDeploymentKey.set(key);
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerCallback callback = RunnerNotification.callback;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (callback != null) {
                callback.newRunnerDeployment(key);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCallback(RunnerCallback callback) {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerNotification.callback = callback;
            RunnerInfo info = RunnerNotification.info;
            RunnerNotification.info = null;
            String runnerVersion = currentDeploymentKey.get();
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (runnerVersion != null) {
                callback.newRunnerDeployment(runnerVersion);
            }
            if (info != null) {
                callback.runnerDetails(info);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadStarted() {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerCallback cb = callback;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (cb != null) {
                cb.reloadStarted();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setRunnerInfo(RunnerInfo info) {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            boolean outdated = !info.deployment().equals(currentDeploymentKey.get()) && currentDeploymentKey.get() != null;
            RunnerCallback callback = RunnerNotification.callback;
            if (callback == null) {
                RunnerNotification.info = info;
            }
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (callback != null) {
                callback.runnerDetails(info);
            }
            return outdated;
        }
    }

    static {
        currentDeploymentKey = new AtomicReference();
    }

    public static interface RunnerCallback {
        public void runnerDetails(RunnerInfo var1);

        public void reloadStarted();

        public void newRunnerDeployment(String var1);
    }
}

