/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.hotreload;

import java.util.concurrent.atomic.AtomicLong;
import xyz.block.ftl.hotreload.RunnerInfo;

public class RunnerNotification {
    private static volatile RunnerCallback callback;
    private static volatile RunnerInfo info;
    private static final AtomicLong requiredSchemaNumber;

    public static long getRequiredSchemaNumber() {
        return requiredSchemaNumber.get();
    }

    public static long schemaVersion(boolean newRunnerRequired) {
        if (newRunnerRequired) {
            return RunnerNotification.newRunnerRequired();
        }
        return requiredSchemaNumber.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long newRunnerRequired() {
        long ret = requiredSchemaNumber.incrementAndGet();
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerCallback callback = RunnerNotification.callback;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (callback != null) {
                callback.newSchemaNumber(ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCallback(RunnerCallback callback) {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerNotification.callback = callback;
            RunnerInfo info = RunnerNotification.info;
            RunnerNotification.info = null;
            long schemaVersion = requiredSchemaNumber.get();
            // ** MonitorExit[var4_1] (shouldn't be in output)
            if (schemaVersion > 0L) {
                callback.newSchemaNumber(schemaVersion);
            }
            if (info != null) {
                callback.runnerDetails(info);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadStarted() {
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerCallback cb = callback;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (cb != null) {
                cb.reloadStarted();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setRunnerInfo(RunnerInfo info) {
        boolean outdated = false;
        Class<RunnerNotification> clazz = RunnerNotification.class;
        synchronized (RunnerNotification.class) {
            RunnerCallback callback = RunnerNotification.callback;
            if (callback == null) {
                RunnerNotification.info = info;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (callback != null) {
                outdated = callback.runnerDetails(info);
            }
            return outdated;
        }
    }

    static {
        requiredSchemaNumber = new AtomicLong(0L);
    }

    public static interface RunnerCallback {
        public boolean runnerDetails(RunnerInfo var1);

        public void reloadStarted();

        public void newSchemaNumber(long var1);
    }
}

