/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.JsonNode;
import io.quarkus.arc.processor.DotNames;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.VoidType;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.Config;
import xyz.block.ftl.Export;
import xyz.block.ftl.GeneratedRef;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.Secret;
import xyz.block.ftl.VerbName;
import xyz.block.ftl.deployment.CommentKey;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.deployment.TypeKey;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.builtin.HttpRequest;
import xyz.block.ftl.runtime.builtin.HttpResponse;
import xyz.block.ftl.v1.schema.Any;
import xyz.block.ftl.v1.schema.Array;
import xyz.block.ftl.v1.schema.Bool;
import xyz.block.ftl.v1.schema.Bytes;
import xyz.block.ftl.v1.schema.Config;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.Int;
import xyz.block.ftl.v1.schema.Metadata;
import xyz.block.ftl.v1.schema.MetadataAlias;
import xyz.block.ftl.v1.schema.MetadataCalls;
import xyz.block.ftl.v1.schema.MetadataTypeMap;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Ref;
import xyz.block.ftl.v1.schema.Secret;
import xyz.block.ftl.v1.schema.Time;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.TypeAlias;
import xyz.block.ftl.v1.schema.Unit;
import xyz.block.ftl.v1.schema.Verb;

public class ModuleBuilder {
    public static final String BUILTIN = "builtin";
    public static final DotName INSTANT = DotName.createSimple(Instant.class);
    public static final DotName ZONED_DATE_TIME = DotName.createSimple(ZonedDateTime.class);
    public static final DotName NOT_NULL = DotName.createSimple(NotNull.class);
    public static final DotName JSON_NODE = DotName.createSimple((String)JsonNode.class.getName());
    public static final DotName OFFSET_DATE_TIME = DotName.createSimple((String)OffsetDateTime.class.getName());
    public static final DotName GENERATED_REF = DotName.createSimple(GeneratedRef.class);
    public static final DotName EXPORT = DotName.createSimple(Export.class);
    private final IndexView index;
    private final Module.Builder moduleBuilder;
    private final Map<TypeKey, ExistingRef> dataElements;
    private final String moduleName;
    private final Set<String> knownSecrets = new HashSet<String>();
    private final Set<String> knownConfig = new HashSet<String>();
    private final Map<DotName, TopicsBuildItem.DiscoveredTopic> knownTopics;
    private final Map<DotName, VerbClientBuildItem.DiscoveredClients> verbClients;
    private final FTLRecorder recorder;
    private final Map<String, Iterable<String>> comments;
    private final List<ValidationFailure> validationFailures = new ArrayList<ValidationFailure>();

    public ModuleBuilder(IndexView index, String moduleName, Map<DotName, TopicsBuildItem.DiscoveredTopic> knownTopics, Map<DotName, VerbClientBuildItem.DiscoveredClients> verbClients, FTLRecorder recorder, Map<String, Iterable<String>> comments, Map<TypeKey, ExistingRef> typeAliases) {
        this.index = index;
        this.moduleName = moduleName;
        this.moduleBuilder = Module.newBuilder().setName(moduleName).setBuiltin(false);
        this.knownTopics = knownTopics;
        this.verbClients = verbClients;
        this.recorder = recorder;
        this.comments = comments;
        this.dataElements = new HashMap<TypeKey, ExistingRef>(typeAliases);
    }

    @NotNull
    public static String methodToName(MethodInfo method) {
        if (method.hasAnnotation(VerbName.class)) {
            return method.annotation(VerbName.class).value().asString();
        }
        return method.name();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public static Class<?> loadClass(org.jboss.jandex.Type param) throws ClassNotFoundException {
        ArrayType array;
        if (param.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return Class.forName(param.asParameterizedType().name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        if (param.kind() == Type.Kind.CLASS) {
            return Class.forName(param.name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        if (param.kind() == Type.Kind.PRIMITIVE) {
            switch (param.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case INT: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
            }
            throw new RuntimeException("Unknown primitive type " + param.asPrimitiveType().primitive());
        }
        if (param.kind() == Type.Kind.ARRAY && (array = param.asArrayType()).componentType().kind() == Type.Kind.PRIMITIVE) {
            switch (array.componentType().asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    return boolean[].class;
                }
                case BYTE: {
                    return byte[].class;
                }
                case SHORT: {
                    return short[].class;
                }
                case INT: {
                    return int[].class;
                }
                case LONG: {
                    return long[].class;
                }
                case FLOAT: {
                    return float[].class;
                }
                case DOUBLE: {
                    return double[].class;
                }
                case CHAR: {
                    return char[].class;
                }
            }
            throw new RuntimeException("Unknown primitive type " + param.asPrimitiveType().primitive());
        }
        throw new RuntimeException("Unknown type " + param.kind());
    }

    public void registerVerbMethod(MethodInfo method, String className, boolean exported, BodyType bodyType, Consumer<Verb.Builder> metadataCallback) {
        try {
            ArrayList parameterTypes = new ArrayList();
            ArrayList<Object> paramMappers = new ArrayList<Object>();
            VoidType bodyParamType = null;
            Verb.Builder verbBuilder = Verb.newBuilder();
            String verbName = ModuleBuilder.methodToName(method);
            MetadataCalls.Builder callsMetadata = MetadataCalls.newBuilder();
            for (MethodParameterInfo param : method.parameters()) {
                Class<?> paramType;
                String name;
                Class<?> paramType2;
                if (param.hasAnnotation(Secret.class)) {
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    name = param.annotation(Secret.class).value().asString();
                    paramMappers.add(new VerbRegistry.SecretSupplier(name, paramType2));
                    if (this.knownSecrets.contains(name)) continue;
                    Secret.Builder secretBuilder = xyz.block.ftl.v1.schema.Secret.newBuilder().setType(this.buildType(param.type(), false)).setName(name);
                    Optional.ofNullable(this.comments.get(CommentKey.ofSecret(name))).ifPresent(arg_0 -> ((Secret.Builder)secretBuilder).addAllComments(arg_0));
                    this.addDecls(Decl.newBuilder().setSecret(secretBuilder).build());
                    this.knownSecrets.add(name);
                    continue;
                }
                if (param.hasAnnotation(Config.class)) {
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    name = param.annotation(Config.class).value().asString();
                    paramMappers.add(new VerbRegistry.ConfigSupplier(name, paramType2));
                    if (this.knownConfig.contains(name)) continue;
                    Config.Builder configBuilder = xyz.block.ftl.v1.schema.Config.newBuilder().setType(this.buildType(param.type(), false)).setName(name);
                    Optional.ofNullable(this.comments.get(CommentKey.ofConfig(name))).ifPresent(arg_0 -> ((Config.Builder)configBuilder).addAllComments(arg_0));
                    this.addDecls(Decl.newBuilder().setConfig(configBuilder).build());
                    this.knownConfig.add(name);
                    continue;
                }
                if (this.knownTopics.containsKey(param.type().name())) {
                    TopicsBuildItem.DiscoveredTopic topic = this.knownTopics.get(param.type().name());
                    paramType = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType);
                    paramMappers.add(this.recorder.topicSupplier(topic.generatedProducer(), verbName));
                    continue;
                }
                if (this.verbClients.containsKey(param.type().name())) {
                    VerbClientBuildItem.DiscoveredClients client = this.verbClients.get(param.type().name());
                    paramType = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType);
                    paramMappers.add(this.recorder.verbClientSupplier(client.generatedClient()));
                    callsMetadata.addCalls(Ref.newBuilder().setName(client.name()).setModule(client.module()).build());
                    continue;
                }
                if (FTLDotNames.LEASE_CLIENT.equals((Object)param.type().name())) {
                    parameterTypes.add(LeaseClient.class);
                    paramMappers.add(this.recorder.leaseClientSupplier());
                    continue;
                }
                if (bodyType != BodyType.DISALLOWED && bodyParamType == null) {
                    bodyParamType = param.type();
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    paramMappers.add(new VerbRegistry.BodySupplier(paramType2));
                    continue;
                }
                throw new RuntimeException("Unknown parameter type " + param.type() + " on FTL method: " + method.declaringClass().name() + "." + method.name());
            }
            if (bodyParamType == null) {
                if (bodyType == BodyType.REQUIRED) {
                    throw new RuntimeException("Missing required payload parameter");
                }
                bodyParamType = VoidType.VOID;
            }
            if (callsMetadata.getCallsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setCalls(callsMetadata));
            }
            this.recorder.registerVerb(this.moduleName, verbName, method.name(), parameterTypes, Class.forName(className, false, Thread.currentThread().getContextClassLoader()), paramMappers, method.returnType() == VoidType.VOID);
            verbBuilder.setName(verbName).setExport(exported).setRequest(this.buildType((org.jboss.jandex.Type)bodyParamType, exported)).setResponse(this.buildType(method.returnType(), exported));
            Optional.ofNullable(this.comments.get(CommentKey.ofVerb(verbName))).ifPresent(arg_0 -> ((Verb.Builder)verbBuilder).addAllComments(arg_0));
            if (metadataCallback != null) {
                metadataCallback.accept(verbBuilder);
            }
            this.addDecls(Decl.newBuilder().setVerb(verbBuilder).build());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process FTL method " + method.declaringClass().name() + "." + method.name(), e);
        }
    }

    public Type buildType(org.jboss.jandex.Type type, boolean export) {
        switch (type.kind()) {
            case PRIMITIVE: {
                PrimitiveType prim = type.asPrimitiveType();
                switch (prim.primitive()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        return Type.newBuilder().setInt(Int.newBuilder().build()).build();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return Type.newBuilder().setFloat(xyz.block.ftl.v1.schema.Float.newBuilder().build()).build();
                    }
                    case BOOLEAN: {
                        return Type.newBuilder().setBool(Bool.newBuilder().build()).build();
                    }
                    case CHAR: {
                        return Type.newBuilder().setString(xyz.block.ftl.v1.schema.String.newBuilder().build()).build();
                    }
                }
                throw new RuntimeException("unknown primitive type: " + prim.primitive());
            }
            case VOID: {
                return Type.newBuilder().setUnit(Unit.newBuilder().build()).build();
            }
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                if (arrayType.componentType().kind() == Type.Kind.PRIMITIVE && arrayType.componentType().asPrimitiveType().primitive() == PrimitiveType.Primitive.BYTE) {
                    return Type.newBuilder().setBytes(Bytes.newBuilder().build()).build();
                }
                return Type.newBuilder().setArray(Array.newBuilder().setElement(this.buildType(arrayType.componentType(), export)).build()).build();
            }
            case CLASS: {
                PrimitiveType unboxed;
                ClassType clazz = type.asClassType();
                ClassInfo info = this.index.getClassByName(clazz.name());
                if (info.enclosingClass() != null && !Modifier.isStatic(info.flags())) {
                    this.validationFailures.add(new ValidationFailure(clazz.name().toString(), "Inner classes must be static"));
                }
                if ((unboxed = PrimitiveType.unbox((ClassType)clazz)) != null) {
                    Type primitive = this.buildType((org.jboss.jandex.Type)unboxed, export);
                    if (type.hasAnnotation(NOT_NULL)) {
                        return primitive;
                    }
                    return Type.newBuilder().setOptional(xyz.block.ftl.v1.schema.Optional.newBuilder().setType(primitive)).build();
                }
                if (info != null && info.hasDeclaredAnnotation(GENERATED_REF)) {
                    AnnotationInstance ref = info.declaredAnnotation(GENERATED_REF);
                    return Type.newBuilder().setRef(Ref.newBuilder().setName(ref.value("name").asString()).setModule(ref.value("module").asString())).build();
                }
                if (clazz.name().equals((Object)DotName.STRING_NAME)) {
                    return Type.newBuilder().setString(xyz.block.ftl.v1.schema.String.newBuilder().build()).build();
                }
                if (clazz.name().equals((Object)DotName.OBJECT_NAME) || clazz.name().equals((Object)JSON_NODE)) {
                    return Type.newBuilder().setAny(Any.newBuilder().build()).build();
                }
                if (clazz.name().equals((Object)OFFSET_DATE_TIME)) {
                    return Type.newBuilder().setTime(Time.newBuilder().build()).build();
                }
                if (clazz.name().equals((Object)INSTANT)) {
                    return Type.newBuilder().setTime(Time.newBuilder().build()).build();
                }
                if (clazz.name().equals((Object)ZONED_DATE_TIME)) {
                    return Type.newBuilder().setTime(Time.newBuilder().build()).build();
                }
                ExistingRef existing = this.dataElements.get(new TypeKey(clazz.name().toString(), List.of()));
                if (existing != null) {
                    if (existing.exported() || !export || !existing.ref().getModule().equals(this.moduleName)) {
                        return Type.newBuilder().setRef(existing.ref()).build();
                    }
                    for (int i = 0; i < this.moduleBuilder.getDeclsCount(); ++i) {
                        Decl decl = this.moduleBuilder.getDecls(i);
                        if (!decl.hasData() || !decl.getData().getName().equals(existing.ref().getName())) continue;
                        this.moduleBuilder.setDecls(i, decl.toBuilder().setData(decl.getData().toBuilder().setExport(true)).build());
                        break;
                    }
                    return Type.newBuilder().setRef(existing.ref()).build();
                }
                Data.Builder data = Data.newBuilder();
                data.setName(clazz.name().local());
                data.setExport(type.hasAnnotation(EXPORT) || export);
                Optional.ofNullable(this.comments.get(CommentKey.ofData(clazz.name().local()))).ifPresent(arg_0 -> ((Data.Builder)data).addAllComments(arg_0));
                this.buildDataElement(data, clazz.name());
                this.moduleBuilder.addDecls(Decl.newBuilder().setData(data).build());
                Ref ref = Ref.newBuilder().setName(data.getName()).setModule(this.moduleName).build();
                this.dataElements.put(new TypeKey(clazz.name().toString(), List.of()), new ExistingRef(ref, export || data.getExport()));
                return Type.newBuilder().setRef(ref).build();
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType paramType = type.asParameterizedType();
                if (paramType.name().equals((Object)DotName.createSimple(List.class))) {
                    return Type.newBuilder().setArray(Array.newBuilder().setElement(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export))).build();
                }
                if (paramType.name().equals((Object)DotName.createSimple(Map.class))) {
                    return Type.newBuilder().setMap(xyz.block.ftl.v1.schema.Map.newBuilder().setKey(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export)).setValue(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(1), export))).build();
                }
                if (paramType.name().equals((Object)DotNames.OPTIONAL)) {
                    return Type.newBuilder().setOptional(xyz.block.ftl.v1.schema.Optional.newBuilder().setType(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export))).build();
                }
                if (paramType.name().equals((Object)DotName.createSimple(HttpRequest.class))) {
                    return Type.newBuilder().setRef(Ref.newBuilder().setModule(BUILTIN).setName(HttpRequest.class.getSimpleName()).addTypeParameters(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export))).build();
                }
                if (paramType.name().equals((Object)DotName.createSimple(HttpResponse.class))) {
                    return Type.newBuilder().setRef(Ref.newBuilder().setModule(BUILTIN).setName(HttpResponse.class.getSimpleName()).addTypeParameters(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export)).addTypeParameters(Type.newBuilder().setUnit(Unit.newBuilder().build()))).build();
                }
                ClassInfo classByName = this.index.getClassByName(paramType.name());
                ClassType.Builder cb = ClassType.builder((DotName)classByName.name());
                Type main = this.buildType((org.jboss.jandex.Type)cb.build(), export);
                Type.Builder builder = main.toBuilder();
                Ref.Builder refBuilder = builder.getRef().toBuilder();
                for (org.jboss.jandex.Type arg : paramType.arguments()) {
                    refBuilder.addTypeParameters(this.buildType(arg, export));
                }
                builder.setRef(refBuilder);
                return builder.build();
            }
        }
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    private void buildDataElement(Data.Builder data, DotName className) {
        if (className == null || className.equals((Object)DotName.OBJECT_NAME)) {
            return;
        }
        ClassInfo clazz = this.index.getClassByName(className);
        if (clazz == null) {
            return;
        }
        for (FieldInfo field : clazz.fields()) {
            AnnotationInstance aliases;
            if (Modifier.isStatic(field.flags())) continue;
            Field.Builder builder = Field.newBuilder().setName(field.name()).setType(this.buildType(field.type(), data.getExport()));
            if (field.hasAnnotation(JsonAlias.class) && (aliases = field.annotation(JsonAlias.class)).value() != null) {
                for (String alias : aliases.value().asStringArray()) {
                    builder.addMetadata(Metadata.newBuilder().setAlias(MetadataAlias.newBuilder().setKind(0L).setAlias(alias)));
                }
            }
            data.addFields(builder.build());
        }
        this.buildDataElement(data, clazz.superName());
    }

    public ModuleBuilder addDecls(Decl decl) {
        this.moduleBuilder.addDecls(decl);
        return this;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!this.validationFailures.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ValidationFailure failure : this.validationFailures) {
                sb.append("Validation failure: ").append(failure.className).append(": ").append(failure.message).append("\n");
            }
            throw new RuntimeException(sb.toString());
        }
        this.moduleBuilder.build().writeTo(out);
    }

    public void registerTypeAlias(String name, org.jboss.jandex.Type finalT, org.jboss.jandex.Type finalS, boolean exported) {
        this.moduleBuilder.addDecls(Decl.newBuilder().setTypeAlias(TypeAlias.newBuilder().setType(this.buildType(finalS, exported)).setName(name).addMetadata(Metadata.newBuilder().setTypeMap(MetadataTypeMap.newBuilder().setRuntime("java").setNativeName(finalT.toString()).build()).build())).build());
    }

    public static enum BodyType {
        DISALLOWED,
        ALLOWED,
        REQUIRED;

    }

    record ValidationFailure(String className, String message) {
    }

    record ExistingRef(Ref ref, boolean exported) {
    }
}

