/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Enum;
import xyz.block.ftl.v1.schema.Metadata;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Topic;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.TypeAlias;
import xyz.block.ftl.v1.schema.Verb;

public abstract class JVMCodeGenerator
implements CodeGenProvider {
    public static final String PACKAGE_PREFIX = "ftl.";
    public static final String TYPE_MAPPER = "TypeAliasMapper";

    public String providerId() {
        return "ftl-clients";
    }

    public String inputDirectory() {
        return "ftl-module-schema";
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        if (!Files.isDirectory(context.inputDir(), new LinkOption[0])) {
            return false;
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        HashMap<DeclRef, Type> typeAliasMap = new HashMap<DeclRef, Type>();
        HashMap<DeclRef, String> nativeTypeAliasMap = new HashMap<DeclRef, String>();
        try (Stream<Path> pathStream = Files.list(context.inputDir());){
            for (Path file : pathStream.toList()) {
                String fileName = file.getFileName().toString();
                if (!fileName.endsWith(".pb")) continue;
                Module module = Module.parseFrom((byte[])Files.readAllBytes(file));
                for (Decl decl : module.getDeclsList()) {
                    String packageName = PACKAGE_PREFIX + module.getName();
                    if (!decl.hasTypeAlias()) continue;
                    TypeAlias data = decl.getTypeAlias();
                    boolean handled = false;
                    for (Metadata md : data.getMetadataList()) {
                        String runtime;
                        if (!md.hasTypeMap() || !(runtime = md.getTypeMap().getRuntime()).equals("kotlin") && !runtime.equals("java")) continue;
                        nativeTypeAliasMap.put(new DeclRef(module.getName(), data.getName()), md.getTypeMap().getNativeName());
                        this.generateTypeAliasMapper(module.getName(), data.getName(), packageName, Optional.of(md.getTypeMap().getNativeName()), context.outDir());
                        handled = true;
                        break;
                    }
                    if (handled) continue;
                    this.generateTypeAliasMapper(module.getName(), data.getName(), packageName, Optional.empty(), context.outDir());
                    typeAliasMap.put(new DeclRef(module.getName(), data.getName()), data.getType());
                }
                modules.add(module);
            }
        }
        catch (IOException e) {
            throw new CodeGenException((Throwable)e);
        }
        try {
            for (Module module : modules) {
                String packageName = PACKAGE_PREFIX + module.getName();
                for (Decl decl : module.getDeclsList()) {
                    Data data;
                    if (decl.hasVerb()) {
                        Verb verb = decl.getVerb();
                        if (!verb.getExport()) continue;
                        this.generateVerb(module, verb, packageName, typeAliasMap, nativeTypeAliasMap, context.outDir());
                        continue;
                    }
                    if (decl.hasData()) {
                        data = decl.getData();
                        if (!data.getExport()) continue;
                        this.generateDataObject(module, data, packageName, typeAliasMap, nativeTypeAliasMap, context.outDir());
                        continue;
                    }
                    if (decl.hasEnum()) {
                        data = decl.getEnum();
                        if (!data.getExport()) continue;
                        this.generateEnum(module, (Enum)data, packageName, typeAliasMap, nativeTypeAliasMap, context.outDir());
                        continue;
                    }
                    if (!decl.hasTopic() || !(data = decl.getTopic()).getExport()) continue;
                    this.generateTopicSubscription(module, (Topic)data, packageName, typeAliasMap, nativeTypeAliasMap, context.outDir());
                }
            }
        }
        catch (Exception e) {
            throw new CodeGenException((Throwable)e);
        }
        return true;
    }

    protected abstract void generateTypeAliasMapper(String var1, String var2, String var3, Optional<String> var4, Path var5) throws IOException;

    protected abstract void generateTopicSubscription(Module var1, Topic var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, Path var6) throws IOException;

    protected abstract void generateEnum(Module var1, Enum var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, Path var6) throws IOException;

    protected abstract void generateDataObject(Module var1, Data var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, Path var6) throws IOException;

    protected abstract void generateVerb(Module var1, Verb var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, Path var6) throws IOException;

    public boolean shouldRun(Path sourceDir, Config config) {
        return true;
    }

    protected static String className(String in) {
        return Character.toUpperCase(in.charAt(0)) + in.substring(1);
    }

    public record DeclRef(String module, String name) {
    }
}

