/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.Nullability;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Enum;
import xyz.block.ftl.v1.schema.EnumVariant;
import xyz.block.ftl.v1.schema.Int;
import xyz.block.ftl.v1.schema.IntValue;
import xyz.block.ftl.v1.schema.String;
import xyz.block.ftl.v1.schema.StringValue;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.TypeValue;
import xyz.block.ftl.v1.schema.Value;

public class EnumProcessor {
    private static final Logger log = Logger.getLogger(EnumProcessor.class);
    public static final Set<PrimitiveType.Primitive> INT_TYPES = Set.of(PrimitiveType.Primitive.INT, PrimitiveType.Primitive.LONG, PrimitiveType.Primitive.BYTE, PrimitiveType.Primitive.SHORT);

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SchemaContributorBuildItem handleEnums(CombinedIndexBuildItem index, FTLRecorder recorder) {
        Collection enumAnnotations = index.getIndex().getAnnotations(FTLDotNames.ENUM);
        log.infof("Processing %d enum annotations into decls", (Object)enumAnnotations.size());
        return new SchemaContributorBuildItem(moduleBuilder -> {
            try {
                List<Decl> decls = this.extractEnumDecls(index, enumAnnotations, recorder, (ModuleBuilder)moduleBuilder);
                for (Decl decl : decls) {
                    moduleBuilder.addDecls(decl);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<Decl> extractEnumDecls(CombinedIndexBuildItem index, Collection<AnnotationInstance> enumAnnotations, FTLRecorder recorder, ModuleBuilder moduleBuilder) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ArrayList<Decl> decls = new ArrayList<Decl>();
        for (AnnotationInstance enumAnnotation : enumAnnotations) {
            boolean isLocalToModule;
            boolean exported = enumAnnotation.target().hasAnnotation(FTLDotNames.EXPORT);
            ClassInfo classInfo = enumAnnotation.target().asClass();
            Class<?> clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
            boolean bl = isLocalToModule = !classInfo.hasDeclaredAnnotation(FTLDotNames.GENERATED_REF);
            if (classInfo.isEnum()) {
                recorder.registerEnum(clazz);
                if (!isLocalToModule) continue;
                decls.add(this.extractValueEnum(classInfo, clazz, exported));
                continue;
            }
            TypeEnum typeEnum = this.extractTypeEnum(index, moduleBuilder, classInfo, exported);
            recorder.registerEnum(clazz, typeEnum.variantClasses);
            if (!isLocalToModule) continue;
            decls.add(typeEnum.decl);
        }
        return decls;
    }

    private Decl extractValueEnum(ClassInfo classInfo, Class<?> clazz, boolean exported) throws NoSuchFieldException, IllegalAccessException {
        Enum.Builder enumBuilder = Enum.newBuilder().setName(classInfo.simpleName()).setExport(exported);
        FieldInfo valueField = classInfo.field("value");
        if (valueField == null) {
            throw new RuntimeException("Enum must have a 'value' field: " + classInfo.name());
        }
        Type type = valueField.type();
        Type.Builder typeBuilder = xyz.block.ftl.v1.schema.Type.newBuilder();
        if (this.isInt(type)) {
            typeBuilder.setInt(Int.newBuilder().build()).build();
        } else if (type.name().equals((Object)DotName.STRING_NAME)) {
            typeBuilder.setString(String.newBuilder().build());
        } else {
            throw new RuntimeException("Enum value type must be String, int, long, short, or byte: " + classInfo.name());
        }
        enumBuilder.setType(typeBuilder.build());
        for (Object constant : clazz.getEnumConstants()) {
            Field value = constant.getClass().getDeclaredField("value");
            value.setAccessible(true);
            Value.Builder valueBuilder = Value.newBuilder();
            if (this.isInt(type)) {
                long aLong = value.getLong(constant);
                valueBuilder.setIntValue(IntValue.newBuilder().setValue(aLong).build());
            } else {
                java.lang.String aString = (java.lang.String)value.get(constant);
                valueBuilder.setStringValue(StringValue.newBuilder().setValue(aString).build());
            }
            EnumVariant variant = EnumVariant.newBuilder().setName(constant.toString()).setValue(valueBuilder).build();
            enumBuilder.addVariants(variant);
        }
        return Decl.newBuilder().setEnum(enumBuilder).build();
    }

    private TypeEnum extractTypeEnum(CombinedIndexBuildItem index, ModuleBuilder moduleBuilder, ClassInfo classInfo, boolean exported) throws ClassNotFoundException {
        Enum.Builder enumBuilder = Enum.newBuilder().setName(classInfo.simpleName()).setExport(exported);
        Collection variants = index.getComputingIndex().getAllKnownImplementors(classInfo.name());
        if (variants.isEmpty()) {
            throw new RuntimeException("No variants found for enum: " + enumBuilder.getName());
        }
        ArrayList variantClasses = new ArrayList();
        for (ClassInfo variant : variants) {
            ClassType variantType;
            if (variant.hasAnnotation(FTLDotNames.ENUM_HOLDER)) {
                FieldInfo valueField = variant.field("value");
                if (valueField == null) {
                    throw new RuntimeException("Enum variant must have a 'value' field: " + variant.name());
                }
                variantType = valueField.type();
            } else {
                variantType = ClassType.builder((DotName)variant.name()).build();
                Class<?> variantClazz = Class.forName(variantType.name().toString(), false, Thread.currentThread().getContextClassLoader());
                variantClasses.add(variantClazz);
            }
            xyz.block.ftl.v1.schema.Type declType = moduleBuilder.buildType((Type)variantType, exported, Nullability.NOT_NULL);
            TypeValue typeValue = TypeValue.newBuilder().setValue(declType).build();
            EnumVariant.Builder variantBuilder = EnumVariant.newBuilder().setName(variant.simpleName()).setValue(Value.newBuilder().setTypeValue(typeValue).build());
            enumBuilder.addVariants(variantBuilder.build());
        }
        return new TypeEnum(Decl.newBuilder().setEnum(enumBuilder).build(), variantClasses);
    }

    private boolean isInt(Type type) {
        return type.kind() == Type.Kind.PRIMITIVE && INT_TYPES.contains(type.asPrimitiveType().primitive());
    }

    private record TypeEnum(Decl decl, List<Class<?>> variantClasses) {
    }
}

