/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import xyz.block.ftl.Export;
import xyz.block.ftl.Topic;
import xyz.block.ftl.TopicDefinition;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.Nullability;
import xyz.block.ftl.deployment.PositionUtils;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.runtime.TopicHelper;
import xyz.block.ftl.v1.schema.Decl;

public class TopicsProcessor {
    public static final DotName TOPIC = DotName.createSimple(Topic.class);
    private static final Logger log = Logger.getLogger(TopicsProcessor.class);

    @BuildStep
    TopicsBuildItem handleTopics(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedTopicProducer) {
        Collection topicDefinitions = index.getComputingIndex().getAnnotations(TopicDefinition.class);
        log.infof("Processing %d topic definition annotations into decls", (Object)topicDefinitions.size());
        HashMap<DotName, TopicsBuildItem.DiscoveredTopic> topics = new HashMap<DotName, TopicsBuildItem.DiscoveredTopic>();
        HashSet<String> names = new HashSet<String>();
        for (AnnotationInstance topicDefinition : topicDefinitions) {
            ClassInfo iface = topicDefinition.target().asClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@TopicDefinition can only be applied to interfaces " + iface.name() + " is not an interface");
            }
            Type paramType = null;
            for (Type i : iface.interfaceTypes()) {
                if (!i.name().equals((Object)TOPIC) || i.kind() != Type.Kind.PARAMETERIZED_TYPE) continue;
                paramType = (Type)i.asParameterizedType().arguments().get(0);
            }
            if (paramType == null) {
                throw new RuntimeException("@TopicDefinition can only be applied to interfaces that directly extend " + TOPIC + " with a concrete type parameter " + iface.name() + " does not extend this interface");
            }
            String name = topicDefinition.value().asString();
            if (names.contains(name)) {
                throw new RuntimeException("Multiple topic definitions found for topic " + name);
            }
            names.add(name);
            try (ClassCreator cc = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedTopicProducer, true), iface.name().toString() + "_fit_topic", null, Object.class.getName(), new String[]{iface.name().toString()});){
                FieldCreator verb = cc.getFieldCreator("verb", String.class);
                MethodCreator constructor = cc.getConstructorCreator(new Class[]{String.class});
                constructor.invokeSpecialMethod(MethodDescriptor.ofMethod(Object.class, (String)"<init>", Void.TYPE, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                constructor.writeInstanceField(verb.getFieldDescriptor(), constructor.getThis(), constructor.getMethodParam(0));
                constructor.returnVoid();
                MethodCreator publish = cc.getMethodCreator("publish", Void.TYPE, new Class[]{Object.class});
                ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(TopicHelper.class, (String)"instance", TopicHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                publish.invokeVirtualMethod(MethodDescriptor.ofMethod(TopicHelper.class, (String)"publish", Void.TYPE, (Class[])new Class[]{String.class, String.class, Object.class}), helper, new ResultHandle[]{publish.load(name), publish.readInstanceField(verb.getFieldDescriptor(), publish.getThis()), publish.getMethodParam(0)});
                publish.returnVoid();
                topics.put(iface.name(), new TopicsBuildItem.DiscoveredTopic(name, cc.getClassName(), paramType, iface.hasAnnotation(Export.class), iface.name().toString()));
            }
        }
        return new TopicsBuildItem(topics);
    }

    @BuildStep
    public SchemaContributorBuildItem topicSchema(final TopicsBuildItem topics) {
        return new SchemaContributorBuildItem(new Consumer<ModuleBuilder>(){

            @Override
            public void accept(ModuleBuilder moduleBuilder) {
                for (TopicsBuildItem.DiscoveredTopic topic : topics.getTopics().values()) {
                    moduleBuilder.addDecls(Decl.newBuilder().setTopic(xyz.block.ftl.v1.schema.Topic.newBuilder().setExport(topic.exported()).setPos(PositionUtils.forClass(topic.interfaceName())).setName(topic.topicName()).setEvent(moduleBuilder.buildType(topic.eventType(), topic.exported(), Nullability.NOT_NULL)).build()).build());
                }
            }
        });
    }
}

