/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.VerbClientDefinition;
import xyz.block.ftl.VerbClientEmpty;
import xyz.block.ftl.VerbClientSink;
import xyz.block.ftl.VerbClientSource;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.ModuleNameBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TypeAliasBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.runtime.VerbClientHelper;
import xyz.block.ftl.v1.schema.Metadata;
import xyz.block.ftl.v1.schema.MetadataCronJob;

public class VerbProcessor {
    public static final DotName VERB_CLIENT = DotName.createSimple(VerbClient.class);
    public static final DotName VERB_CLIENT_SINK = DotName.createSimple(VerbClientSink.class);
    public static final DotName VERB_CLIENT_SOURCE = DotName.createSimple(VerbClientSource.class);
    public static final DotName VERB_CLIENT_EMPTY = DotName.createSimple(VerbClientEmpty.class);
    public static final String TEST_ANNOTATION = "xyz.block.ftl.java.test.FTLManaged";
    private static final Logger log = Logger.getLogger(VerbProcessor.class);

    @BuildStep
    VerbClientBuildItem handleVerbClients(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedClients, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, ModuleNameBuildItem moduleNameBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        Collection clientDefinitions = index.getComputingIndex().getAnnotations(VerbClientDefinition.class);
        log.infof("Processing %d verb clients", (Object)clientDefinitions.size());
        HashMap<DotName, VerbClientBuildItem.DiscoveredClients> clients = new HashMap<DotName, VerbClientBuildItem.DiscoveredClients>();
        for (AnnotationInstance clientDefinition : clientDefinitions) {
            ClassInfo iface = clientDefinition.target().asClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces and " + iface.name() + " is not an interface");
            }
            String name = clientDefinition.value("name").asString();
            AnnotationValue moduleValue = clientDefinition.value("module");
            String module = moduleValue == null || moduleValue.asString().isEmpty() ? moduleNameBuildItem.getModuleName() : moduleValue.asString();
            boolean found = false;
            Object classOutput = launchModeBuildItem.isTest() ? new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer) : new GeneratedClassGizmoAdaptor(generatedClients, true);
            for (Type i : iface.interfaceTypes()) {
                ResultHandle helper;
                LinkedHashSet<String> signatures;
                ClassCreator cc;
                Type returnType;
                if (i.name().equals((Object)VERB_CLIENT)) {
                    if (i.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        returnType = (Type)i.asParameterizedType().arguments().get(1);
                        Type paramType = (Type)i.asParameterizedType().arguments().get(0);
                        try (ClassCreator cc2 = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});){
                            if (launchModeBuildItem.isTest()) {
                                cc2.addAnnotation(TEST_ANNOTATION);
                                cc2.addAnnotation(Singleton.class);
                            }
                            LinkedHashSet<Map.Entry<String, String>> signatures2 = new LinkedHashSet<Map.Entry<String, String>>();
                            signatures2.add(Map.entry(returnType.name().toString(), paramType.name().toString()));
                            signatures2.add(Map.entry(Object.class.getName(), Object.class.getName()));
                            for (MethodInfo methodInfo : iface.methods()) {
                                if (!methodInfo.name().equals("call") || methodInfo.parameters().size() != 1) continue;
                                signatures2.add(Map.entry(methodInfo.returnType().name().toString(), ((MethodParameterInfo)methodInfo.parameters().get(0)).type().name().toString()));
                            }
                            for (Map.Entry entry : signatures2) {
                                MethodCreator publish2 = cc2.getMethodCreator("call", (String)entry.getKey(), new String[]{(String)entry.getValue()});
                                ResultHandle helper2 = publish2.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                                ResultHandle results = publish2.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper2, new ResultHandle[]{publish2.load(name), publish2.load(module), publish2.getMethodParam(0), publish2.loadClass(returnType.name().toString()), publish2.load(false), publish2.load(false)});
                                publish2.returnValue(results);
                            }
                            clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, module, cc2.getClassName()));
                        }
                        found = true;
                        break;
                    }
                    throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + iface.name() + " does not have concrete type parameters");
                }
                if (i.name().equals((Object)VERB_CLIENT_SINK)) {
                    if (i.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        Type paramType = (Type)i.asParameterizedType().arguments().get(0);
                        cc = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});
                        try {
                            if (launchModeBuildItem.isTest()) {
                                cc.addAnnotation(TEST_ANNOTATION);
                                cc.addAnnotation(Singleton.class);
                            }
                            signatures = new LinkedHashSet<String>();
                            signatures.add(paramType.name().toString());
                            signatures.add(Object.class.getName());
                            for (MethodInfo method : iface.methods()) {
                                if (!method.name().equals("call") || method.parameters().size() != 1) continue;
                                signatures.add(((MethodParameterInfo)method.parameters().get(0)).type().name().toString());
                            }
                            for (String sig : signatures) {
                                MethodCreator methodCreator = cc.getMethodCreator("call", Void.TYPE, new Object[]{sig});
                                helper = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                                methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{methodCreator.load(name), methodCreator.load(module), methodCreator.getMethodParam(0), methodCreator.loadClass(Void.class), methodCreator.load(false), methodCreator.load(false)});
                                methodCreator.returnVoid();
                            }
                            clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, module, cc.getClassName()));
                        }
                        finally {
                            cc.close();
                        }
                        found = true;
                        break;
                    }
                    throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + iface.name() + " does not have concrete type parameters");
                }
                if (i.name().equals((Object)VERB_CLIENT_SOURCE)) {
                    if (i.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        returnType = (Type)i.asParameterizedType().arguments().get(0);
                        cc = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});
                        try {
                            if (launchModeBuildItem.isTest()) {
                                cc.addAnnotation(TEST_ANNOTATION);
                                cc.addAnnotation(Singleton.class);
                            }
                            signatures = new LinkedHashSet();
                            signatures.add(returnType.name().toString());
                            signatures.add(Object.class.getName());
                            for (MethodInfo method : iface.methods()) {
                                if (!method.name().equals("call") || method.parameters().size() != 0) continue;
                                signatures.add(method.returnType().name().toString());
                            }
                            for (String sig : signatures) {
                                MethodCreator methodCreator = cc.getMethodCreator("call", sig, new String[0]);
                                helper = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                                ResultHandle results = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{methodCreator.load(name), methodCreator.load(module), methodCreator.loadNull(), methodCreator.loadClass(returnType.name().toString()), methodCreator.load(false), methodCreator.load(false)});
                                methodCreator.returnValue(results);
                            }
                            clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, module, cc.getClassName()));
                        }
                        finally {
                            cc.close();
                        }
                        found = true;
                        break;
                    }
                    throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + iface.name() + " does not have concrete type parameters");
                }
                if (!i.name().equals((Object)VERB_CLIENT_EMPTY)) continue;
                try (ClassCreator cc3 = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});){
                    if (launchModeBuildItem.isTest()) {
                        cc3.addAnnotation(TEST_ANNOTATION);
                        cc3.addAnnotation(Singleton.class);
                    }
                    MethodCreator publish3 = cc3.getMethodCreator("call", Void.TYPE, new Class[0]);
                    ResultHandle helper3 = publish3.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                    publish3.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper3, new ResultHandle[]{publish3.load(name), publish3.load(module), publish3.loadNull(), publish3.loadClass(Void.class), publish3.load(false), publish3.load(false)});
                    publish3.returnVoid();
                    clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, module, cc3.getClassName()));
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + iface.name() + " does not extend a verb client type");
        }
        return new VerbClientBuildItem(clients);
    }

    @BuildStep
    public void verbsAndCron(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItem, BuildProducer<SchemaContributorBuildItem> schemaContributorBuildItemBuildProducer, List<TypeAliasBuildItem> typeAliasBuildItems) {
        String className;
        MethodInfo method;
        Collection verbAnnotations = index.getIndex().getAnnotations(FTLDotNames.VERB);
        log.infof("Processing %d verb annotations into decls", (Object)verbAnnotations.size());
        AdditionalBeanBuildItem.Builder beans = AdditionalBeanBuildItem.builder().setUnremovable();
        for (AnnotationInstance verb : verbAnnotations) {
            boolean exported = verb.target().hasAnnotation(FTLDotNames.EXPORT);
            method = verb.target().asMethod();
            className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, exported, ModuleBuilder.BodyType.ALLOWED, null)));
        }
        Collection cronAnnotations = index.getIndex().getAnnotations(FTLDotNames.CRON);
        log.infof("Processing %d cron job annotations into decls", (Object)cronAnnotations.size());
        for (AnnotationInstance cron : cronAnnotations) {
            method = cron.target().asMethod();
            className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, false, ModuleBuilder.BodyType.ALLOWED, builder -> builder.addMetadata(Metadata.newBuilder().setCronJob(MetadataCronJob.newBuilder().setCron(cron.value().asString())).build()))));
        }
        additionalBeanBuildItem.produce((BuildItem)beans.build());
    }
}

