/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.ModuleNameBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TypeAliasBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.deployment.VerbType;
import xyz.block.ftl.runtime.VerbClientHelper;
import xyz.block.ftl.v1.schema.Metadata;
import xyz.block.ftl.v1.schema.MetadataCronJob;

public class VerbProcessor {
    public static final String TEST_ANNOTATION = "xyz.block.ftl.java.test.FTLManaged";
    private static final Logger log = Logger.getLogger(VerbProcessor.class);

    @BuildStep
    VerbClientBuildItem handleVerbClients(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedClients, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, ModuleNameBuildItem moduleNameBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        Collection clientDefinitions = index.getComputingIndex().getAnnotations(VerbClient.class);
        log.infof("Processing %d verb clients", (Object)clientDefinitions.size());
        HashMap<DotName, VerbClientBuildItem.DiscoveredClients> clients = new HashMap<DotName, VerbClientBuildItem.DiscoveredClients>();
        for (AnnotationInstance clientDefinition : clientDefinitions) {
            ClassInfo iface = clientDefinition.target().asClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@VerbClient can only be applied to interfaces and " + iface.name() + " is not an interface");
            }
            String name = clientDefinition.value("name").asString();
            AnnotationValue moduleValue = clientDefinition.value("module");
            String module = moduleValue == null || moduleValue.asString().isEmpty() ? moduleNameBuildItem.getModuleName() : moduleValue.asString();
            boolean found = false;
            Object classOutput = launchModeBuildItem.isTest() ? new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer) : new GeneratedClassGizmoAdaptor(generatedClients, true);
            MethodInfo callMethod = this.getCallMethod(iface);
            Type returnType = callMethod.returnType();
            Type paramType = callMethod.parametersCount() > 0 ? callMethod.parameterType(0) : null;
            try (ClassCreator cc = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});){
                if (launchModeBuildItem.isTest()) {
                    cc.addAnnotation(TEST_ANNOTATION);
                    cc.addAnnotation(Singleton.class);
                }
                switch (VerbProcessor.getVerbType(callMethod)) {
                    case VERB: {
                        ResultHandle helper;
                        MethodCreator publish;
                        LinkedHashSet<Map.Entry<String, String>> signatures = new LinkedHashSet<Map.Entry<String, String>>();
                        signatures.add(Map.entry(returnType.name().toString(), paramType.name().toString()));
                        signatures.add(Map.entry(Object.class.getName(), Object.class.getName()));
                        for (MethodInfo methodInfo : iface.methods()) {
                            if (!methodInfo.name().equals("call") || methodInfo.parameters().size() != 1) continue;
                            signatures.add(Map.entry(methodInfo.returnType().name().toString(), ((MethodParameterInfo)methodInfo.parameters().get(0)).type().name().toString()));
                        }
                        for (Map.Entry entry : signatures) {
                            publish = cc.getMethodCreator("call", (String)entry.getKey(), new String[]{(String)entry.getValue()});
                            helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.getMethodParam(0), publish.loadClass(returnType.name().toString()), publish.load(false), publish.load(false)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case SINK: {
                        LinkedHashSet<String> sinkSignatures = new LinkedHashSet<String>();
                        sinkSignatures.add(paramType.name().toString());
                        sinkSignatures.add(Object.class.getName());
                        for (MethodInfo method : iface.methods()) {
                            if (!method.name().equals("call") || method.parameters().size() != 1) continue;
                            sinkSignatures.add(((MethodParameterInfo)method.parameters().get(0)).type().name().toString());
                        }
                        for (Object sig2 : sinkSignatures) {
                            MethodCreator publish = cc.getMethodCreator("call", Void.TYPE, new Object[]{sig2});
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.getMethodParam(0), publish.loadClass(Void.class), publish.load(false), publish.load(false)});
                            publish.returnVoid();
                        }
                        break;
                    }
                    case SOURCE: {
                        Object sig2;
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        linkedHashSet.add(returnType.name().toString());
                        linkedHashSet.add(Object.class.getName());
                        for (MethodInfo method : iface.methods()) {
                            if (!method.name().equals("call") || !method.parameters().isEmpty()) continue;
                            linkedHashSet.add(method.returnType().name().toString());
                        }
                        sig2 = linkedHashSet.iterator();
                        while (sig2.hasNext()) {
                            String sig = (String)sig2.next();
                            MethodCreator publish = cc.getMethodCreator("call", sig, new String[0]);
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.loadNull(), publish.loadClass(returnType.name().toString()), publish.load(false), publish.load(false)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case EMPTY: {
                        MethodCreator publish = cc.getMethodCreator("call", Void.TYPE, new Class[0]);
                        ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                        publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.loadNull(), publish.loadClass(Void.class), publish.load(false), publish.load(false)});
                        publish.returnVoid();
                    }
                }
                clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, module, cc.getClassName()));
            }
        }
        return new VerbClientBuildItem(clients);
    }

    private MethodInfo getCallMethod(ClassInfo verbClient) {
        for (MethodInfo call : verbClient.methods()) {
            if (!call.name().equals("call")) continue;
            return call;
        }
        throw new RuntimeException("@VerbClient can only be applied to interfaces that contain a valid call method");
    }

    private static VerbType getVerbType(MethodInfo call) {
        if (call.returnType().kind() == Type.Kind.VOID && call.parametersCount() == 0) {
            return VerbType.EMPTY;
        }
        if (call.returnType().kind() == Type.Kind.VOID) {
            return VerbType.SINK;
        }
        if (call.parametersCount() == 0) {
            return VerbType.SOURCE;
        }
        return VerbType.VERB;
    }

    @BuildStep
    public void verbsAndCron(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItem, BuildProducer<SchemaContributorBuildItem> schemaContributorBuildItemBuildProducer, List<TypeAliasBuildItem> typeAliasBuildItems) {
        String className;
        MethodInfo method;
        Collection verbAnnotations = index.getIndex().getAnnotations(FTLDotNames.VERB);
        log.infof("Processing %d verb annotations into decls", (Object)verbAnnotations.size());
        AdditionalBeanBuildItem.Builder beans = AdditionalBeanBuildItem.builder().setUnremovable();
        for (AnnotationInstance verb : verbAnnotations) {
            boolean exported = verb.target().hasAnnotation(FTLDotNames.EXPORT);
            method = verb.target().asMethod();
            className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, exported, ModuleBuilder.BodyType.ALLOWED, null)));
        }
        Collection cronAnnotations = index.getIndex().getAnnotations(FTLDotNames.CRON);
        log.infof("Processing %d cron job annotations into decls", (Object)cronAnnotations.size());
        for (AnnotationInstance cron : cronAnnotations) {
            method = cron.target().asMethod();
            className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, false, ModuleBuilder.BodyType.ALLOWED, builder -> builder.addMetadata(Metadata.newBuilder().setCronJob(MetadataCronJob.newBuilder().setCron(cron.value().asString())).build()))));
        }
        additionalBeanBuildItem.produce((BuildItem)beans.build());
    }
}

