/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.JsonNode;
import io.quarkus.arc.processor.DotNames;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.VoidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.ftl.Config;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.Secret;
import xyz.block.ftl.VerbName;
import xyz.block.ftl.deployment.CommentsBuildItem;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.Nullability;
import xyz.block.ftl.deployment.PositionUtils;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.builtin.HttpRequest;
import xyz.block.ftl.runtime.builtin.HttpResponse;
import xyz.block.ftl.v1.schema.AliasKind;
import xyz.block.ftl.v1.schema.Any;
import xyz.block.ftl.v1.schema.Array;
import xyz.block.ftl.v1.schema.Bool;
import xyz.block.ftl.v1.schema.Bytes;
import xyz.block.ftl.v1.schema.Config;
import xyz.block.ftl.v1.schema.Data;
import xyz.block.ftl.v1.schema.Decl;
import xyz.block.ftl.v1.schema.Enum;
import xyz.block.ftl.v1.schema.EnumVariant;
import xyz.block.ftl.v1.schema.Field;
import xyz.block.ftl.v1.schema.Int;
import xyz.block.ftl.v1.schema.Metadata;
import xyz.block.ftl.v1.schema.MetadataAlias;
import xyz.block.ftl.v1.schema.MetadataCalls;
import xyz.block.ftl.v1.schema.MetadataConfig;
import xyz.block.ftl.v1.schema.MetadataSecrets;
import xyz.block.ftl.v1.schema.MetadataTypeMap;
import xyz.block.ftl.v1.schema.Module;
import xyz.block.ftl.v1.schema.Optional;
import xyz.block.ftl.v1.schema.Position;
import xyz.block.ftl.v1.schema.Ref;
import xyz.block.ftl.v1.schema.Secret;
import xyz.block.ftl.v1.schema.Time;
import xyz.block.ftl.v1.schema.Type;
import xyz.block.ftl.v1.schema.TypeAlias;
import xyz.block.ftl.v1.schema.Unit;
import xyz.block.ftl.v1.schema.Verb;

public class ModuleBuilder {
    public static final String BUILTIN = "builtin";
    public static final DotName INSTANT = DotName.createSimple(Instant.class);
    public static final DotName ZONED_DATE_TIME = DotName.createSimple(ZonedDateTime.class);
    public static final DotName NOT_NULL = DotName.createSimple(NotNull.class);
    public static final DotName NULLABLE = DotName.createSimple(Nullable.class);
    public static final DotName JSON_NODE = DotName.createSimple((String)JsonNode.class.getName());
    public static final DotName OFFSET_DATE_TIME = DotName.createSimple((String)OffsetDateTime.class.getName());
    private static final Pattern NAME_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private final IndexView index;
    private final Module.Builder protoModuleBuilder;
    private final Map<String, Decl> decls = new HashMap<String, Decl>();
    private final Map<String, Ref> externalRefs = new HashMap<String, Ref>();
    private final String moduleName;
    private final Set<String> knownSecrets = new HashSet<String>();
    private final Set<String> knownConfig = new HashSet<String>();
    private final Map<DotName, TopicsBuildItem.DiscoveredTopic> knownTopics;
    private final Map<DotName, VerbClientBuildItem.DiscoveredClients> verbClients;
    private final FTLRecorder recorder;
    private final CommentsBuildItem comments;
    private final List<ValidationFailure> validationFailures = new ArrayList<ValidationFailure>();
    private final boolean defaultToOptional;

    public ModuleBuilder(IndexView index, String moduleName, Map<DotName, TopicsBuildItem.DiscoveredTopic> knownTopics, Map<DotName, VerbClientBuildItem.DiscoveredClients> verbClients, FTLRecorder recorder, CommentsBuildItem comments, boolean defaultToOptional) {
        this.index = index;
        this.moduleName = moduleName;
        this.protoModuleBuilder = Module.newBuilder().setName(moduleName).setBuiltin(false);
        this.knownTopics = knownTopics;
        this.verbClients = verbClients;
        this.recorder = recorder;
        this.comments = comments;
        this.defaultToOptional = defaultToOptional;
    }

    @NotNull
    public static String methodToName(MethodInfo method) {
        if (method.hasAnnotation(VerbName.class)) {
            return method.annotation(VerbName.class).value().asString();
        }
        return method.name();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public static Class<?> loadClass(org.jboss.jandex.Type param) throws ClassNotFoundException {
        ArrayType array;
        if (param.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return Class.forName(param.asParameterizedType().name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        if (param.kind() == Type.Kind.CLASS) {
            return Class.forName(param.name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        if (param.kind() == Type.Kind.PRIMITIVE) {
            switch (param.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case INT: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
            }
            throw new RuntimeException("Unknown primitive type " + param.asPrimitiveType().primitive());
        }
        if (param.kind() == Type.Kind.ARRAY && (array = param.asArrayType()).componentType().kind() == Type.Kind.PRIMITIVE) {
            switch (array.componentType().asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    return boolean[].class;
                }
                case BYTE: {
                    return byte[].class;
                }
                case SHORT: {
                    return short[].class;
                }
                case INT: {
                    return int[].class;
                }
                case LONG: {
                    return long[].class;
                }
                case FLOAT: {
                    return float[].class;
                }
                case DOUBLE: {
                    return double[].class;
                }
                case CHAR: {
                    return char[].class;
                }
            }
            throw new RuntimeException("Unknown primitive type " + param.asPrimitiveType().primitive());
        }
        throw new RuntimeException("Unknown type " + param.kind());
    }

    public void registerVerbMethod(MethodInfo method, String className, boolean exported, BodyType bodyType, Consumer<Verb.Builder> metadataCallback) {
        try {
            ArrayList parameterTypes = new ArrayList();
            ArrayList<Object> paramMappers = new ArrayList<Object>();
            VoidType bodyParamType = null;
            Nullability bodyParamNullability = Nullability.MISSING;
            Verb.Builder verbBuilder = Verb.newBuilder();
            String verbName = this.validateName(className, ModuleBuilder.methodToName(method));
            MetadataCalls.Builder callsMetadata = MetadataCalls.newBuilder();
            MetadataConfig.Builder configMetadata = MetadataConfig.newBuilder();
            MetadataSecrets.Builder secretMetadata = MetadataSecrets.newBuilder();
            for (MethodParameterInfo param : method.parameters()) {
                Class<?> paramType;
                String name;
                Class<?> paramType2;
                if (param.hasAnnotation(Secret.class)) {
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    name = param.annotation(Secret.class).value().asString();
                    paramMappers.add(new VerbRegistry.SecretSupplier(name, paramType2));
                    if (!this.knownSecrets.contains(name)) {
                        Secret.Builder secretBuilder = xyz.block.ftl.v1.schema.Secret.newBuilder().setType(this.buildType(param.type(), false, (AnnotationTarget)param)).setName(name).addAllComments(this.comments.getComments(name));
                        this.addDecls(Decl.newBuilder().setSecret(secretBuilder).build());
                        this.knownSecrets.add(name);
                    }
                    secretMetadata.addSecrets(Ref.newBuilder().setName(name).setModule(this.moduleName).build());
                    continue;
                }
                if (param.hasAnnotation(Config.class)) {
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    name = param.annotation(Config.class).value().asString();
                    paramMappers.add(new VerbRegistry.ConfigSupplier(name, paramType2));
                    if (!this.knownConfig.contains(name)) {
                        Config.Builder configBuilder = xyz.block.ftl.v1.schema.Config.newBuilder().setType(this.buildType(param.type(), false, (AnnotationTarget)param)).setName(name).addAllComments(this.comments.getComments(name));
                        this.addDecls(Decl.newBuilder().setConfig(configBuilder).build());
                        this.knownConfig.add(name);
                    }
                    configMetadata.addConfig(Ref.newBuilder().setName(name).setModule(this.moduleName).build());
                    continue;
                }
                if (this.knownTopics.containsKey(param.type().name())) {
                    TopicsBuildItem.DiscoveredTopic topic = this.knownTopics.get(param.type().name());
                    paramType = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType);
                    paramMappers.add(this.recorder.topicSupplier(topic.generatedProducer(), verbName));
                    continue;
                }
                if (this.verbClients.containsKey(param.type().name())) {
                    VerbClientBuildItem.DiscoveredClients client = this.verbClients.get(param.type().name());
                    paramType = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType);
                    paramMappers.add(this.recorder.verbClientSupplier(client.generatedClient()));
                    callsMetadata.addCalls(Ref.newBuilder().setName(client.name()).setModule(client.module()).build());
                    continue;
                }
                if (FTLDotNames.LEASE_CLIENT.equals((Object)param.type().name())) {
                    parameterTypes.add(LeaseClient.class);
                    paramMappers.add(this.recorder.leaseClientSupplier());
                    continue;
                }
                if (bodyType != BodyType.DISALLOWED && bodyParamType == null) {
                    bodyParamType = param.type();
                    bodyParamNullability = this.nullability((AnnotationTarget)param);
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    paramMappers.add(new VerbRegistry.BodySupplier(paramType2));
                    continue;
                }
                throw new RuntimeException("Unknown parameter type " + param.type() + " on FTL method: " + method.declaringClass().name() + "." + method.name());
            }
            if (bodyParamType == null) {
                if (bodyType == BodyType.REQUIRED) {
                    throw new RuntimeException("Missing required payload parameter");
                }
                bodyParamType = VoidType.VOID;
            }
            if (callsMetadata.getCallsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setCalls(callsMetadata));
            }
            if (secretMetadata.getSecretsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setSecrets(secretMetadata));
            }
            if (configMetadata.getConfigCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setConfig(configMetadata));
            }
            this.recorder.registerVerb(this.moduleName, verbName, method.name(), parameterTypes, Class.forName(className, false, Thread.currentThread().getContextClassLoader()), paramMappers, method.returnType() == VoidType.VOID);
            verbBuilder.setName(verbName).setExport(exported).setPos(PositionUtils.forMethod(method)).setRequest(this.buildType((org.jboss.jandex.Type)bodyParamType, exported, bodyParamNullability)).setResponse(this.buildType(method.returnType(), exported, (AnnotationTarget)method)).addAllComments(this.comments.getComments(verbName));
            if (metadataCallback != null) {
                metadataCallback.accept(verbBuilder);
            }
            this.addDecls(Decl.newBuilder().setVerb(verbBuilder).build());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process FTL method " + method.declaringClass().name() + "." + method.name(), e);
        }
    }

    private Nullability nullability(AnnotationTarget type) {
        if (type.hasAnnotation(NULLABLE)) {
            return Nullability.NULLABLE;
        }
        if (type.hasAnnotation(NOT_NULL)) {
            return Nullability.NOT_NULL;
        }
        return Nullability.MISSING;
    }

    private Type handleNullabilityAnnotations(Type res, Nullability nullability) {
        if (nullability == Nullability.NOT_NULL) {
            return res;
        }
        if (nullability == Nullability.NULLABLE || this.defaultToOptional) {
            return Type.newBuilder().setOptional(Optional.newBuilder().setType(res)).build();
        }
        return res;
    }

    public Type buildType(org.jboss.jandex.Type type, boolean export, AnnotationTarget target) {
        return this.buildType(type, export, this.nullability(target));
    }

    public Type buildType(org.jboss.jandex.Type type, boolean export, Nullability nullability) {
        switch (type.kind()) {
            case PRIMITIVE: {
                PrimitiveType prim = type.asPrimitiveType();
                switch (prim.primitive()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        return Type.newBuilder().setInt(Int.newBuilder().build()).build();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return Type.newBuilder().setFloat(xyz.block.ftl.v1.schema.Float.newBuilder().build()).build();
                    }
                    case BOOLEAN: {
                        return Type.newBuilder().setBool(Bool.newBuilder().build()).build();
                    }
                    case CHAR: {
                        return Type.newBuilder().setString(xyz.block.ftl.v1.schema.String.newBuilder().build()).build();
                    }
                }
                throw new RuntimeException("unknown primitive type: " + prim.primitive());
            }
            case VOID: {
                return Type.newBuilder().setUnit(Unit.newBuilder().build()).build();
            }
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                if (arrayType.componentType().kind() == Type.Kind.PRIMITIVE && arrayType.componentType().asPrimitiveType().primitive() == PrimitiveType.Primitive.BYTE) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setBytes(Bytes.newBuilder().build()).build(), nullability);
                }
                return this.handleNullabilityAnnotations(Type.newBuilder().setArray(Array.newBuilder().setElement(this.buildType(arrayType.componentType(), export, Nullability.NOT_NULL)).build()).build(), nullability);
            }
            case CLASS: {
                PrimitiveType unboxed;
                ClassType clazz = type.asClassType();
                ClassInfo info = this.index.getClassByName(clazz.name());
                if (info.enclosingClass() != null && !Modifier.isStatic(info.flags())) {
                    this.validationFailures.add(new ValidationFailure(clazz.name().toString(), "Inner classes must be static"));
                }
                if ((unboxed = PrimitiveType.unbox((ClassType)clazz)) != null) {
                    Type primitive = this.buildType((org.jboss.jandex.Type)unboxed, export, Nullability.NOT_NULL);
                    if (nullability == Nullability.NOT_NULL) {
                        return primitive;
                    }
                    return Type.newBuilder().setOptional(Optional.newBuilder().setType(primitive)).build();
                }
                if (info.hasDeclaredAnnotation(FTLDotNames.GENERATED_REF)) {
                    AnnotationInstance ref = info.declaredAnnotation(FTLDotNames.GENERATED_REF);
                    return this.handleNullabilityAnnotations(Type.newBuilder().setRef(Ref.newBuilder().setName(ref.value("name").asString()).setModule(ref.value("module").asString())).build(), nullability);
                }
                if (clazz.name().equals((Object)DotName.STRING_NAME)) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setString(xyz.block.ftl.v1.schema.String.newBuilder().build()).build(), nullability);
                }
                if (clazz.name().equals((Object)DotName.OBJECT_NAME) || clazz.name().equals((Object)JSON_NODE)) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setAny(Any.newBuilder().build()).build(), nullability);
                }
                if (clazz.name().equals((Object)OFFSET_DATE_TIME) || clazz.name().equals((Object)INSTANT) || clazz.name().equals((Object)ZONED_DATE_TIME)) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setTime(Time.newBuilder().build()).build(), nullability);
                }
                String name = clazz.name().local();
                if (this.externalRefs.containsKey(name)) {
                    return Type.newBuilder().setRef(this.externalRefs.get(name)).build();
                }
                Type ref = Type.newBuilder().setRef(Ref.newBuilder().setName(name).setModule(this.moduleName).build()).build();
                if (info.isEnum() || info.hasAnnotation(FTLDotNames.ENUM)) {
                    Enum.Builder ennum = Enum.newBuilder().setName(name).setExport(type.hasAnnotation(FTLDotNames.EXPORT) || export);
                    this.addDecls(Decl.newBuilder().setEnum(ennum.build()).build());
                    return ref;
                }
                if (this.setDeclExport(name, type.hasAnnotation(FTLDotNames.EXPORT) || export)) {
                    return ref;
                }
                Data.Builder data = Data.newBuilder().setPos(PositionUtils.forClass(clazz.name().toString())).setName(name).setExport(type.hasAnnotation(FTLDotNames.EXPORT) || export).addAllComments(this.comments.getComments(name));
                this.buildDataElement(data, clazz.name());
                this.addDecls(Decl.newBuilder().setData(data).build());
                return ref;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType paramType = type.asParameterizedType();
                if (paramType.name().equals((Object)DotName.createSimple(List.class))) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setArray(Array.newBuilder().setElement(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export, Nullability.NOT_NULL))).build(), nullability);
                }
                if (paramType.name().equals((Object)DotName.createSimple(Map.class))) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setMap(xyz.block.ftl.v1.schema.Map.newBuilder().setKey(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export, Nullability.NOT_NULL)).setValue(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(1), export, Nullability.NOT_NULL))).build(), nullability);
                }
                if (paramType.name().equals((Object)DotNames.OPTIONAL)) {
                    return Type.newBuilder().setOptional(Optional.newBuilder().setType(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export, Nullability.NOT_NULL))).build();
                }
                if (paramType.name().equals((Object)DotName.createSimple(HttpRequest.class))) {
                    return Type.newBuilder().setRef(Ref.newBuilder().setModule(BUILTIN).setName(HttpRequest.class.getSimpleName()).addTypeParameters(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export, Nullability.NOT_NULL))).build();
                }
                if (paramType.name().equals((Object)DotName.createSimple(HttpResponse.class))) {
                    return Type.newBuilder().setRef(Ref.newBuilder().setModule(BUILTIN).setName(HttpResponse.class.getSimpleName()).addTypeParameters(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), export, Nullability.NOT_NULL)).addTypeParameters(Type.newBuilder().setUnit(Unit.newBuilder().build()))).build();
                }
                ClassInfo classByName = this.index.getClassByName(paramType.name());
                this.validateName(classByName.name().toString(), classByName.name().local());
                ClassType.Builder cb = ClassType.builder((DotName)classByName.name());
                Type main = this.buildType((org.jboss.jandex.Type)cb.build(), export, Nullability.NOT_NULL);
                Type.Builder builder = main.toBuilder();
                Ref.Builder refBuilder = builder.getRef().toBuilder();
                for (org.jboss.jandex.Type arg : paramType.arguments()) {
                    refBuilder.addTypeParameters(this.buildType(arg, export, Nullability.NOT_NULL));
                }
                builder.setRef(refBuilder);
                return this.handleNullabilityAnnotations(builder.build(), nullability);
            }
        }
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    private void buildDataElement(Data.Builder data, DotName className) {
        if (className == null || className.equals((Object)DotName.OBJECT_NAME)) {
            return;
        }
        ClassInfo clazz = this.index.getClassByName(className);
        if (clazz == null) {
            return;
        }
        for (FieldInfo field : clazz.fields()) {
            AnnotationInstance aliases;
            if (Modifier.isStatic(field.flags())) continue;
            Field.Builder builder = Field.newBuilder().setName(field.name()).setType(this.buildType(field.type(), data.getExport(), (AnnotationTarget)field));
            if (field.hasAnnotation(JsonAlias.class) && (aliases = field.annotation(JsonAlias.class)).value() != null) {
                for (String alias : aliases.value().asStringArray()) {
                    builder.addMetadata(Metadata.newBuilder().setAlias(MetadataAlias.newBuilder().setKind(AliasKind.ALIAS_KIND_JSON).setAlias(alias)));
                }
            }
            data.addFields(builder.build());
        }
        this.buildDataElement(data, clazz.superName());
    }

    public ModuleBuilder addDecls(Decl decl) {
        if (decl.hasData()) {
            Data data = decl.getData();
            if (!this.setDeclExport(data.getName(), data.getExport())) {
                this.addDecl(decl, data.getPos(), data.getName());
            }
        } else if (decl.hasEnum()) {
            Enum enuum = decl.getEnum();
            if (!this.updateEnum(enuum.getName(), decl)) {
                this.addDecl(decl, enuum.getPos(), enuum.getName());
            }
        } else if (decl.hasDatabase()) {
            this.addDecl(decl, decl.getDatabase().getPos(), decl.getDatabase().getName());
        } else if (decl.hasConfig()) {
            this.addDecl(decl, decl.getConfig().getPos(), decl.getConfig().getName());
        } else if (decl.hasSecret()) {
            this.addDecl(decl, decl.getSecret().getPos(), decl.getSecret().getName());
        } else if (decl.hasVerb()) {
            this.addDecl(decl, decl.getVerb().getPos(), decl.getVerb().getName());
        } else if (decl.hasTypeAlias()) {
            this.addDecl(decl, decl.getTypeAlias().getPos(), decl.getTypeAlias().getName());
        } else if (decl.hasTopic()) {
            this.addDecl(decl, decl.getTopic().getPos(), decl.getTopic().getName());
        } else if (decl.hasSubscription()) {
            this.addDecl(decl, decl.getSubscription().getPos(), decl.getSubscription().getName());
        }
        return this;
    }

    public int getDeclsCount() {
        return this.decls.size();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.decls.values().stream().forEachOrdered(arg_0 -> ((Module.Builder)this.protoModuleBuilder).addDecls(arg_0));
        if (!this.validationFailures.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ValidationFailure failure : this.validationFailures) {
                sb.append("Validation failure: ").append(failure.className).append(": ").append(failure.message).append("\n");
            }
            throw new RuntimeException(sb.toString());
        }
        this.protoModuleBuilder.build().writeTo(out);
    }

    public void registerTypeAlias(String name, org.jboss.jandex.Type finalT, org.jboss.jandex.Type finalS, boolean exported, Map<String, String> languageMappings) {
        this.validateName(finalT.name().toString(), name);
        TypeAlias.Builder typeAlias = TypeAlias.newBuilder().setType(this.buildType(finalS, exported, Nullability.NOT_NULL)).setName(name).addAllComments(this.comments.getComments(name)).addMetadata(Metadata.newBuilder().setTypeMap(MetadataTypeMap.newBuilder().setRuntime("java").setNativeName(finalT.toString()).build()).build());
        for (Map.Entry<String, String> entry : languageMappings.entrySet()) {
            typeAlias.addMetadata(Metadata.newBuilder().setTypeMap(MetadataTypeMap.newBuilder().setRuntime(entry.getKey()).setNativeName(entry.getValue()).build()).build());
        }
        this.addDecls(Decl.newBuilder().setTypeAlias(typeAlias).build());
    }

    public void registerExternalType(String module, String name) {
        Ref ref = Ref.newBuilder().setModule(module).setName(name).build();
        this.externalRefs.put(name, ref);
    }

    private void addDecl(Decl decl, Position pos, String name) {
        this.validateName(pos, name);
        if (this.decls.containsKey(name)) {
            this.duplicateNameValidationError(name, pos);
        }
        this.decls.put(name, decl);
    }

    private boolean updateEnum(String name, Decl decl) {
        if (this.decls.containsKey(name)) {
            Decl existing = this.decls.get(name);
            if (!existing.hasEnum()) {
                this.duplicateNameValidationError(name, decl.getEnum().getPos());
            }
            Decl moreComplete = decl.getEnum().getVariantsCount() > 0 ? decl : existing;
            Decl lessComplete = decl.getEnum().getVariantsCount() > 0 ? existing : decl;
            boolean export = lessComplete.getEnum().getExport() || existing.getEnum().getExport();
            Enum merged = moreComplete.getEnum().toBuilder().setExport(export).build();
            this.decls.put(name, Decl.newBuilder().setEnum(merged).build());
            if (export) {
                for (EnumVariant childDecl : merged.getVariantsList()) {
                    if (!childDecl.getValue().hasTypeValue() || !childDecl.getValue().getTypeValue().getValue().hasRef()) continue;
                    Ref ref = childDecl.getValue().getTypeValue().getValue().getRef();
                    this.setDeclExport(ref.getName(), true);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setDeclExport(String name, boolean export) {
        Decl existing = this.decls.get(name);
        if (existing != null) {
            if (existing.hasData()) {
                Data merged = existing.getData().toBuilder().setExport(export || existing.getData().getExport()).build();
                this.decls.put(name, Decl.newBuilder().setData(merged).build());
            } else if (existing.hasTypeAlias()) {
                TypeAlias merged = existing.getTypeAlias().toBuilder().setExport(export || existing.getData().getExport()).build();
                this.decls.put(name, Decl.newBuilder().setTypeAlias(merged).build());
            }
        }
        return existing != null;
    }

    private void duplicateNameValidationError(String name, Position pos) {
        this.validationFailures.add(new ValidationFailure(name, String.format("schema declaration with name \"%s\" already exists for module \"%s\"; previously declared at \"%s\"", name, this.moduleName, pos.getFilename() + ":" + pos.getLine())));
    }

    String validateName(Position position, String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            this.validationFailures.add(new ValidationFailure((String)(position == null ? "<unknown>" : position.getFilename() + ":" + position.getLine()), String.format("Invalid name %s, must match " + NAME_PATTERN, name)));
        }
        return name;
    }

    String validateName(String className, String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            this.validationFailures.add(new ValidationFailure(className, String.format("Invalid name %s, must match " + NAME_PATTERN, name)));
        }
        return name;
    }

    public static enum BodyType {
        DISALLOWED,
        ALLOWED,
        REQUIRED;

    }

    record ValidationFailure(String className, String message) {
    }
}

