/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import xyz.block.ftl.Topic;
import xyz.block.ftl.deployment.FTLDotNames;

public final class SubscriptionMetaAnnotationsBuildItem
extends SimpleBuildItem {
    private final Map<DotName, SubscriptionAnnotation> annotations;

    public SubscriptionMetaAnnotationsBuildItem(Map<DotName, SubscriptionAnnotation> annotations) {
        this.annotations = annotations;
    }

    public Map<DotName, SubscriptionAnnotation> getAnnotations() {
        return this.annotations;
    }

    public static SubscriptionAnnotation fromJandex(IndexView indexView, AnnotationInstance subscriptions, String currentModuleName) {
        String topicName;
        AnnotationValue moduleValue = subscriptions.value("module");
        AnnotationValue topicValue = subscriptions.value("topic");
        AnnotationValue topicClassValue = subscriptions.value("topicClass");
        if (topicValue != null && !topicValue.asString().isEmpty()) {
            if (topicClassValue != null && !topicClassValue.asClass().name().toString().equals(Topic.class.getName())) {
                throw new IllegalArgumentException("Cannot specify both topic and topicClass");
            }
            topicName = topicValue.asString();
        } else if (topicClassValue != null && !topicClassValue.asClass().name().toString().equals(Topic.class.getName())) {
            ClassInfo topicClass = indexView.getClassByName(topicClassValue.asClass().name());
            AnnotationInstance annotation = topicClass.annotation(FTLDotNames.TOPIC_DEFINITION);
            if (annotation == null) {
                throw new IllegalArgumentException("topicClass must be annotated with @TopicDefinition for subscription " + subscriptions);
            }
            topicName = annotation.value().asString();
        } else {
            throw new IllegalArgumentException("Either topic or topicClass must be specified on " + subscriptions);
        }
        return new SubscriptionAnnotation(moduleValue == null || moduleValue.asString().isEmpty() ? currentModuleName : moduleValue.asString(), topicName, subscriptions.value("name").asString());
    }

    public record SubscriptionAnnotation(String module, String topic, String name) {
    }
}

