/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import xyz.block.ftl.FromOffset;
import xyz.block.ftl.Retry;
import xyz.block.ftl.Subscription;
import xyz.block.ftl.SubscriptionOptions;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.ModuleNameBuildItem;
import xyz.block.ftl.deployment.RetryRecord;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.SubscriptionMetaAnnotationsBuildItem;
import xyz.block.ftl.v1.schema.Metadata;
import xyz.block.ftl.v1.schema.MetadataRetry;
import xyz.block.ftl.v1.schema.MetadataSubscriber;
import xyz.block.ftl.v1.schema.Ref;

public class SubscriptionProcessor {
    private static final Logger log = Logger.getLogger(SubscriptionProcessor.class);

    @BuildStep
    SubscriptionMetaAnnotationsBuildItem subscriptionAnnotations(CombinedIndexBuildItem combinedIndexBuildItem, ModuleNameBuildItem moduleNameBuildItem) {
        Collection subscriptionAnnotations = combinedIndexBuildItem.getComputingIndex().getAnnotations(Subscription.class);
        log.infof("Processing %s subscription annotations into decls", (Object)subscriptionAnnotations.size());
        HashMap<DotName, SubscriptionMetaAnnotationsBuildItem.SubscriptionAnnotation> annotations = new HashMap<DotName, SubscriptionMetaAnnotationsBuildItem.SubscriptionAnnotation>();
        for (AnnotationInstance subscriptions : subscriptionAnnotations) {
            if (subscriptions.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            annotations.put(subscriptions.target().asClass().name(), SubscriptionMetaAnnotationsBuildItem.fromJandex(combinedIndexBuildItem.getComputingIndex(), subscriptions, moduleNameBuildItem.getModuleName()));
        }
        return new SubscriptionMetaAnnotationsBuildItem(annotations);
    }

    @BuildStep
    public void registerSubscriptions(CombinedIndexBuildItem index, ModuleNameBuildItem moduleNameBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, SubscriptionMetaAnnotationsBuildItem subscriptionMetaAnnotationsBuildItem, BuildProducer<SchemaContributorBuildItem> schemaContributorBuildItems) throws Exception {
        AdditionalBeanBuildItem.Builder beans = AdditionalBeanBuildItem.builder().setUnremovable();
        String moduleName = moduleNameBuildItem.getModuleName();
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(FTLDotNames.SUBSCRIPTION)) {
            SubscriptionMetaAnnotationsBuildItem.SubscriptionAnnotation info = SubscriptionMetaAnnotationsBuildItem.fromJandex(index.getComputingIndex(), annotationInstance, moduleName);
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo method = annotationInstance.target().asMethod();
            String className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItems.produce((BuildItem)this.generateSubscription(method, className, info));
        }
        for (Map.Entry entry : subscriptionMetaAnnotationsBuildItem.getAnnotations().entrySet()) {
            for (AnnotationInstance subscription : index.getIndex().getAnnotations((DotName)entry.getKey())) {
                if (subscription.target().kind() != AnnotationTarget.Kind.METHOD) {
                    log.warnf("Subscription annotation on non-method target: %s", (Object)subscription.target());
                    continue;
                }
                MethodInfo method = subscription.target().asMethod();
                String className = method.declaringClass().name().toString();
                beans.addBeanClass(className);
                schemaContributorBuildItems.produce((BuildItem)this.generateSubscription(method, className, (SubscriptionMetaAnnotationsBuildItem.SubscriptionAnnotation)entry.getValue()));
            }
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beans.build());
    }

    private SchemaContributorBuildItem generateSubscription(MethodInfo method, String className, SubscriptionMetaAnnotationsBuildItem.SubscriptionAnnotation info) {
        return new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, false, ModuleBuilder.BodyType.REQUIRED, builder -> {
            if (!method.hasAnnotation(SubscriptionOptions.class)) {
                throw new RuntimeException("Subscription must have SubscriptionOptions annotation");
            }
            SubscriptionMetaAnnotationsBuildItem.SubscriptionOptionsAnnotation options = SubscriptionMetaAnnotationsBuildItem.SubscriptionOptionsAnnotation.fromJandex(method.annotation(SubscriptionOptions.class));
            builder.addMetadata(Metadata.newBuilder().setSubscriber(MetadataSubscriber.newBuilder().setTopic(Ref.newBuilder().setName(info.topic()).setModule(info.module()).build()).setFromOffset(options.from() == FromOffset.BEGINNING ? xyz.block.ftl.v1.schema.FromOffset.FROM_OFFSET_BEGINNING : xyz.block.ftl.v1.schema.FromOffset.FROM_OFFSET_LATEST).setDeadLetter(options.deadLetter())));
            if (method.hasAnnotation(Retry.class)) {
                RetryRecord retry = RetryRecord.fromJandex(method.annotation(Retry.class), moduleBuilder.getModuleName());
                MetadataRetry.Builder retryBuilder = MetadataRetry.newBuilder();
                if (!retry.catchVerb().isEmpty()) {
                    retryBuilder.setCatch(Ref.newBuilder().setModule(retry.catchModule()).setName(retry.catchVerb()).build());
                }
                retryBuilder.setCount((long)retry.count()).setMaxBackoff(retry.maxBackoff()).setMinBackoff(retry.minBackoff());
                builder.addMetadata(Metadata.newBuilder().setRetry(retryBuilder).build());
            }
        }));
    }
}

