/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.VoidType;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.Nullability;
import xyz.block.ftl.deployment.PositionUtils;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.builtin.HttpRequest;
import xyz.block.ftl.runtime.builtin.HttpResponse;
import xyz.block.ftl.schema.v1.Array;
import xyz.block.ftl.schema.v1.Decl;
import xyz.block.ftl.schema.v1.IngressPathComponent;
import xyz.block.ftl.schema.v1.IngressPathLiteral;
import xyz.block.ftl.schema.v1.IngressPathParameter;
import xyz.block.ftl.schema.v1.Map;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataIngress;
import xyz.block.ftl.schema.v1.Ref;
import xyz.block.ftl.schema.v1.String;
import xyz.block.ftl.schema.v1.Type;
import xyz.block.ftl.schema.v1.Unit;
import xyz.block.ftl.schema.v1.Verb;

public class HTTPProcessor {
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public MethodScannerBuildItem methodScanners(final TopicsBuildItem topics, final VerbClientBuildItem verbClients, final FTLRecorder recorder) {
        return new MethodScannerBuildItem(new MethodScanner(){

            public ParameterExtractor handleCustomParameter(org.jboss.jandex.Type type, java.util.Map<DotName, AnnotationInstance> annotations, boolean field, java.util.Map<java.lang.String, Object> methodContext) {
                try {
                    if (annotations.containsKey(FTLDotNames.SECRET)) {
                        Class<?> paramType = ModuleBuilder.loadClass(type);
                        java.lang.String name = annotations.get(FTLDotNames.SECRET).value().asString();
                        return new VerbRegistry.SecretSupplier(name, paramType);
                    }
                    if (annotations.containsKey(FTLDotNames.CONFIG)) {
                        Class<?> paramType = ModuleBuilder.loadClass(type);
                        java.lang.String name = annotations.get(FTLDotNames.CONFIG).value().asString();
                        return new VerbRegistry.ConfigSupplier(name, paramType);
                    }
                    if (topics.getTopics().containsKey(type.name())) {
                        TopicsBuildItem.DiscoveredTopic topic = topics.getTopics().get(type.name());
                        return recorder.topicParamExtractor(topic.generatedProducer());
                    }
                    if (verbClients.getVerbClients().containsKey(type.name())) {
                        VerbClientBuildItem.DiscoveredClients client = verbClients.getVerbClients().get(type.name());
                        return recorder.verbParamExtractor(client.generatedClient());
                    }
                    if (FTLDotNames.LEASE_CLIENT.equals((Object)type.name())) {
                        return recorder.leaseClientExtractor();
                    }
                    return null;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public SchemaContributorBuildItem registerHttpHandlers(final FTLRecorder recorder, final ResteasyReactiveResourceMethodEntriesBuildItem restEndpoints) {
        return new SchemaContributorBuildItem(new Consumer<ModuleBuilder>(){

            @Override
            public void accept(ModuleBuilder moduleBuilder) {
                for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry endpoint : restEndpoints.getEntries()) {
                    org.jboss.jandex.Type component;
                    java.lang.String verbName = ModuleBuilder.methodToName(endpoint.getMethodInfo());
                    boolean base64 = false;
                    VoidType bodyParamType = VoidType.VOID;
                    MethodParameter[] parameters = endpoint.getResourceMethod().getParameters();
                    int parametersLength = parameters.length;
                    for (int i = 0; i < parametersLength; ++i) {
                        MethodParameter param = parameters[i];
                        if (!param.parameterType.equals((Object)ParameterType.BODY)) continue;
                        bodyParamType = endpoint.getMethodInfo().parameterType(i);
                        break;
                    }
                    if (bodyParamType instanceof ArrayType && (component = ((ArrayType)bodyParamType).component()) instanceof PrimitiveType) {
                        base64 = component.asPrimitiveType().equals((Object)PrimitiveType.BYTE);
                    }
                    recorder.registerHttpIngress(moduleBuilder.getModuleName(), verbName, base64);
                    StringBuilder pathBuilder = new StringBuilder();
                    if (endpoint.getBasicResourceClassInfo().getPath() != null) {
                        pathBuilder.append(endpoint.getBasicResourceClassInfo().getPath());
                    }
                    if (endpoint.getResourceMethod().getPath() != null && !endpoint.getResourceMethod().getPath().isEmpty()) {
                        boolean builderEndsSlash = pathBuilder.charAt(pathBuilder.length() - 1) == '/';
                        boolean pathStartsSlash = endpoint.getResourceMethod().getPath().startsWith("/");
                        if (builderEndsSlash && pathStartsSlash) {
                            pathBuilder.setLength(pathBuilder.length() - 1);
                        } else if (!builderEndsSlash && !pathStartsSlash) {
                            pathBuilder.append('/');
                        }
                        pathBuilder.append(endpoint.getResourceMethod().getPath());
                    }
                    java.lang.String path = pathBuilder.toString();
                    URITemplate template = new URITemplate(path, false);
                    ArrayList<IngressPathComponent> pathComponents = new ArrayList<IngressPathComponent>();
                    for (URITemplate.TemplateComponent i : template.components) {
                        if (i.type == URITemplate.Type.CUSTOM_REGEX) {
                            throw new RuntimeException("Invalid path " + path + " on HTTP endpoint: " + endpoint.getActualClassInfo().name() + "." + ModuleBuilder.methodToName(endpoint.getMethodInfo()) + " FTL does not support custom regular expressions");
                        }
                        if (i.type == URITemplate.Type.LITERAL) {
                            for (java.lang.String part : i.literalText.split("/")) {
                                if (part.isEmpty()) continue;
                                pathComponents.add(IngressPathComponent.newBuilder().setIngressPathLiteral(IngressPathLiteral.newBuilder().setText(part)).build());
                            }
                            continue;
                        }
                        pathComponents.add(IngressPathComponent.newBuilder().setIngressPathParameter(IngressPathParameter.newBuilder().setName(i.name)).build());
                    }
                    MetadataIngress.Builder ingressBuilder = MetadataIngress.newBuilder().setType("http").setMethod(endpoint.getResourceMethod().getHttpMethod());
                    for (IngressPathComponent i : pathComponents) {
                        ingressBuilder.addPath(i);
                    }
                    Metadata ingressMetadata = Metadata.newBuilder().setIngress(ingressBuilder.build()).build();
                    Type requestTypeParam = moduleBuilder.buildType((org.jboss.jandex.Type)bodyParamType, true, Nullability.NOT_NULL);
                    Type responseTypeParam = moduleBuilder.buildType(endpoint.getMethodInfo().returnType(), true, Nullability.NOT_NULL);
                    Type stringType = Type.newBuilder().setString(String.newBuilder().build()).build();
                    Type pathParamType = Type.newBuilder().setMap(Map.newBuilder().setKey(stringType).setValue(stringType)).build();
                    moduleBuilder.addDecls(Decl.newBuilder().setVerb(Verb.newBuilder().addMetadata(ingressMetadata).setName(verbName).setPos(PositionUtils.forMethod(endpoint.getMethodInfo())).setExport(true).setRequest(Type.newBuilder().setRef(Ref.newBuilder().setModule("builtin").setName(HttpRequest.class.getSimpleName()).addTypeParameters(requestTypeParam).addTypeParameters(pathParamType).addTypeParameters(Type.newBuilder().setMap(Map.newBuilder().setKey(stringType).setValue(Type.newBuilder().setArray(Array.newBuilder().setElement(stringType))).build()))).build()).setResponse(Type.newBuilder().setRef(Ref.newBuilder().setModule("builtin").setName(HttpResponse.class.getSimpleName()).addTypeParameters(responseTypeParam).addTypeParameters(Type.newBuilder().setUnit(Unit.newBuilder()))).build())).build());
                }
            }
        });
    }
}

