/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.v1.GetDeploymentContextResponse;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.schema.v1.Database;
import xyz.block.ftl.schema.v1.Decl;

public class DatasourceProcessor {
    private static final Logger log = Logger.getLogger(DatasourceProcessor.class);

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public SchemaContributorBuildItem registerDatasources(List<JdbcDataSourceBuildItem> datasources, BuildProducer<SystemPropertyBuildItem> systemPropProducer, BuildProducer<GeneratedResourceBuildItem> generatedResourceBuildItemBuildProducer, FTLRecorder recorder) {
        log.debugf("Processing %d datasource annotations into decls", datasources.size());
        ArrayList<Decl> decls = new ArrayList<Decl>();
        ArrayList<String> namedDatasources = new ArrayList<String>();
        for (JdbcDataSourceBuildItem ds : datasources) {
            String dbKind = ds.getDbKind();
            if (!dbKind.equals("postgresql") && !dbKind.equals("mysql")) {
                throw new RuntimeException("only postgresql and mysql is supported not " + dbKind);
            }
            if (dbKind.equals("postgresql")) {
                dbKind = "postgres";
            }
            if (dbKind.equals("mysql")) {
                recorder.registerDatabase(ds.getName(), GetDeploymentContextResponse.DbType.DB_TYPE_MYSQL);
            } else {
                recorder.registerDatabase(ds.getName(), GetDeploymentContextResponse.DbType.DB_TYPE_POSTGRES);
            }
            String sanitisedName = ds.getName().replace("<", "").replace(">", "");
            if (ds.isDefault()) {
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource.credentials-provider", sanitisedName));
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource.credentials-provider-name", "ftl-datasource-credentials"));
            } else {
                namedDatasources.add(ds.getName());
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource." + ds.getName() + ".credentials-provider", sanitisedName));
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource." + ds.getName() + ".credentials-provider-name", "ftl-datasource-credentials"));
            }
            decls.add(Decl.newBuilder().setDatabase(Database.newBuilder().setType(dbKind).setName(sanitisedName)).build());
        }
        generatedResourceBuildItemBuildProducer.produce((BuildItem)new GeneratedResourceBuildItem("ftl-datasource-names.txt", String.join((CharSequence)"\n", namedDatasources).getBytes(StandardCharsets.UTF_8)));
        return new SchemaContributorBuildItem(decls);
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem sqlMigrations() {
        return HotDeploymentWatchedFileBuildItem.builder().setRestartNeeded(true).setLocationPredicate(s -> s.startsWith("db/") && s.endsWith(".sql")).build();
    }
}

