/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.gizmo.DescriptorUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.block.ftl.schema.v1.Position;

public class PositionUtils {
    private static final Logger LOG = Logger.getLogger(PositionUtils.class);

    public static Position forMethod(MethodInfo method) {
        return PositionUtils.getLineNumber(method.declaringClass().name().toString(), method);
    }

    public static Position forClass(String className) {
        return PositionUtils.getLineNumber(className, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static Position getLineNumber(String className, MethodInfo method) {
        Position.Builder builder = Position.newBuilder();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL cls = cl.getResource(className.replace('.', '/') + ".class");
            if (cls == null) {
                return builder.build();
            }
            try (InputStream in = cls.openStream();){
                ClassReader reader = new ClassReader(in);
                ClassNode clNode = new ClassNode(589824);
                reader.accept((ClassVisitor)clNode, 589824);
                if (clNode.sourceFile == null) {
                    Position position = builder.build();
                    return position;
                }
                builder.setFilename(clNode.sourceFile);
                if (method != null) {
                    String descriptor = DescriptorUtils.methodSignatureToDescriptor((String)method.returnType().descriptor(), (String[])((String[])method.parameters().stream().map(p -> p.type().descriptor()).toArray(String[]::new)));
                    for (MethodNode mNode : clNode.methods) {
                        if (!mNode.name.equals(method.name()) || !mNode.desc.equals(descriptor)) continue;
                        for (AbstractInsnNode inNode : mNode.instructions) {
                            if (!(inNode instanceof LineNumberNode)) continue;
                            builder.setLine((long)((LineNumberNode)inNode).line);
                            Position position = builder.build();
                            return position;
                        }
                    }
                }
                Position position = builder.build();
                return position;
            }
            catch (IOException e) {
                LOG.errorf((Throwable)e, "Failed to read class %s", (Object)className);
                return builder.build();
            }
        }
        catch (IllegalStateException e) {
            return builder.build();
        }
    }
}

