/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import xyz.block.ftl.hotreload.RunnerInfo;
import xyz.block.ftl.hotreload.RunnerNotification;
import xyz.block.ftl.hotreload.v1.Database;
import xyz.block.ftl.hotreload.v1.HotReloadServiceGrpc;
import xyz.block.ftl.hotreload.v1.ReloadRequest;
import xyz.block.ftl.hotreload.v1.ReloadResponse;
import xyz.block.ftl.hotreload.v1.RunnerInfoRequest;
import xyz.block.ftl.hotreload.v1.RunnerInfoResponse;
import xyz.block.ftl.hotreload.v1.SchemaState;
import xyz.block.ftl.hotreload.v1.WatchRequest;
import xyz.block.ftl.hotreload.v1.WatchResponse;
import xyz.block.ftl.language.v1.Error;
import xyz.block.ftl.language.v1.ErrorList;
import xyz.block.ftl.v1.PingRequest;
import xyz.block.ftl.v1.PingResponse;

public class HotReloadHandler
extends HotReloadServiceGrpc.HotReloadServiceImplBase {
    private static final Logger LOG = Logger.getLogger(HotReloadHandler.class);
    private static volatile HotReloadHandler INSTANCE;
    private volatile SchemaState lastState;
    private volatile Server server;
    private volatile Consumer<SchemaState> runningReload;
    private volatile boolean starting;
    private final List<StreamObserver<WatchResponse>> watches = Collections.synchronizedList(new ArrayList());

    public static HotReloadHandler getInstance() {
        HotReloadHandler.start();
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setResults(SchemaState state) {
        this.lastState = state;
        if (this.runningReload != null) {
            this.runningReload.accept(state);
        } else {
            ArrayList<StreamObserver<WatchResponse>> watches;
            List<StreamObserver<WatchResponse>> list = this.watches;
            synchronized (list) {
                watches = new ArrayList<StreamObserver<WatchResponse>>(this.watches);
            }
            for (StreamObserver streamObserver : watches) {
                try {
                    streamObserver.onNext((Object)WatchResponse.newBuilder().setState(state).build());
                }
                catch (Exception e) {
                    LOG.debugf("Failed to send watch response %s", (Object)e.toString());
                    this.watches.remove(streamObserver);
                }
            }
        }
    }

    public void ping(PingRequest request, StreamObserver<PingResponse> responseObserver) {
        responseObserver.onNext((Object)PingResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ReloadRequest request, StreamObserver<ReloadResponse> responseObserver) {
        HotReloadHandler hotReloadHandler = this;
        synchronized (hotReloadHandler) {
            RunnerNotification.reloadStarted();
            while (this.starting) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.starting = true;
            this.runningReload = state -> {
                HotReloadHandler hotReloadHandler = this;
                synchronized (hotReloadHandler) {
                    this.runningReload = null;
                    ((Object)((Object)this)).notifyAll();
                    Throwable compileProblem = RuntimeUpdatesProcessor.INSTANCE.getCompileProblem();
                    Throwable deploymentProblems = RuntimeUpdatesProcessor.INSTANCE.getDeploymentProblem();
                    if (compileProblem != null || deploymentProblems != null) {
                        ErrorList.Builder builder = ErrorList.newBuilder();
                        if (compileProblem != null) {
                            builder.addErrors(Error.newBuilder().setLevel(Error.ErrorLevel.ERROR_LEVEL_ERROR).setType(Error.ErrorType.ERROR_TYPE_COMPILER).setMsg(compileProblem.getMessage()).build());
                        }
                        if (deploymentProblems != null) {
                            builder.addErrors(Error.newBuilder().setLevel(Error.ErrorLevel.ERROR_LEVEL_ERROR).setType(Error.ErrorType.ERROR_TYPE_FTL).setMsg(deploymentProblems.getMessage()).build());
                        }
                        ErrorList errors = builder.build();
                        responseObserver.onNext((Object)ReloadResponse.newBuilder().setState(SchemaState.newBuilder().setErrors(errors).build()).setFailed(true).build());
                        responseObserver.onCompleted();
                    } else {
                        RunnerNotification.setRunnerVersion((long)state.getVersion());
                        responseObserver.onNext((Object)ReloadResponse.newBuilder().setState(state).setFailed(false).build());
                        responseObserver.onCompleted();
                    }
                }
            };
        }
        Thread t = new Thread(() -> {
            try {
                this.doScan();
            }
            finally {
                HotReloadHandler hotReloadHandler = this;
                synchronized (hotReloadHandler) {
                    this.starting = false;
                    ((Object)((Object)this)).notifyAll();
                }
            }
            if (this.runningReload != null) {
                this.runningReload.accept(this.lastState);
            }
        }, "FTL Restart Thread");
        t.start();
    }

    public void watch(WatchRequest request, StreamObserver<WatchResponse> responseObserver) {
        if (this.lastState != null) {
            responseObserver.onNext((Object)WatchResponse.newBuilder().setState(this.lastState).build());
        }
        this.watches.add(responseObserver);
    }

    public void runnerInfo(RunnerInfoRequest request, StreamObserver<RunnerInfoResponse> responseObserver) {
        HashMap<String, String> databases = new HashMap<String, String>();
        for (Database db : request.getDatabasesList()) {
            databases.put(db.getName(), db.getAddress());
        }
        boolean outdated = RunnerNotification.setRunnerInfo((RunnerInfo)new RunnerInfo(request.getAddress(), request.getDeployment(), databases, request.getVersion()));
        if (outdated) {
            LOG.debugf("Runner is outdated, a reload is required, runner version %s, current %s", request.getVersion(), RunnerNotification.getRunnerVersion());
        }
        responseObserver.onNext((Object)RunnerInfoResponse.newBuilder().setOutdated(outdated).build());
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (INSTANCE != null) {
            return;
        }
        Class<HotReloadHandler> clazz = HotReloadHandler.class;
        synchronized (HotReloadHandler.class) {
            if (INSTANCE == null) {
                HotReloadHandler hr = new HotReloadHandler();
                hr.init();
                INSTANCE = hr;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void init() {
        RuntimeUpdatesProcessor.INSTANCE.setLiveReloadEnabled(false);
        int port = Integer.getInteger("ftl.language.port");
        this.server = ServerBuilder.forPort((int)port).addService((BindableService)this).build();
        try {
            LOG.debugf("Starting Hot Reload gRPC server on port %s", port);
            this.server.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((QuarkusClassLoader)HotReloadHandler.class.getClassLoader()).addCloseTask(new Runnable(){

            @Override
            public void run() {
                HotReloadHandler.this.server.shutdownNow();
            }
        });
    }

    void doScan() {
        if (RuntimeUpdatesProcessor.INSTANCE != null) {
            try {
                RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
            }
            catch (Exception e) {
                Logger.getLogger(HotReloadHandler.class).error((Object)"Failed to scan for changes", (Throwable)e);
            }
        }
    }
}

