/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import xyz.block.ftl.SQLQueryClient;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.ModuleNameBuildItem;
import xyz.block.ftl.deployment.SQLQueryClientBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TypeAliasBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.deployment.VerbType;
import xyz.block.ftl.runtime.VerbClientHelper;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataCronJob;

public class VerbProcessor {
    public static final String TEST_ANNOTATION = "xyz.block.ftl.java.test.FTLManaged";
    private static final Logger log = Logger.getLogger(VerbProcessor.class);

    @BuildStep
    VerbClientBuildItem handleVerbClients(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedClients, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, ModuleNameBuildItem moduleNameBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        Collection clientDefinitions = index.getComputingIndex().getAnnotations(VerbClient.class);
        log.debugf("Processing %d verb clients", clientDefinitions.size());
        HashMap<DotName, VerbClientBuildItem.DiscoveredClients> clients = new HashMap<DotName, VerbClientBuildItem.DiscoveredClients>();
        for (AnnotationInstance clientDefinition : clientDefinitions) {
            MethodInfo callMethod = clientDefinition.target().asMethod();
            ClassInfo iface = callMethod.declaringClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@VerbClient can only be applied to interfaces and " + String.valueOf(iface.name()) + " is not an interface");
            }
            String name = callMethod.name();
            AnnotationValue moduleValue = clientDefinition.value("module");
            String module = moduleValue == null || moduleValue.asString().isEmpty() ? moduleNameBuildItem.getModuleName() : moduleValue.asString();
            Object classOutput = launchModeBuildItem.isTest() ? new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer) : new GeneratedClassGizmoAdaptor(generatedClients, true);
            Type returnType = callMethod.returnType();
            Type paramType = callMethod.parametersCount() > 0 ? callMethod.parameterType(0) : null;
            try (ClassCreator cc = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});){
                if (launchModeBuildItem.isTest()) {
                    cc.addAnnotation(TEST_ANNOTATION);
                    cc.addAnnotation(Singleton.class);
                }
                switch (VerbType.of(callMethod)) {
                    case VERB: {
                        ResultHandle helper;
                        MethodCreator publish;
                        LinkedHashSet<Map.Entry<String, String>> signatures = new LinkedHashSet<Map.Entry<String, String>>();
                        signatures.add(Map.entry(returnType.name().toString(), paramType.name().toString()));
                        signatures.add(Map.entry(Object.class.getName(), Object.class.getName()));
                        for (Map.Entry entry : signatures) {
                            publish = cc.getMethodCreator(name, (String)entry.getKey(), new String[]{(String)entry.getValue()});
                            helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.getMethodParam(0), publish.loadClass(returnType.name().toString()), publish.load(false), publish.load(false)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case SINK: {
                        LinkedHashSet<String> sinkSignatures = new LinkedHashSet<String>();
                        sinkSignatures.add(paramType.name().toString());
                        sinkSignatures.add(Object.class.getName());
                        for (Object sig2 : sinkSignatures) {
                            MethodCreator publish = cc.getMethodCreator(name, Void.TYPE, new Object[]{sig2});
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.getMethodParam(0), publish.loadClass(Void.class), publish.load(false), publish.load(false)});
                            publish.returnVoid();
                        }
                        break;
                    }
                    case SOURCE: {
                        Object sig2;
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        linkedHashSet.add(returnType.name().toString());
                        linkedHashSet.add(Object.class.getName());
                        sig2 = linkedHashSet.iterator();
                        while (sig2.hasNext()) {
                            String sig = (String)sig2.next();
                            MethodCreator publish = cc.getMethodCreator(name, sig, new String[0]);
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.loadNull(), publish.loadClass(returnType.name().toString()), publish.load(false), publish.load(false)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case EMPTY: {
                        MethodCreator publish = cc.getMethodCreator(name, Void.TYPE, new Class[0]);
                        ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                        publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{publish.load(name), publish.load(module), publish.loadNull(), publish.loadClass(Void.class), publish.load(false), publish.load(false)});
                        publish.returnVoid();
                    }
                }
                clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, module, cc.getClassName()));
            }
        }
        return new VerbClientBuildItem(clients);
    }

    @BuildStep
    SQLQueryClientBuildItem handleSQLQueryClients(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedClients, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, ModuleNameBuildItem moduleNameBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        Collection clientDefinitions = index.getComputingIndex().getAnnotations(SQLQueryClient.class);
        if (clientDefinitions.isEmpty()) {
            return new SQLQueryClientBuildItem(Map.of());
        }
        HashMap<DotName, SQLQueryClientBuildItem.DiscoveredClients> clients = new HashMap<DotName, SQLQueryClientBuildItem.DiscoveredClients>();
        for (AnnotationInstance clientDefinition : clientDefinitions) {
            MethodInfo callMethod = clientDefinition.target().asMethod();
            ClassInfo iface = callMethod.declaringClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@SQLQueryClient can only be applied to methods in interfaces and " + String.valueOf(callMethod) + " is in class " + String.valueOf(iface.name()));
            }
            String name = callMethod.name();
            AnnotationValue moduleValue = clientDefinition.value("module");
            String module = moduleValue == null || moduleValue.asString().isEmpty() ? moduleNameBuildItem.getModuleName() : moduleValue.asString();
            AnnotationValue dbNameValue = clientDefinition.value("dbName");
            String dbName = dbNameValue == null ? "" : dbNameValue.asString();
            AnnotationValue rawSQLValue = clientDefinition.value("rawSQL");
            String rawSQL = rawSQLValue == null ? "" : rawSQLValue.asString();
            AnnotationValue commandValue = clientDefinition.value("command");
            String command = commandValue == null ? "" : commandValue.asString();
            AnnotationValue fieldsValue = clientDefinition.value("fields");
            String[] fields = fieldsValue == null ? new String[]{} : fieldsValue.asStringArray();
            AnnotationValue colToFieldNameValue = clientDefinition.value("colToFieldName");
            String[] colToFieldName = colToFieldNameValue == null ? new String[]{} : colToFieldNameValue.asStringArray();
            Object classOutput = launchModeBuildItem.isTest() ? new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer) : new GeneratedClassGizmoAdaptor(generatedClients, true);
            Type returnType = callMethod.returnType();
            String actualReturnType = returnType.name().toString();
            if (returnType.name().toString().startsWith("java.util.List") && returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                actualReturnType = ((Type)returnType.asParameterizedType().arguments().get(0)).name().toString();
            }
            String className = iface.name().toString() + "_fit_sqlqueryclient";
            Type paramType = callMethod.parametersCount() > 0 ? callMethod.parameterType(0) : null;
            try (ClassCreator cc = new ClassCreator((ClassOutput)classOutput, className, null, Object.class.getName(), new String[]{iface.name().toString()});){
                if (launchModeBuildItem.isTest()) {
                    cc.addAnnotation(TEST_ANNOTATION);
                    cc.addAnnotation(Singleton.class);
                }
                switch (VerbType.of(callMethod)) {
                    case VERB: {
                        ResultHandle helper;
                        MethodCreator publish;
                        LinkedHashSet<Map.Entry<String, String>> signatures = new LinkedHashSet<Map.Entry<String, String>>();
                        signatures.add(Map.entry(returnType.name().toString(), paramType.name().toString()));
                        signatures.add(Map.entry(Object.class.getName(), Object.class.getName()));
                        for (Map.Entry entry : signatures) {
                            publish = cc.getMethodCreator(name, (String)entry.getKey(), new String[]{(String)entry.getValue()});
                            helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle fieldsArray = publish.newArray(String.class, fields.length);
                            for (int i = 0; i < fields.length; ++i) {
                                publish.writeArrayValue(fieldsArray, i, publish.load(fields[i]));
                            }
                            ResultHandle colToFieldNameArray = publish.newArray(String.class, colToFieldName.length);
                            for (int i = 0; i < colToFieldName.length; ++i) {
                                publish.writeArrayValue(colToFieldNameArray, i, publish.load(colToFieldName[i]));
                            }
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.getMethodParam(0), publish.load(dbName), publish.load(command), publish.load(rawSQL), fieldsArray, colToFieldNameArray, publish.loadClass(actualReturnType)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case SINK: {
                        LinkedHashSet<String> sinkSignatures = new LinkedHashSet<String>();
                        sinkSignatures.add(paramType.name().toString());
                        sinkSignatures.add(Object.class.getName());
                        for (Object sig2 : sinkSignatures) {
                            MethodCreator publish = cc.getMethodCreator(name, Void.TYPE, new Object[]{sig2});
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle fieldsArray = publish.newArray(String.class, fields.length);
                            for (int i = 0; i < fields.length; ++i) {
                                publish.writeArrayValue(fieldsArray, i, publish.load(fields[i]));
                            }
                            publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.getMethodParam(0), publish.load(dbName), publish.load(command), publish.load(rawSQL), fieldsArray, publish.newArray(String.class, 0), publish.loadClass(Void.class)});
                            publish.returnVoid();
                        }
                        break;
                    }
                    case SOURCE: {
                        Object sig2;
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        linkedHashSet.add(returnType.name().toString());
                        linkedHashSet.add(Object.class.getName());
                        sig2 = linkedHashSet.iterator();
                        while (sig2.hasNext()) {
                            String sig = (String)sig2.next();
                            MethodCreator publish = cc.getMethodCreator(name, sig, new String[0]);
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle colToFieldNameArray = publish.newArray(String.class, colToFieldName.length);
                            for (int i = 0; i < colToFieldName.length; ++i) {
                                publish.writeArrayValue(colToFieldNameArray, i, publish.load(colToFieldName[i]));
                            }
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.loadNull(), publish.load(dbName), publish.load(command), publish.load(rawSQL), publish.newArray(String.class, 0), colToFieldNameArray, publish.loadClass(actualReturnType)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case EMPTY: {
                        MethodCreator publish = cc.getMethodCreator(name, Void.TYPE, new Class[0]);
                        ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                        publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.loadNull(), publish.load(dbName), publish.load(command), publish.load(rawSQL), publish.newArray(String.class, 0), publish.newArray(String.class, 0), publish.loadClass(Void.class)});
                        publish.returnVoid();
                    }
                }
                clients.put(iface.name(), new SQLQueryClientBuildItem.DiscoveredClients(name, module, cc.getClassName()));
            }
        }
        return new SQLQueryClientBuildItem(clients);
    }

    @BuildStep
    public void verbsAndCron(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItem, BuildProducer<SchemaContributorBuildItem> schemaContributorBuildItemBuildProducer, List<TypeAliasBuildItem> typeAliasBuildItems) {
        String className;
        MethodInfo method;
        Collection verbAnnotations = index.getIndex().getAnnotations(FTLDotNames.VERB);
        log.debugf("Processing %d verb annotations into decls", verbAnnotations.size());
        AdditionalBeanBuildItem.Builder beans = AdditionalBeanBuildItem.builder().setUnremovable();
        for (Object verb : verbAnnotations) {
            boolean exported = verb.target().hasAnnotation(FTLDotNames.EXPORT);
            method = verb.target().asMethod();
            if (method.hasAnnotation(FTLDotNames.CRON) || method.hasAnnotation(FTLDotNames.SUBSCRIPTION)) {
                throw new RuntimeException("Method " + String.valueOf(method) + " cannot have both @Verb and @Cron or @Subscription");
            }
            className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, exported, ModuleBuilder.BodyType.ALLOWED)));
        }
        Collection cronAnnotations = index.getIndex().getAnnotations(FTLDotNames.CRON);
        log.debugf("Processing %d cron job annotations into decls", cronAnnotations.size());
        for (AnnotationInstance cron : cronAnnotations) {
            method = cron.target().asMethod();
            if (method.hasAnnotation(FTLDotNames.VERB) || method.hasAnnotation(FTLDotNames.SUBSCRIPTION)) {
                throw new RuntimeException("Method " + String.valueOf(method) + " cannot have both @Cron and @Verb or @Subscription");
            }
            className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, false, ModuleBuilder.BodyType.DISALLOWED, new ModuleBuilder.VerbCustomization().setMetadataCallback(builder -> builder.addMetadata(Metadata.newBuilder().setCronJob(MetadataCronJob.newBuilder().setCron(cron.value().asString())).build())))));
        }
        Collection sqlQueryClientDefinitions = index.getComputingIndex().getAnnotations(SQLQueryClient.class);
        for (AnnotationInstance clientDefinition : sqlQueryClientDefinitions) {
            String module;
            MethodInfo callMethod = clientDefinition.target().asMethod();
            String className2 = callMethod.declaringClass().name().toString();
            beans.addBeanClass(className2);
            Type returnType = callMethod.returnType();
            String actualReturnType = returnType.name().toString().startsWith("java.util.List") && returnType.kind() == Type.Kind.PARAMETERIZED_TYPE ? ((Type)returnType.asParameterizedType().arguments().get(0)).name().toString() : returnType.name().toString();
            AnnotationValue moduleValue = clientDefinition.value("module");
            String string = module = moduleValue == null || moduleValue.asString().isEmpty() ? null : moduleValue.asString();
            if (module == null) {
                log.debugf("No module specified for SQLQueryClient %s, skipping", (Object)className2);
                continue;
            }
            AnnotationValue dbNameValue = clientDefinition.value("dbName");
            String dbName = dbNameValue == null ? "" : dbNameValue.asString();
            AnnotationValue rawSQLValue = clientDefinition.value("rawSQL");
            String rawSQL = rawSQLValue == null ? "" : rawSQLValue.asString();
            AnnotationValue commandValue = clientDefinition.value("command");
            String command = commandValue == null ? "" : commandValue.asString();
            AnnotationValue fieldsValue = clientDefinition.value("fields");
            String[] fields = fieldsValue == null ? new String[]{} : fieldsValue.asStringArray();
            AnnotationValue colToFieldNameValue = clientDefinition.value("colToFieldName");
            String[] colToFieldName = colToFieldNameValue == null ? new String[]{} : colToFieldNameValue.asStringArray();
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerSQLQueryMethod(callMethod, className2, actualReturnType, dbName, command, rawSQL, fields, colToFieldName)));
        }
        additionalBeanBuildItem.produce((BuildItem)beans.build());
    }
}

