/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;
import xyz.block.ftl.deployment.PackageOutput;
import xyz.block.ftl.hotreload.CodeGenNotification;
import xyz.block.ftl.schema.v1.Data;
import xyz.block.ftl.schema.v1.Decl;
import xyz.block.ftl.schema.v1.Enum;
import xyz.block.ftl.schema.v1.EnumVariant;
import xyz.block.ftl.schema.v1.Field;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataDatabases;
import xyz.block.ftl.schema.v1.MetadataSQLColumn;
import xyz.block.ftl.schema.v1.MetadataSQLQuery;
import xyz.block.ftl.schema.v1.Module;
import xyz.block.ftl.schema.v1.Ref;
import xyz.block.ftl.schema.v1.Topic;
import xyz.block.ftl.schema.v1.Type;
import xyz.block.ftl.schema.v1.TypeAlias;
import xyz.block.ftl.schema.v1.Verb;

public abstract class JVMCodeGenerator
implements CodeGenProvider {
    public static final String PACKAGE_PREFIX = "ftl.";
    public static final String TYPE_MAPPER = "TypeAliasMapper";
    private static final Logger log = Logger.getLogger(JVMCodeGenerator.class);

    public String providerId() {
        return "ftl-clients";
    }

    public String inputDirectory() {
        return "ftl-module-schema";
    }

    public String[] inputExtensions() {
        return new String[]{"pb"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trigger(CodeGenContext context) throws CodeGenException {
        ArrayList<Path> schemaFiles = new ArrayList<Path>();
        log.debug((Object)"Generating JVM clients, data, enums from schema");
        Path generatedDir = context.inputDir().resolve("generated");
        if (!Files.isDirectory(context.inputDir(), new LinkOption[0])) {
            return false;
        }
        try {
            ArrayList<Module> modules = new ArrayList<Module>();
            HashMap<DeclRef, Type> typeAliasMap = new HashMap<DeclRef, Type>();
            HashMap<DeclRef, String> nativeTypeAliasMap = new HashMap<DeclRef, String>();
            HashMap<DeclRef, List<EnumInfo>> enumVariantInfoMap = new HashMap<DeclRef, List<EnumInfo>>();
            HashMap<String, PackageOutput> packageOutputMap = new HashMap<String, PackageOutput>();
            try (Stream<Path> pathStream = Files.list(context.inputDir());){
                for (Path file : pathStream.toList()) {
                    Module module;
                    String fileName = file.getFileName().toString();
                    if (!fileName.endsWith(".pb")) continue;
                    schemaFiles.add(file);
                    try {
                        module = Module.parseFrom((byte[])Files.readAllBytes(file));
                    }
                    catch (Exception e) {
                        throw new CodeGenException("Failed to parse " + String.valueOf(file), (Throwable)e);
                    }
                    String packageName = PACKAGE_PREFIX + module.getName();
                    PackageOutput output = packageOutputMap.computeIfAbsent(module.getName(), k -> new PackageOutput(context.outDir(), packageName));
                    for (Decl decl : module.getDeclsList()) {
                        if (!decl.hasTypeAlias()) continue;
                        TypeAlias data = decl.getTypeAlias();
                        boolean handled = false;
                        for (Metadata md : data.getMetadataList()) {
                            String runtime;
                            if (!md.hasTypeMap() || !(runtime = md.getTypeMap().getRuntime()).equals("kotlin") && !runtime.equals("java")) continue;
                            String nativeName = md.getTypeMap().getNativeName();
                            URL existing = this.getClass().getClassLoader().getResource(nativeName.replace(".", "/") + ".class");
                            if (existing == null) continue;
                            nativeTypeAliasMap.put(new DeclRef(module.getName(), data.getName()), nativeName);
                            this.generateTypeAliasMapper(module.getName(), data, packageName, Optional.of(nativeName), output);
                            handled = true;
                            break;
                        }
                        if (handled) continue;
                        this.generateTypeAliasMapper(module.getName(), data, packageName, Optional.empty(), output);
                        typeAliasMap.put(new DeclRef(module.getName(), data.getName()), data.getType());
                    }
                    modules.add(module);
                }
            }
            catch (IOException e) {
                throw new CodeGenException((Throwable)e);
            }
            try {
                for (Module module : modules) {
                    String packageName = PACKAGE_PREFIX + module.getName();
                    PackageOutput output = packageOutputMap.computeIfAbsent(module.getName(), k -> new PackageOutput(context.outDir(), packageName));
                    for (Decl decl : module.getDeclsList()) {
                        Data data;
                        if (decl.hasVerb()) {
                            Verb verb = decl.getVerb();
                            if (!verb.getExport()) continue;
                            log.debugf("Generating verb %s", (Object)verb.getName());
                            this.generateVerb(module, verb, packageName, typeAliasMap, nativeTypeAliasMap, output);
                            continue;
                        }
                        if (decl.hasData()) {
                            data = decl.getData();
                            if (!data.getExport()) continue;
                            log.debugf("Generating data %s", (Object)data.getName());
                            this.generateDataObject(module, data, packageName, typeAliasMap, nativeTypeAliasMap, enumVariantInfoMap, output);
                            continue;
                        }
                        if (decl.hasEnum()) {
                            data = decl.getEnum();
                            if (!data.getExport()) continue;
                            log.debugf("Generating enum %s", (Object)data.getName());
                            this.generateEnum(module, (Enum)data, packageName, typeAliasMap, nativeTypeAliasMap, enumVariantInfoMap, output);
                            continue;
                        }
                        if (!decl.hasTopic() || !(data = decl.getTopic()).getExport()) continue;
                        log.debugf("Generating topic %s", (Object)data.getName());
                        this.generateTopicConsumer(module, (Topic)data, packageName, typeAliasMap, nativeTypeAliasMap, output);
                    }
                }
                schemaFiles.addAll(this.writeGeneratedClients(context, packageOutputMap, generatedDir));
            }
            catch (Exception e) {
                throw new CodeGenException((Throwable)e);
            }
            for (Map.Entry e : packageOutputMap.entrySet()) {
                ((PackageOutput)e.getValue()).close();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            CodeGenNotification.updateLastModified(List.of(generatedDir, context.inputDir()), schemaFiles);
        }
    }

    protected abstract void generateTypeAliasMapper(String var1, TypeAlias var2, String var3, Optional<String> var4, PackageOutput var5) throws IOException;

    protected abstract void generateTopicConsumer(Module var1, Topic var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, PackageOutput var6) throws IOException;

    protected abstract void generateEnum(Module var1, Enum var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, Map<DeclRef, List<EnumInfo>> var6, PackageOutput var7) throws IOException;

    protected abstract void generateDataObject(Module var1, Data var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, Map<DeclRef, List<EnumInfo>> var6, PackageOutput var7) throws IOException;

    protected abstract void generateVerb(Module var1, Verb var2, String var3, Map<DeclRef, Type> var4, Map<DeclRef, String> var5, PackageOutput var6) throws IOException;

    protected abstract void generateSQLQueryVerb(Module var1, Verb var2, String var3, MetadataSQLQuery var4, String var5, PackageOutput var6) throws IOException;

    private List<Path> writeGeneratedClients(CodeGenContext context, Map<String, PackageOutput> packageOutputMap, Path generatedDir) throws CodeGenException {
        ArrayList<Path> schemaFiles = new ArrayList<Path>();
        if (!Files.exists(generatedDir, new LinkOption[0])) {
            log.info((Object)"No generated clients found");
            return List.of();
        }
        try (Stream<Path> pathStream = Files.list(generatedDir);){
            for (Path file : pathStream.toList()) {
                Module module;
                String fileName = file.getFileName().toString();
                if (!fileName.endsWith(".pb")) continue;
                try {
                    module = Module.parseFrom((byte[])Files.readAllBytes(file));
                }
                catch (Exception e) {
                    throw new CodeGenException("Failed to parse generated schema file " + String.valueOf(file), (Throwable)e);
                }
                schemaFiles.add(file);
                String packageName = PACKAGE_PREFIX + module.getName();
                PackageOutput output = packageOutputMap.computeIfAbsent(module.getName(), k -> new PackageOutput(context.outDir(), packageName));
                for (Decl decl : module.getDeclsList()) {
                    if (decl.hasVerb()) {
                        List dbCalls;
                        Verb verb = decl.getVerb();
                        MetadataSQLQuery queryMetadata = verb.getMetadataList().stream().filter(md -> md.hasSqlQuery()).findFirst().map(md -> md.getSqlQuery()).orElse(null);
                        MetadataDatabases dbCallMetadata = verb.getMetadataList().stream().filter(md -> md.hasDatabases()).findFirst().map(md -> md.getDatabases()).orElse(null);
                        List list = dbCalls = dbCallMetadata != null ? dbCallMetadata.getCallsList() : null;
                        if (queryMetadata == null) continue;
                        if (dbCalls == null) {
                            throw new CodeGenException("SQL query verb " + verb.getName() + " has no database calls");
                        }
                        if (dbCalls.size() != 1) {
                            throw new CodeGenException("SQL query verb " + verb.getName() + " has " + dbCalls.size() + " database calls, but must have exactly one");
                        }
                        String dbName = ((Ref)dbCalls.get(0)).getName();
                        this.generateSQLQueryVerb(module, verb, dbName, queryMetadata, packageName, output);
                        continue;
                    }
                    if (!decl.hasData()) continue;
                    Data data = decl.getData();
                    this.generateDataObject(module, data, packageName, new HashMap<DeclRef, Type>(), new HashMap<DeclRef, String>(), new HashMap<DeclRef, List<EnumInfo>>(), output);
                }
            }
        }
        catch (IOException e) {
            throw new CodeGenException((Throwable)e);
        }
        return schemaFiles;
    }

    protected List<SQLColumnField> getOrderedSQLFields(Module module, Type type) {
        if (type.hasArray()) {
            return this.getOrderedSQLFields(module, type.getArray().getElement());
        }
        if (type.hasMap()) {
            return this.getOrderedSQLFields(module, type.getMap().getValue());
        }
        if (type.hasOptional()) {
            return this.getOrderedSQLFields(module, type.getOptional().getType());
        }
        Ref ref = type.getRef();
        if (ref == null) {
            return List.of();
        }
        Data data = this.resolveDataDecl(module, ref);
        if (data == null) {
            return List.of();
        }
        ArrayList<SQLColumnField> fields = new ArrayList<SQLColumnField>();
        for (Field field : data.getFieldsList()) {
            MetadataSQLColumn fieldMd = field.getMetadataList().stream().findFirst().map(md -> md.getSqlColumn()).orElse(null);
            if (fieldMd == null) continue;
            fields.add(new SQLColumnField(field.getName(), fieldMd));
        }
        return fields;
    }

    private Data resolveDataDecl(Module module, Ref ref) {
        if (ref == null) {
            return null;
        }
        return module.getDeclsList().stream().filter(d -> d.hasData() && d.getData().getName().equals(ref.getName())).findFirst().map(d -> d.getData()).orElse(null);
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        return true;
    }

    protected static String className(String in) {
        return Character.toUpperCase(in.charAt(0)) + in.substring(1);
    }

    public record DeclRef(String module, String name) {
    }

    public record SQLColumnField(String name, MetadataSQLColumn metadata) {
    }

    public record EnumInfo(String interfaceType, EnumVariant variant, List<EnumVariant> otherVariants) {
    }
}

