/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import org.jboss.logging.Logger;
import xyz.block.ftl.deployment.ModuleNameBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.schema.v1.Database;
import xyz.block.ftl.schema.v1.Decl;
import xyz.block.ftl.schema.v1.Module;
import xyz.block.ftl.v1.GetDeploymentContextResponse;

public class GeneratedSchemaProcessor {
    private static final Logger log = Logger.getLogger(GeneratedSchemaProcessor.class);
    private static final String SCHEMA_DIR = "ftl-module-schema";
    private static final String GENERATED_DIR = "generated";

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public SchemaContributorBuildItem contributeGeneratedSchema(BuildProducer<SystemPropertyBuildItem> systemPropProducer, ModuleNameBuildItem moduleNameBuildItem, OutputTargetBuildItem outputTargetBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResourceBuildItemBuildProducer, FTLRecorder recorder) {
        String moduleName = moduleNameBuildItem.getModuleName();
        Path projectDir = outputTargetBuildItem.getOutputDirectory().getParent();
        Path sourceDir = projectDir.resolve("src").resolve("main");
        Path schemaDir = sourceDir.resolve(SCHEMA_DIR);
        Module generatedModule = null;
        try {
            Path generatedDir = schemaDir.resolve(GENERATED_DIR);
            Path generatedSchemaPath = generatedDir.resolve(moduleName + ".pb");
            byte[] schemaBytes = Files.readAllBytes(generatedSchemaPath);
            generatedModule = Module.parseFrom((byte[])schemaBytes);
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Generated schema file not found or not valid; no generated schema elements will be added", new Object[0]);
        }
        ArrayList<String> namedDatasources = new ArrayList<String>();
        ArrayList<Decl> decls = new ArrayList<Decl>();
        if (generatedModule != null) {
            for (Decl decl : generatedModule.getDeclsList()) {
                if (decl.hasDatabase()) {
                    Database db = decl.getDatabase();
                    String dbKind = db.getType();
                    String dbName = db.getName();
                    String sanitizedName = dbName.replace("<", "").replace(">", "");
                    Decl sanitizedDecl = Decl.newBuilder().setDatabase(Database.newBuilder().setType(dbKind).setName(sanitizedName)).build();
                    if (dbName.equals("default")) {
                        systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource.credentials-provider", dbName));
                        systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource.credentials-provider-name", "ftl-datasource-credentials"));
                    } else {
                        systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource." + dbName + ".credentials-provider", dbName));
                        systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource." + dbName + ".credentials-provider-name", "ftl-datasource-credentials"));
                    }
                    if (dbKind.equals("postgres")) {
                        recorder.registerDatabase(dbName, GetDeploymentContextResponse.DbType.DB_TYPE_POSTGRES);
                    } else if (dbKind.equals("mysql")) {
                        recorder.registerDatabase(dbName, GetDeploymentContextResponse.DbType.DB_TYPE_MYSQL);
                    } else {
                        log.warnf("Unsupported database kind: %s", (Object)dbKind);
                    }
                    namedDatasources.add(dbName);
                    decls.add(sanitizedDecl);
                    continue;
                }
                if (decl.hasVerb()) {
                    decls.add(decl);
                    continue;
                }
                decls.add(decl);
            }
        }
        generatedResourceBuildItemBuildProducer.produce((BuildItem)new GeneratedResourceBuildItem("ftl-datasource-names.txt", String.join((CharSequence)"\n", namedDatasources).getBytes(StandardCharsets.UTF_8)));
        return new SchemaContributorBuildItem(decls);
    }
}

