/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DatabaseConfigSource
implements ConfigSource {
    private final Map<String, String> properties = new HashMap<String, String>();

    public DatabaseConfigSource() {
        InputStream ds = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/ftl-sql-databases.txt");
        if (ds == null) {
            return;
        }
        try (InputStream in = ds;){
            Properties p = new Properties();
            p.load(in);
            for (String name : p.stringPropertyNames()) {
                this.properties.put("quarkus.datasource." + name + ".db-kind", p.getProperty(name));
            }
            if (this.properties.size() == 1) {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass("io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder");
                    this.properties.put("quarkus.hibernate-orm.datasource", p.entrySet().iterator().next().getKey().toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load database properties", e);
        }
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public String getValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    public String getName() {
        return "FTL Database Config Source";
    }
}

