/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.JsonNode;
import io.quarkus.arc.processor.DotNames;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.VoidType;
import org.jboss.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.block.ftl.Config;
import xyz.block.ftl.Egress;
import xyz.block.ftl.LeaseClient;
import xyz.block.ftl.Secret;
import xyz.block.ftl.WorkloadIdentity;
import xyz.block.ftl.deployment.CommentsBuildItem;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.Nullability;
import xyz.block.ftl.deployment.PositionUtils;
import xyz.block.ftl.deployment.SQLQueryClientBuildItem;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.deployment.VerbInfo;
import xyz.block.ftl.deployment.VerbType;
import xyz.block.ftl.deployment.VerbUtil;
import xyz.block.ftl.deployment.VisibilityUtil;
import xyz.block.ftl.language.v1.Error;
import xyz.block.ftl.language.v1.ErrorList;
import xyz.block.ftl.language.v1.Position;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.builtin.HttpRequest;
import xyz.block.ftl.runtime.builtin.HttpResponse;
import xyz.block.ftl.schema.v1.AliasKind;
import xyz.block.ftl.schema.v1.Any;
import xyz.block.ftl.schema.v1.Array;
import xyz.block.ftl.schema.v1.Bool;
import xyz.block.ftl.schema.v1.Bytes;
import xyz.block.ftl.schema.v1.Config;
import xyz.block.ftl.schema.v1.Data;
import xyz.block.ftl.schema.v1.Decl;
import xyz.block.ftl.schema.v1.Enum;
import xyz.block.ftl.schema.v1.EnumVariant;
import xyz.block.ftl.schema.v1.Field;
import xyz.block.ftl.schema.v1.Int;
import xyz.block.ftl.schema.v1.Map;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataAlias;
import xyz.block.ftl.schema.v1.MetadataCalls;
import xyz.block.ftl.schema.v1.MetadataConfig;
import xyz.block.ftl.schema.v1.MetadataEgress;
import xyz.block.ftl.schema.v1.MetadataPublisher;
import xyz.block.ftl.schema.v1.MetadataSecrets;
import xyz.block.ftl.schema.v1.MetadataTransaction;
import xyz.block.ftl.schema.v1.MetadataTypeMap;
import xyz.block.ftl.schema.v1.Module;
import xyz.block.ftl.schema.v1.Optional;
import xyz.block.ftl.schema.v1.Ref;
import xyz.block.ftl.schema.v1.Secret;
import xyz.block.ftl.schema.v1.String;
import xyz.block.ftl.schema.v1.Time;
import xyz.block.ftl.schema.v1.Type;
import xyz.block.ftl.schema.v1.TypeAlias;
import xyz.block.ftl.schema.v1.Unit;
import xyz.block.ftl.schema.v1.Verb;
import xyz.block.ftl.schema.v1.Visibility;

public class ModuleBuilder {
    public static final java.lang.String BUILTIN = "builtin";
    public static final DotName INSTANT = DotName.createSimple(Instant.class);
    public static final DotName ZONED_DATE_TIME = DotName.createSimple(ZonedDateTime.class);
    public static final DotName NOT_NULL = DotName.createSimple(NotNull.class);
    public static final DotName NULLABLE = DotName.createSimple(Nullable.class);
    public static final DotName JSON_NODE = DotName.createSimple((java.lang.String)JsonNode.class.getName());
    public static final DotName OFFSET_DATE_TIME = DotName.createSimple((java.lang.String)OffsetDateTime.class.getName());
    private static final Pattern NAME_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private static final Logger log = Logger.getLogger(ModuleBuilder.class);
    private final IndexView index;
    private final Module.Builder protoModuleBuilder;
    private final java.util.Map<java.lang.String, Decl> decls = new HashMap<java.lang.String, Decl>();
    private final java.util.Map<java.lang.String, Ref> existingRefs = new HashMap<java.lang.String, Ref>();
    private final java.lang.String moduleName;
    private final Set<java.lang.String> knownSecrets = new HashSet<java.lang.String>();
    private final Set<java.lang.String> knownConfig = new HashSet<java.lang.String>();
    private final java.util.Map<DotName, TopicsBuildItem.DiscoveredTopic> knownTopics;
    private final java.util.Map<DotName, VerbClientBuildItem.DiscoveredClients> verbClients;
    private final java.util.Map<DotName, SQLQueryClientBuildItem.DiscoveredClients> sqlQueryClients;
    private final FTLRecorder recorder;
    private final CommentsBuildItem comments;
    private final List<ValidationFailure> validationFailures = new ArrayList<ValidationFailure>();
    private final boolean defaultToOptional;

    public ModuleBuilder(IndexView index, java.lang.String moduleName, java.util.Map<DotName, TopicsBuildItem.DiscoveredTopic> knownTopics, java.util.Map<DotName, VerbClientBuildItem.DiscoveredClients> verbClients, java.util.Map<DotName, SQLQueryClientBuildItem.DiscoveredClients> sqlQueryClients, FTLRecorder recorder, CommentsBuildItem comments, boolean defaultToOptional) {
        this.index = index;
        this.moduleName = moduleName;
        this.protoModuleBuilder = Module.newBuilder().setName(moduleName).setBuiltin(false);
        this.knownTopics = knownTopics;
        this.verbClients = verbClients;
        this.sqlQueryClients = sqlQueryClients;
        this.recorder = recorder;
        this.comments = comments;
        this.defaultToOptional = defaultToOptional;
    }

    @NotNull
    public static java.lang.String methodToName(MethodInfo method) {
        return method.name();
    }

    @NotNull
    public static java.lang.String classToName(ClassInfo clazz) {
        java.lang.String simple = clazz.simpleName();
        if (simple.contains("$")) {
            simple = simple.substring(simple.lastIndexOf("$") + 1, simple.length() - 1);
        }
        return simple.substring(0, 1).toLowerCase() + simple.substring(1);
    }

    public java.lang.String getModuleName() {
        return this.moduleName;
    }

    public static Class<?> loadClass(org.jboss.jandex.Type param) throws ClassNotFoundException {
        if (param.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return Class.forName(param.asParameterizedType().name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        if (param.kind() == Type.Kind.CLASS) {
            return Class.forName(param.name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        if (param.kind() == Type.Kind.PRIMITIVE) {
            switch (param.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case INT: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
            }
            throw new RuntimeException("Unknown primitive type " + java.lang.String.valueOf(param.asPrimitiveType().primitive()));
        }
        if (param.kind() == Type.Kind.ARRAY) {
            ArrayType array = param.asArrayType();
            if (array.componentType().kind() == Type.Kind.PRIMITIVE) {
                switch (array.componentType().asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        return boolean[].class;
                    }
                    case BYTE: {
                        return byte[].class;
                    }
                    case SHORT: {
                        return short[].class;
                    }
                    case INT: {
                        return int[].class;
                    }
                    case LONG: {
                        return long[].class;
                    }
                    case FLOAT: {
                        return float[].class;
                    }
                    case DOUBLE: {
                        return double[].class;
                    }
                    case CHAR: {
                        return char[].class;
                    }
                }
                throw new RuntimeException("Unknown primitive type " + java.lang.String.valueOf(param.asPrimitiveType().primitive()));
            }
            return ModuleBuilder.loadClass(array.componentType()).arrayType();
        }
        throw new RuntimeException("Unknown type " + java.lang.String.valueOf(param.kind()));
    }

    public void registerVerbMethod(MethodInfo method, java.lang.String className, Visibility visibility, boolean transaction, BodyType bodyType) {
        this.registerVerbMethod(method, className, visibility, transaction, bodyType, new VerbCustomization());
    }

    public void registerVerbMethod(MethodInfo method, java.lang.String className, Visibility visibility, boolean transaction, BodyType bodyType, VerbCustomization customization) {
        xyz.block.ftl.schema.v1.Position methodPos = PositionUtils.forMethod(method);
        try {
            ArrayList parameterTypes = new ArrayList();
            ArrayList<Object> paramMappers = new ArrayList<Object>();
            VoidType bodyParamType = null;
            Nullability bodyParamNullability = Nullability.MISSING;
            Verb.Builder verbBuilder = Verb.newBuilder();
            java.lang.String verbName = this.validateName(method, ModuleBuilder.methodToName(method));
            MetadataCalls.Builder callsMetadata = MetadataCalls.newBuilder();
            MetadataConfig.Builder configMetadata = MetadataConfig.newBuilder();
            MetadataEgress.Builder configEgress = MetadataEgress.newBuilder();
            MetadataSecrets.Builder secretMetadata = MetadataSecrets.newBuilder();
            MetadataPublisher.Builder publisherMetadata = MetadataPublisher.newBuilder();
            int pos = -1;
            for (MethodParameterInfo param : method.parameters()) {
                Record client;
                Class<?> paramType;
                java.lang.String name;
                Class<?> paramType2;
                if (customization.ignoreParameter.apply(++pos).booleanValue()) continue;
                if (param.hasAnnotation(Secret.class)) {
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    name = param.annotation(Secret.class).value().asString();
                    paramMappers.add(new VerbRegistry.SecretSupplier(name, paramType2));
                    if (!this.knownSecrets.contains(name)) {
                        Secret.Builder secretBuilder = xyz.block.ftl.schema.v1.Secret.newBuilder().setPos(methodPos).setType(this.buildType(param.type(), Visibility.VISIBILITY_SCOPE_NONE, (AnnotationTarget)param)).setName(name).addAllComments(this.comments.getComments(name));
                        this.addDecls(Decl.newBuilder().setSecret(secretBuilder).build());
                        this.knownSecrets.add(name);
                    }
                    secretMetadata.addSecrets(Ref.newBuilder().setName(name).setModule(this.moduleName).build());
                    continue;
                }
                if (param.hasAnnotation(Config.class)) {
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    name = param.annotation(Config.class).value().asString();
                    paramMappers.add(new VerbRegistry.ConfigSupplier(name, paramType2));
                    if (!this.knownConfig.contains(name)) {
                        Config.Builder configBuilder = xyz.block.ftl.schema.v1.Config.newBuilder().setPos(methodPos).setType(this.buildType(param.type(), Visibility.VISIBILITY_SCOPE_NONE, (AnnotationTarget)param)).setName(name).addAllComments(this.comments.getComments(name));
                        this.addDecls(Decl.newBuilder().setConfig(configBuilder).build());
                        this.knownConfig.add(name);
                    }
                    configMetadata.addConfig(Ref.newBuilder().setName(name).setModule(this.moduleName).build());
                    continue;
                }
                if (param.hasAnnotation(Egress.class)) {
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    java.lang.String target = param.annotation(Egress.class).value().asString();
                    paramMappers.add(new VerbRegistry.EgressSupplier(target, paramType2));
                    configEgress.addTargets(target);
                    for (java.lang.String config : this.extractVars(target)) {
                        if (this.knownConfig.contains(config)) continue;
                        Config.Builder configBuilder = xyz.block.ftl.schema.v1.Config.newBuilder().setType(this.buildType(param.type(), Visibility.VISIBILITY_SCOPE_NONE, (AnnotationTarget)param)).setName(config);
                        this.addDecls(Decl.newBuilder().setConfig(configBuilder).build());
                        this.knownConfig.add(config);
                    }
                    continue;
                }
                if (this.knownTopics.containsKey(param.type().name())) {
                    TopicsBuildItem.DiscoveredTopic topic = this.knownTopics.get(param.type().name());
                    paramType = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType);
                    paramMappers.add(this.recorder.topicSupplier(topic.generatedProducer(), verbName));
                    publisherMetadata.addTopics(Ref.newBuilder().setPos(methodPos).setName(topic.topicName()).setModule(this.moduleName).build());
                    continue;
                }
                if (this.verbClients.containsKey(param.type().name())) {
                    client = this.verbClients.get(param.type().name());
                    paramType = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType);
                    paramMappers.add(this.recorder.verbClientSupplier(((VerbClientBuildItem.DiscoveredClients)client).generatedClient()));
                    callsMetadata.addCalls(Ref.newBuilder().setPos(methodPos).setName(((VerbClientBuildItem.DiscoveredClients)client).name()).setModule(((VerbClientBuildItem.DiscoveredClients)client).module()).build());
                    continue;
                }
                if (this.sqlQueryClients.containsKey(param.type().name())) {
                    client = this.sqlQueryClients.get(param.type().name());
                    paramType = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType);
                    paramMappers.add(this.recorder.verbClientSupplier(((SQLQueryClientBuildItem.DiscoveredClients)client).generatedClient()));
                    callsMetadata.addCalls(Ref.newBuilder().setPos(methodPos).setName(((SQLQueryClientBuildItem.DiscoveredClients)client).name()).setModule(((SQLQueryClientBuildItem.DiscoveredClients)client).module()).build());
                    continue;
                }
                if (FTLDotNames.LEASE_CLIENT.equals((Object)param.type().name())) {
                    parameterTypes.add(LeaseClient.class);
                    paramMappers.add(this.recorder.leaseClientSupplier());
                    continue;
                }
                if (FTLDotNames.WORKLOAD_IDENTITY.equals((Object)param.type().name())) {
                    parameterTypes.add(WorkloadIdentity.class);
                    paramMappers.add(this.recorder.workloadIdentitySupplier());
                    continue;
                }
                if (bodyType != BodyType.DISALLOWED && bodyParamType == null) {
                    bodyParamType = param.type();
                    bodyParamNullability = ModuleBuilder.nullability((AnnotationTarget)param);
                    paramType2 = ModuleBuilder.loadClass(param.type());
                    parameterTypes.add(paramType2);
                    paramMappers.add(new VerbRegistry.BodySupplier(pos));
                    continue;
                }
                this.validationFailures.add(new ValidationFailure(PositionUtils.toError(methodPos), "Invalid parameter " + param.name() + " in verb " + verbName));
                return;
            }
            if (bodyParamType == null) {
                if (bodyType == BodyType.REQUIRED) {
                    this.validationFailures.add(new ValidationFailure(PositionUtils.toError(methodPos), "Missing required payload parameter"));
                    return;
                }
                bodyParamType = VoidType.VOID;
            }
            if (callsMetadata.getCallsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setCalls(callsMetadata));
            }
            if (secretMetadata.getSecretsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setSecrets(secretMetadata));
            }
            if (configMetadata.getConfigCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setConfig(configMetadata));
            }
            if (publisherMetadata.getTopicsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setPublisher(publisherMetadata));
            }
            if (configEgress.getTargetsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setEgress(configEgress));
            }
            if (transaction) {
                verbBuilder.addMetadata(Metadata.newBuilder().setTransaction(MetadataTransaction.newBuilder().build()));
            }
            if (!customization.customHandling) {
                this.recorder.registerVerb(this.moduleName, verbName, method.name(), parameterTypes, Class.forName(className, false, Thread.currentThread().getContextClassLoader()), paramMappers, method.returnType() == VoidType.VOID, transaction);
            }
            verbBuilder.setName(verbName).setVisibility(visibility).setPos(methodPos).setRequest(customization.requestType.apply(this.buildType((org.jboss.jandex.Type)bodyParamType, visibility, bodyParamNullability))).setResponse(customization.responseType.apply(this.buildType(method.returnType(), visibility, (AnnotationTarget)method))).addAllComments(this.comments.getComments(verbName));
            if (customization.metadataCallback != null) {
                customization.metadataCallback.accept(verbBuilder);
            }
            this.addDecls(Decl.newBuilder().setVerb(verbBuilder).build());
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to process FTL method %s.%s", (Object)method.declaringClass().name(), (Object)method.name());
            this.validationFailures.add(new ValidationFailure(PositionUtils.toError(methodPos), "Failed to process FTL method " + java.lang.String.valueOf(method.declaringClass().name()) + "." + method.name() + " " + e.getMessage()));
        }
    }

    public void registerVerbType(ClassInfo clazz, Visibility visibility, boolean transaction, BodyType bodyType) {
        this.registerVerbType(clazz, visibility, transaction, bodyType, new VerbCustomization());
    }

    public void registerVerbType(ClassInfo clazz, Visibility visibility, boolean transaction, BodyType bodyType, VerbCustomization customization) {
        ArrayList bodyParameterTypes = new ArrayList();
        ArrayList constructorParameterTypes = new ArrayList();
        ArrayList<VerbRegistry.BodySupplier> bodySuppliers = new ArrayList<VerbRegistry.BodySupplier>();
        ArrayList<Object> constructorSuppliers = new ArrayList<Object>();
        try {
            Object method = null;
            MethodInfo constructor = null;
            VerbInfo result = VerbUtil.getVerbInfo(this.index, clazz);
            if (result == null) {
                this.validationFailures.add(new ValidationFailure(Position.newBuilder().build(), "Verb Class must extend FunctionVerb, SinkVerb, SourceVerb or EmptyVerb: " + java.lang.String.valueOf(clazz.name())));
                return;
            }
            if (result.type() == VerbType.SINK || result.type() == VerbType.VERB) {
                bodySuppliers.add(new VerbRegistry.BodySupplier(0));
                bodyParameterTypes.add(ModuleBuilder.loadClass(result.bodyParamType()));
            }
            HashSet<MethodInfo> constructors = new HashSet<MethodInfo>();
            for (MethodInfo methodInfo : clazz.methods()) {
                if (!methodInfo.name().equals("<init>")) continue;
                if (methodInfo.hasAnnotation(DotNames.INJECT)) {
                    constructor = methodInfo;
                    break;
                }
                constructors.add(methodInfo);
            }
            if (constructor == null) {
                if (constructors.size() == 1) {
                    constructor = (MethodInfo)constructors.iterator().next();
                } else if (constructors.size() > 1) {
                    this.validationFailures.add(new ValidationFailure(Position.newBuilder().build(), "Could not determine constructor for " + java.lang.String.valueOf(clazz.name()) + " use @Inject to annotate the appropriate constructor"));
                    return;
                }
            }
            xyz.block.ftl.schema.v1.Position methodPos = PositionUtils.forMethod(result.method());
            Verb.Builder verbBuilder = Verb.newBuilder();
            java.lang.String verbName = this.validateName(result.method(), ModuleBuilder.classToName(clazz));
            MetadataCalls.Builder callsMetadata = MetadataCalls.newBuilder();
            MetadataConfig.Builder configMetadata = MetadataConfig.newBuilder();
            MetadataSecrets.Builder secretMetadata = MetadataSecrets.newBuilder();
            MetadataPublisher.Builder publisherMetadata = MetadataPublisher.newBuilder();
            int pos = -1;
            if (constructor != null) {
                for (MethodParameterInfo param : constructor.parameters()) {
                    Record client;
                    java.lang.String name;
                    if (customization.ignoreParameter.apply(++pos).booleanValue()) continue;
                    Class<?> paramType = ModuleBuilder.loadClass(param.type());
                    constructorParameterTypes.add(paramType);
                    if (param.hasAnnotation(Secret.class)) {
                        name = param.annotation(Secret.class).value().asString();
                        constructorSuppliers.add(new VerbRegistry.SecretSupplier(name, paramType));
                        if (!this.knownSecrets.contains(name)) {
                            Secret.Builder secretBuilder = xyz.block.ftl.schema.v1.Secret.newBuilder().setPos(methodPos).setType(this.buildType(param.type(), Visibility.VISIBILITY_SCOPE_NONE, (AnnotationTarget)param)).setName(name).addAllComments(this.comments.getComments(name));
                            this.addDecls(Decl.newBuilder().setSecret(secretBuilder).build());
                            this.knownSecrets.add(name);
                        }
                        secretMetadata.addSecrets(Ref.newBuilder().setName(name).setModule(this.moduleName).build());
                        continue;
                    }
                    if (param.hasAnnotation(Config.class)) {
                        name = param.annotation(Config.class).value().asString();
                        constructorSuppliers.add(new VerbRegistry.ConfigSupplier(name, paramType));
                        if (!this.knownConfig.contains(name)) {
                            Config.Builder configBuilder = xyz.block.ftl.schema.v1.Config.newBuilder().setPos(methodPos).setType(this.buildType(param.type(), Visibility.VISIBILITY_SCOPE_NONE, (AnnotationTarget)param)).setName(name).addAllComments(this.comments.getComments(name));
                            this.addDecls(Decl.newBuilder().setConfig(configBuilder).build());
                            this.knownConfig.add(name);
                        }
                        configMetadata.addConfig(Ref.newBuilder().setName(name).setModule(this.moduleName).build());
                        continue;
                    }
                    if (this.knownTopics.containsKey(param.type().name())) {
                        TopicsBuildItem.DiscoveredTopic topic = this.knownTopics.get(param.type().name());
                        constructorSuppliers.add(this.recorder.topicSupplier(topic.generatedProducer(), verbName));
                        publisherMetadata.addTopics(Ref.newBuilder().setPos(methodPos).setName(topic.topicName()).setModule(this.moduleName).build());
                        continue;
                    }
                    if (this.verbClients.containsKey(param.type().name())) {
                        client = this.verbClients.get(param.type().name());
                        constructorSuppliers.add(this.recorder.verbClientSupplier(((VerbClientBuildItem.DiscoveredClients)client).generatedClient()));
                        callsMetadata.addCalls(Ref.newBuilder().setPos(methodPos).setName(((VerbClientBuildItem.DiscoveredClients)client).name()).setModule(((VerbClientBuildItem.DiscoveredClients)client).module()).build());
                        continue;
                    }
                    if (this.sqlQueryClients.containsKey(param.type().name())) {
                        client = this.sqlQueryClients.get(param.type().name());
                        constructorSuppliers.add(this.recorder.verbClientSupplier(((SQLQueryClientBuildItem.DiscoveredClients)client).generatedClient()));
                        callsMetadata.addCalls(Ref.newBuilder().setPos(methodPos).setName(((SQLQueryClientBuildItem.DiscoveredClients)client).name()).setModule(((SQLQueryClientBuildItem.DiscoveredClients)client).module()).build());
                        continue;
                    }
                    if (FTLDotNames.LEASE_CLIENT.equals((Object)param.type().name())) {
                        constructorSuppliers.add(this.recorder.leaseClientSupplier());
                        continue;
                    }
                    if (FTLDotNames.WORKLOAD_IDENTITY.equals((Object)param.type().name())) {
                        constructorSuppliers.add(this.recorder.workloadIdentitySupplier());
                        continue;
                    }
                    this.validationFailures.add(new ValidationFailure(PositionUtils.toError(methodPos), "Invalid parameter " + param.name() + " in verb constructor " + verbName));
                    return;
                }
            }
            if (callsMetadata.getCallsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setCalls(callsMetadata));
            }
            if (secretMetadata.getSecretsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setSecrets(secretMetadata));
            }
            if (configMetadata.getConfigCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setConfig(configMetadata));
            }
            if (publisherMetadata.getTopicsCount() > 0) {
                verbBuilder.addMetadata(Metadata.newBuilder().setPublisher(publisherMetadata));
            }
            if (transaction) {
                verbBuilder.addMetadata(Metadata.newBuilder().setTransaction(MetadataTransaction.newBuilder().build()));
            }
            this.recorder.registerTypeVerb(this.moduleName, verbName, result.method().name(), ModuleBuilder.loadClass((org.jboss.jandex.Type)ClassType.create((DotName)clazz.name())), bodyParameterTypes, bodySuppliers, constructorParameterTypes, constructorSuppliers, result.method().returnType() == VoidType.VOID, transaction);
            verbBuilder.setName(verbName).setVisibility(visibility).setPos(methodPos).setRequest(customization.requestType.apply(this.buildType(result.bodyParamType(), visibility, result.bodyParamNullability()))).setResponse(customization.responseType.apply(this.buildType(result.method().returnType(), visibility, (AnnotationTarget)result.method()))).addAllComments(this.comments.getComments(verbName));
            if (customization.metadataCallback != null) {
                customization.metadataCallback.accept(verbBuilder);
            }
            this.addDecls(Decl.newBuilder().setVerb(verbBuilder).build());
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to process FTL verb class %s", (Object)clazz.name());
            this.validationFailures.add(new ValidationFailure(PositionUtils.toError(PositionUtils.forClass(clazz.name().toString())), "Failed to process FTL class " + java.lang.String.valueOf(clazz.name()) + " " + e.getMessage()));
        }
    }

    private List<java.lang.String> extractVars(java.lang.String target) {
        ArrayList<java.lang.String> ret = new ArrayList<java.lang.String>();
        Pattern regex = Pattern.compile("\\$\\{(\\w+)}");
        Matcher matcher = regex.matcher(target);
        while (matcher.find()) {
            java.lang.String var = matcher.group(1);
            if (var == null || var.isEmpty()) continue;
            ret.add(var);
        }
        return ret;
    }

    public void registerTransactionDbAccess() {
        for (Decl decl : this.decls.values()) {
            Verb verb;
            if (!decl.hasVerb() || !(verb = decl.getVerb()).getMetadataList().stream().anyMatch(m -> m.hasTransaction())) continue;
            List<java.lang.String> databaseUses = this.resolveDatabaseUses(verb);
            this.recorder.registerTransactionDbAccess(this.moduleName, verb.getName(), databaseUses);
        }
    }

    private Verb resolveVerb(Ref ref) {
        for (Decl verb : this.decls.values()) {
            if (!verb.hasVerb() || !verb.getVerb().getName().equals(ref.getName())) continue;
            return verb.getVerb();
        }
        return null;
    }

    private List<java.lang.String> resolveDatabaseUses(Verb verb) {
        ArrayList<java.lang.String> refs = new ArrayList<java.lang.String>();
        HashSet<Ref> visited = new HashSet<Ref>();
        for (Metadata metadata : verb.getMetadataList()) {
            if (metadata.hasCalls()) {
                for (Ref call : metadata.getCalls().getCallsList()) {
                    Verb callee;
                    if (visited.contains(call)) continue;
                    visited.add(call);
                    if (!call.getModule().equals(this.moduleName) || call.getName().equals(verb.getName()) || (callee = this.resolveVerb(call)) == null) continue;
                    refs.addAll(this.resolveDatabaseUses(callee));
                }
            }
            if (!metadata.hasDatabases()) continue;
            refs.addAll(metadata.getDatabases().getUsesList().stream().map(Ref::getName).toList());
        }
        return refs;
    }

    public void registerSQLQueryMethod(MethodInfo method, java.lang.String className, java.lang.String returnType, java.lang.String dbName, java.lang.String command, java.lang.String rawSQL, java.lang.String[] fields, java.lang.String[] colToFieldName) {
        try {
            Class returnClass = returnType.equals("void") ? Void.class : Class.forName(returnType, false, Thread.currentThread().getContextClassLoader());
            this.recorder.registerSqlQueryVerb(this.moduleName, method.name(), Class.forName(className, false, Thread.currentThread().getContextClassLoader()), returnClass, dbName, command, rawSQL, fields, colToFieldName);
        }
        catch (ClassNotFoundException e) {
            log.errorf((Throwable)e, "Failed to process FTL method %s.%s", (Object)method.declaringClass().name(), (Object)method.name());
            this.validationFailures.add(new ValidationFailure(PositionUtils.toError(PositionUtils.forMethod(method)), "Failed to process FTL method " + java.lang.String.valueOf(method.declaringClass().name()) + "." + method.name() + " " + e.getMessage()));
        }
    }

    public static Nullability nullability(AnnotationTarget type) {
        if (type.hasDeclaredAnnotation(NULLABLE)) {
            return Nullability.NULLABLE;
        }
        if (type.hasDeclaredAnnotation(NOT_NULL)) {
            return Nullability.NOT_NULL;
        }
        return Nullability.MISSING;
    }

    private Type handleNullabilityAnnotations(Type res, Nullability nullability) {
        if (nullability == Nullability.NOT_NULL) {
            return res;
        }
        if (nullability == Nullability.NULLABLE || this.defaultToOptional) {
            return Type.newBuilder().setOptional(Optional.newBuilder().setType(res)).build();
        }
        return res;
    }

    public Type buildType(org.jboss.jandex.Type type, Visibility visibility, AnnotationTarget target) {
        return this.buildType(type, visibility, ModuleBuilder.nullability(target));
    }

    public Type buildType(org.jboss.jandex.Type type, Visibility visibility, Nullability nullability) {
        switch (type.kind()) {
            case PRIMITIVE: {
                PrimitiveType prim = type.asPrimitiveType();
                switch (prim.primitive()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        return Type.newBuilder().setInt(Int.newBuilder().build()).build();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return Type.newBuilder().setFloat(xyz.block.ftl.schema.v1.Float.newBuilder().build()).build();
                    }
                    case BOOLEAN: {
                        return Type.newBuilder().setBool(Bool.newBuilder().build()).build();
                    }
                    case CHAR: {
                        return Type.newBuilder().setString(String.newBuilder().build()).build();
                    }
                }
                throw new RuntimeException("unknown primitive type: " + java.lang.String.valueOf(prim.primitive()));
            }
            case VOID: {
                return Type.newBuilder().setUnit(Unit.newBuilder().build()).build();
            }
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                if (arrayType.componentType().kind() == Type.Kind.PRIMITIVE && arrayType.componentType().asPrimitiveType().primitive() == PrimitiveType.Primitive.BYTE) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setBytes(Bytes.newBuilder().build()).build(), nullability);
                }
                return this.handleNullabilityAnnotations(Type.newBuilder().setArray(Array.newBuilder().setElement(this.buildType(arrayType.componentType(), visibility, Nullability.NOT_NULL)).build()).build(), nullability);
            }
            case CLASS: {
                Visibility actual;
                PrimitiveType unboxed;
                ClassType clazz = type.asClassType();
                if (clazz.name().equals((Object)FTLDotNames.KOTLIN_UNIT)) {
                    return Type.newBuilder().setUnit(Unit.newBuilder().build()).build();
                }
                ClassInfo info = this.index.getClassByName(clazz.name());
                if (info != null && info.enclosingClass() != null && !Modifier.isStatic(info.flags())) {
                    this.validationFailures.add(new ValidationFailure(PositionUtils.toError(PositionUtils.forClass(clazz.name().toString())), "Inner classes must be static"));
                }
                if ((unboxed = PrimitiveType.unbox((ClassType)clazz)) != null) {
                    Type primitive = this.buildType((org.jboss.jandex.Type)unboxed, visibility, Nullability.NOT_NULL);
                    if (nullability == Nullability.NOT_NULL) {
                        return primitive;
                    }
                    return Type.newBuilder().setOptional(Optional.newBuilder().setType(primitive)).build();
                }
                if (info != null && info.hasDeclaredAnnotation(FTLDotNames.GENERATED_REF)) {
                    AnnotationInstance ref = info.declaredAnnotation(FTLDotNames.GENERATED_REF);
                    java.lang.String module = ref.value("module").asString();
                    if (Objects.equals(module, this.moduleName) && !visibility.equals((Object)VisibilityUtil.getVisibility((AnnotationTarget)info))) {
                        this.validationFailures.add(new ValidationFailure(PositionUtils.toError(PositionUtils.forClass(clazz.name().toString())), "Generated type " + java.lang.String.valueOf(clazz.name()) + " cannot be implicitly exported as part of the signature of a verb as it is a generated type, define a new type instead"));
                    }
                    return this.handleNullabilityAnnotations(Type.newBuilder().setRef(Ref.newBuilder().setName(ref.value("name").asString()).setModule(module)).build(), nullability);
                }
                if (clazz.name().equals((Object)DotName.STRING_NAME)) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setString(String.newBuilder().build()).build(), nullability);
                }
                if (clazz.name().equals((Object)DotName.OBJECT_NAME) || clazz.name().equals((Object)JSON_NODE)) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setAny(Any.newBuilder().build()).build(), nullability);
                }
                if (clazz.name().equals((Object)OFFSET_DATE_TIME) || clazz.name().equals((Object)INSTANT) || clazz.name().equals((Object)ZONED_DATE_TIME)) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setTime(Time.newBuilder().build()).build(), nullability);
                }
                java.lang.String name = clazz.name().local();
                if (this.existingRefs.containsKey(name)) {
                    Ref ref = this.existingRefs.get(name);
                    if (ref.getModule().equals(this.moduleName) && visibility != Visibility.VISIBILITY_SCOPE_NONE) {
                        this.setDeclExport(name, visibility);
                    }
                    return Type.newBuilder().setRef(ref).build();
                }
                Type ref = Type.newBuilder().setRef(Ref.newBuilder().setName(name).setModule(this.moduleName).build()).build();
                this.existingRefs.put(name, ref.getRef());
                if (info != null && (info.isEnum() || info.hasAnnotation(FTLDotNames.ENUM))) {
                    Visibility thisVis = VisibilityUtil.highest(VisibilityUtil.getVisibility((AnnotationTarget)info), visibility);
                    if (!this.setDeclExport(name, thisVis)) {
                        Enum.Builder ennum = Enum.newBuilder().setName(name).setVisibility(thisVis);
                        this.addDecls(Decl.newBuilder().setEnum(ennum.build()).build());
                    }
                    return this.handleNullabilityAnnotations(ref, nullability);
                }
                Visibility explicit = VisibilityUtil.getVisibility(clazz.annotation(FTLDotNames.EXPORT));
                if (info != null) {
                    explicit = VisibilityUtil.getVisibility((AnnotationTarget)info);
                }
                if (this.setDeclExport(name, actual = VisibilityUtil.highest(visibility, explicit))) {
                    return this.handleNullabilityAnnotations(ref, nullability);
                }
                Data.Builder data = Data.newBuilder().setPos(PositionUtils.forClass(clazz.name().toString())).setName(name).setVisibility(actual).addAllComments(this.comments.getComments(name));
                this.buildDataElement(data, clazz.name(), actual);
                this.addDecls(Decl.newBuilder().setData(data).build());
                return this.handleNullabilityAnnotations(ref, nullability);
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType paramType = type.asParameterizedType();
                if (paramType.name().equals((Object)DotName.createSimple(List.class))) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setArray(Array.newBuilder().setElement(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), visibility, Nullability.NOT_NULL))).build(), nullability);
                }
                if (paramType.name().equals((Object)DotName.createSimple(java.util.Map.class))) {
                    return this.handleNullabilityAnnotations(Type.newBuilder().setMap(Map.newBuilder().setKey(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), visibility, Nullability.NOT_NULL)).setValue(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(1), visibility, Nullability.NOT_NULL))).build(), nullability);
                }
                if (paramType.name().equals((Object)DotNames.OPTIONAL)) {
                    return Type.newBuilder().setOptional(Optional.newBuilder().setType(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), visibility, Nullability.NOT_NULL))).build();
                }
                if (paramType.name().equals((Object)DotName.createSimple(HttpRequest.class))) {
                    return Type.newBuilder().setRef(Ref.newBuilder().setModule(BUILTIN).setName(HttpRequest.class.getSimpleName()).addTypeParameters(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), visibility, Nullability.NOT_NULL))).build();
                }
                if (paramType.name().equals((Object)DotName.createSimple(HttpResponse.class))) {
                    return Type.newBuilder().setRef(Ref.newBuilder().setModule(BUILTIN).setName(HttpResponse.class.getSimpleName()).addTypeParameters(this.buildType((org.jboss.jandex.Type)paramType.arguments().get(0), visibility, Nullability.NOT_NULL)).addTypeParameters(Type.newBuilder().setUnit(Unit.newBuilder().build()))).build();
                }
                ClassInfo classByName = this.index.getClassByName(paramType.name());
                this.validateName(classByName.name().toString(), classByName.name().local());
                ClassType.Builder cb = ClassType.builder((DotName)classByName.name());
                Type main = this.buildType((org.jboss.jandex.Type)cb.build(), visibility, Nullability.NOT_NULL);
                Type.Builder builder = main.toBuilder();
                Ref.Builder refBuilder = builder.getRef().toBuilder();
                for (org.jboss.jandex.Type arg : paramType.arguments()) {
                    refBuilder.addTypeParameters(this.buildType(arg, visibility, Nullability.NOT_NULL));
                }
                builder.setRef(refBuilder);
                return this.handleNullabilityAnnotations(builder.build(), nullability);
            }
        }
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    private void buildDataElement(Data.Builder data, DotName className, Visibility visibility) {
        if (className == null || className.equals((Object)DotName.OBJECT_NAME)) {
            return;
        }
        ClassInfo clazz = this.index.getClassByName(className);
        if (clazz == null) {
            return;
        }
        for (FieldInfo field : clazz.fieldsInDeclarationOrder()) {
            AnnotationInstance aliases;
            if (Modifier.isStatic(field.flags())) continue;
            Field.Builder builder = Field.newBuilder().setName(field.name()).setType(this.buildType(field.type(), visibility, (AnnotationTarget)field));
            if (field.hasAnnotation(JsonAlias.class) && (aliases = field.annotation(JsonAlias.class)).value() != null) {
                for (java.lang.String alias : aliases.value().asStringArray()) {
                    builder.addMetadata(Metadata.newBuilder().setAlias(MetadataAlias.newBuilder().setKind(AliasKind.ALIAS_KIND_JSON).setAlias(alias)));
                }
            }
            data.addFields(builder.build());
        }
        this.buildDataElement(data, clazz.superName(), visibility);
    }

    public ModuleBuilder addDecls(Decl decl) {
        if (decl.hasData()) {
            Data data = decl.getData();
            if (!this.setDeclExport(data.getName(), data.getVisibility())) {
                this.addDecl(decl, data.getPos(), data.getName());
            }
        } else if (decl.hasEnum()) {
            Enum enuum = decl.getEnum();
            if (!this.updateEnum(enuum.getName(), decl)) {
                this.addDecl(decl, enuum.getPos(), enuum.getName());
            }
        } else if (decl.hasDatabase()) {
            this.addDecl(decl, decl.getDatabase().getPos(), decl.getDatabase().getName());
        } else if (decl.hasConfig()) {
            this.addDecl(decl, decl.getConfig().getPos(), decl.getConfig().getName());
        } else if (decl.hasSecret()) {
            this.addDecl(decl, decl.getSecret().getPos(), decl.getSecret().getName());
        } else if (decl.hasVerb()) {
            this.addDecl(decl, decl.getVerb().getPos(), decl.getVerb().getName());
        } else if (decl.hasTypeAlias()) {
            this.addDecl(decl, decl.getTypeAlias().getPos(), decl.getTypeAlias().getName());
        } else if (decl.hasTopic()) {
            this.addDecl(decl, decl.getTopic().getPos(), decl.getTopic().getName());
        }
        return this;
    }

    public int getDeclsCount() {
        return this.decls.size();
    }

    public void writeTo(OutputStream out, OutputStream errorOut, BiConsumer<Module, ErrorList> consumer) throws IOException {
        this.decls.values().stream().forEachOrdered(arg_0 -> ((Module.Builder)this.protoModuleBuilder).addDecls(arg_0));
        ErrorList.Builder builder = ErrorList.newBuilder();
        if (!this.validationFailures.isEmpty()) {
            for (ValidationFailure failure : this.validationFailures) {
                builder.addErrors(Error.newBuilder().setLevel(Error.ErrorLevel.ERROR_LEVEL_ERROR).setType(Error.ErrorType.ERROR_TYPE_FTL).setPos(failure.position).setMsg(failure.message).build());
                log.error((Object)failure.message);
            }
        }
        ErrorList errorList = builder.build();
        errorList.writeTo(errorOut);
        Module module = this.protoModuleBuilder.build();
        module.writeTo(out);
        if (consumer != null) {
            consumer.accept(module, errorList);
        }
    }

    public void registerTypeAlias(java.lang.String name, org.jboss.jandex.Type finalT, org.jboss.jandex.Type finalS, Visibility visibility, java.util.Map<java.lang.String, java.lang.String> languageMappings) {
        this.validateName(finalT.name().toString(), name);
        TypeAlias.Builder typeAlias = TypeAlias.newBuilder().setType(this.buildType(finalS, visibility, Nullability.NOT_NULL)).setName(name).addAllComments(this.comments.getComments(name)).addMetadata(Metadata.newBuilder().setTypeMap(MetadataTypeMap.newBuilder().setRuntime("java").setNativeName(finalT.toString()).build()).build());
        for (Map.Entry<java.lang.String, java.lang.String> entry : languageMappings.entrySet()) {
            typeAlias.addMetadata(Metadata.newBuilder().setTypeMap(MetadataTypeMap.newBuilder().setRuntime(entry.getKey()).setNativeName(entry.getValue()).build()).build());
        }
        this.addDecls(Decl.newBuilder().setTypeAlias(typeAlias).build());
    }

    public void registerExternalType(java.lang.String module, java.lang.String name) {
        Ref ref = Ref.newBuilder().setModule(module).setName(name).build();
        this.existingRefs.put(name, ref);
    }

    public void registerValidationFailure(xyz.block.ftl.schema.v1.Position position, java.lang.String message) {
        this.validationFailures.add(new ValidationFailure(PositionUtils.toError(position), message));
    }

    private void addDecl(Decl decl, xyz.block.ftl.schema.v1.Position pos, java.lang.String name) {
        this.validateName(pos, name);
        Decl existing = this.decls.get(name);
        if (existing != null) {
            this.duplicateNameValidationError(name, pos, existing);
        }
        this.decls.put(name, decl);
    }

    private Visibility higherVisibility(Visibility v1, Visibility v2) {
        return v1.getNumber() > v2.getNumber() ? v1 : v2;
    }

    private boolean updateEnum(java.lang.String name, Decl decl) {
        if (this.decls.containsKey(name)) {
            Decl existing = this.decls.get(name);
            if (!existing.hasEnum()) {
                this.duplicateNameValidationError(name, decl.getEnum().getPos(), existing);
            }
            Decl moreComplete = decl.getEnum().getVariantsCount() > 0 ? decl : existing;
            Decl lessComplete = decl.getEnum().getVariantsCount() > 0 ? existing : decl;
            Visibility visibility = this.higherVisibility(lessComplete.getEnum().getVisibility(), existing.getEnum().getVisibility());
            Enum merged = moreComplete.getEnum().toBuilder().setVisibility(visibility).build();
            this.decls.put(name, Decl.newBuilder().setEnum(merged).build());
            if (visibility != Visibility.VISIBILITY_SCOPE_NONE) {
                for (EnumVariant childDecl : merged.getVariantsList()) {
                    if (!childDecl.getValue().hasTypeValue() || !childDecl.getValue().getTypeValue().getValue().hasRef()) continue;
                    Ref ref = childDecl.getValue().getTypeValue().getValue().getRef();
                    this.setDeclExport(ref.getName(), visibility);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setDeclExport(java.lang.String name, Visibility visibility) {
        Decl existing;
        block5: {
            Visibility newVis;
            block6: {
                existing = this.decls.get(name);
                if (existing == null) break block5;
                if (!existing.hasData()) break block6;
                Visibility value = this.higherVisibility(visibility, existing.getData().getVisibility());
                if (value.equals((Object)existing.getData().getVisibility())) break block5;
                Data merged = existing.getData().toBuilder().setVisibility(value).build();
                this.decls.put(name, Decl.newBuilder().setData(merged).build());
                for (Field field : existing.getData().getFieldsList()) {
                    if (!field.getType().hasRef()) continue;
                    Ref ref = field.getType().getRef();
                    this.setDeclExport(ref.getName(), value);
                }
                break block5;
            }
            if (existing.hasTypeAlias()) {
                TypeAlias merged = existing.getTypeAlias().toBuilder().setVisibility(this.higherVisibility(visibility, existing.getTypeAlias().getVisibility())).build();
                this.decls.put(name, Decl.newBuilder().setTypeAlias(merged).build());
            } else if (existing.hasEnum() && !(newVis = this.higherVisibility(visibility, existing.getEnum().getVisibility())).equals((Object)existing.getEnum().getVisibility())) {
                Enum merged = existing.getEnum().toBuilder().setVisibility(newVis).build();
                this.decls.put(name, Decl.newBuilder().setEnum(merged).build());
                for (EnumVariant field : existing.getEnum().getVariantsList()) {
                    if (!field.getValue().hasTypeValue() || !field.getValue().getTypeValue().getValue().hasRef()) continue;
                    Ref ref = field.getValue().getTypeValue().getValue().getRef();
                    this.setDeclExport(ref.getName(), newVis);
                }
            }
        }
        return existing != null;
    }

    private void duplicateNameValidationError(java.lang.String name, xyz.block.ftl.schema.v1.Position pos, Decl existingDecl) {
        if (this.isGenerated(existingDecl)) {
            this.validationFailures.add(new ValidationFailure(PositionUtils.toError(pos), java.lang.String.format("schema declaration with name \"%s\" conflicts with FTL-generated type", name, this.moduleName, pos.getFilename() + ":" + pos.getLine())));
        } else {
            this.validationFailures.add(new ValidationFailure(PositionUtils.toError(pos), java.lang.String.format("schema declaration with name \"%s\" already exists for module \"%s\"; previously declared at \"%s\"", name, this.moduleName, pos.getFilename() + ":" + pos.getLine())));
        }
    }

    private boolean isGenerated(Decl decl) {
        List metadata;
        if (decl.hasData()) {
            metadata = decl.getData().getMetadataList();
        } else if (decl.hasVerb()) {
            metadata = decl.getVerb().getMetadataList();
        } else {
            return false;
        }
        return metadata.stream().filter(m -> m.hasGenerated()).findFirst().isPresent();
    }

    java.lang.String validateName(xyz.block.ftl.schema.v1.Position position, java.lang.String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            this.validationFailures.add(new ValidationFailure(PositionUtils.toError(position), java.lang.String.format("Invalid name %s, must match " + java.lang.String.valueOf(NAME_PATTERN), name)));
        }
        return name;
    }

    java.lang.String validateName(java.lang.String className, java.lang.String name) {
        return this.validateName(PositionUtils.toError(PositionUtils.forClass(className)), name);
    }

    java.lang.String validateName(MethodInfo methodInfo, java.lang.String name) {
        return this.validateName(PositionUtils.toError(PositionUtils.forMethod(methodInfo)), name);
    }

    java.lang.String validateName(Position position, java.lang.String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            this.validationFailures.add(new ValidationFailure(position, java.lang.String.format("Invalid name %s, must match " + java.lang.String.valueOf(NAME_PATTERN), name)));
        }
        return name;
    }

    public static class VerbCustomization {
        private Consumer<Verb.Builder> metadataCallback = b -> {};
        private Function<Integer, Boolean> ignoreParameter = i -> false;
        private Function<Type, Type> requestType = Function.identity();
        private Function<Type, Type> responseType = Function.identity();
        private boolean customHandling;

        public Consumer<Verb.Builder> getMetadataCallback() {
            return this.metadataCallback;
        }

        public VerbCustomization setMetadataCallback(Consumer<Verb.Builder> metadataCallback) {
            this.metadataCallback = metadataCallback;
            return this;
        }

        public Function<Integer, Boolean> getIgnoreParameter() {
            return this.ignoreParameter;
        }

        public VerbCustomization setIgnoreParameter(Function<Integer, Boolean> ignoreParameter) {
            this.ignoreParameter = ignoreParameter;
            return this;
        }

        public Function<Type, Type> getRequestType() {
            return this.requestType;
        }

        public VerbCustomization setRequestType(Function<Type, Type> requestType) {
            this.requestType = requestType;
            return this;
        }

        public Function<Type, Type> getResponseType() {
            return this.responseType;
        }

        public VerbCustomization setResponseType(Function<Type, Type> responseType) {
            this.responseType = responseType;
            return this;
        }

        public boolean isCustomHandling() {
            return this.customHandling;
        }

        public VerbCustomization setCustomHandling(boolean customHandling) {
            this.customHandling = customHandling;
            return this;
        }
    }

    public static enum BodyType {
        DISALLOWED,
        ALLOWED,
        REQUIRED;

    }

    record ValidationFailure(Position position, java.lang.String message) {
    }
}

