/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.VoidType;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jetbrains.annotations.NotNull;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.PositionUtils;
import xyz.block.ftl.deployment.ProjectRootBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.builtin.HttpRequest;
import xyz.block.ftl.runtime.builtin.HttpResponse;
import xyz.block.ftl.schema.v1.Array;
import xyz.block.ftl.schema.v1.IngressPathComponent;
import xyz.block.ftl.schema.v1.IngressPathLiteral;
import xyz.block.ftl.schema.v1.IngressPathParameter;
import xyz.block.ftl.schema.v1.Map;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataIngress;
import xyz.block.ftl.schema.v1.Position;
import xyz.block.ftl.schema.v1.Ref;
import xyz.block.ftl.schema.v1.String;
import xyz.block.ftl.schema.v1.Type;
import xyz.block.ftl.schema.v1.Unit;
import xyz.block.ftl.schema.v1.Visibility;

public class HTTPProcessor {
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public MethodScannerBuildItem methodScanners(final TopicsBuildItem topics, final VerbClientBuildItem verbClients, final FTLRecorder recorder) {
        return new MethodScannerBuildItem(new MethodScanner(){

            public ParameterExtractor handleCustomParameter(org.jboss.jandex.Type type, java.util.Map<DotName, AnnotationInstance> annotations, boolean field, java.util.Map<java.lang.String, Object> methodContext) {
                try {
                    if (field) {
                        return null;
                    }
                    if (annotations.containsKey(FTLDotNames.SECRET)) {
                        Class<?> paramType = ModuleBuilder.loadClass(type);
                        java.lang.String name = annotations.get(FTLDotNames.SECRET).value().asString();
                        return new VerbRegistry.SecretSupplier(name, paramType);
                    }
                    if (annotations.containsKey(FTLDotNames.CONFIG)) {
                        Class<?> paramType = ModuleBuilder.loadClass(type);
                        java.lang.String name = annotations.get(FTLDotNames.CONFIG).value().asString();
                        return new VerbRegistry.ConfigSupplier(name, paramType);
                    }
                    if (annotations.containsKey(FTLDotNames.EGRESS)) {
                        Class<?> paramType = ModuleBuilder.loadClass(type);
                        java.lang.String name = annotations.get(FTLDotNames.EGRESS).value().asString();
                        return new VerbRegistry.EgressSupplier(name, paramType);
                    }
                    if (topics.getTopics().containsKey(type.name())) {
                        TopicsBuildItem.DiscoveredTopic topic = topics.getTopics().get(type.name());
                        return recorder.topicParamExtractor(topic.generatedProducer());
                    }
                    if (verbClients.getVerbClients().containsKey(type.name())) {
                        VerbClientBuildItem.DiscoveredClients client = verbClients.getVerbClients().get(type.name());
                        return recorder.verbParamExtractor(client.generatedClient());
                    }
                    if (FTLDotNames.LEASE_CLIENT.equals((Object)type.name())) {
                        return recorder.leaseClientExtractor();
                    }
                    return null;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public SchemaContributorBuildItem registerHttpHandlers(ProjectRootBuildItem projectRootBuildItem, final FTLRecorder recorder, final ResteasyReactiveResourceMethodEntriesBuildItem restEndpoints) {
        java.lang.String projectRoot = projectRootBuildItem.getProjectRoot();
        final ArrayList<Map.Entry<Position, CallSite>> errors = new ArrayList<Map.Entry<Position, CallSite>>();
        for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry endpoint : restEndpoints.getEntries()) {
            MethodInfo methodInfo = endpoint.getMethodInfo();
            if (!methodInfo.hasAnnotation(FTLDotNames.VERB) && !methodInfo.hasAnnotation(FTLDotNames.CRON) && !methodInfo.hasAnnotation(FTLDotNames.FIXTURE) && !methodInfo.hasAnnotation(FTLDotNames.SUBSCRIPTION)) continue;
            errors.add(java.util.Map.entry(PositionUtils.forMethod(projectRoot, methodInfo), "HTTP handler " + methodInfo.name() + " should not be annotated with other verb defining annotations"));
        }
        if (!errors.isEmpty()) {
            return new SchemaContributorBuildItem(new Consumer<ModuleBuilder>(){

                @Override
                public void accept(ModuleBuilder moduleBuilder) {
                    for (Map.Entry entry : errors) {
                        moduleBuilder.registerValidationFailure((Position)entry.getKey(), (java.lang.String)entry.getValue());
                    }
                }
            });
        }
        return new SchemaContributorBuildItem(new Consumer<ModuleBuilder>(){

            @Override
            public void accept(ModuleBuilder moduleBuilder) {
                Type stringType = Type.newBuilder().setString(String.newBuilder().build()).build();
                for (ResteasyReactiveResourceMethodEntriesBuildItem.Entry endpoint : restEndpoints.getEntries()) {
                    org.jboss.jandex.Type component;
                    if (endpoint.getMethodInfo().returnType().name().toString().equals("ftl.builtin.HttpResponse")) {
                        moduleBuilder.registerValidationFailure(endpoint.getMethodInfo(), "HTTP handler " + endpoint.getMethodInfo().name() + " should not return ftl.builtin.HttpResponse directly, it should just return the payload type");
                        continue;
                    }
                    java.lang.String verbName = ModuleBuilder.methodToName(endpoint.getMethodInfo());
                    VoidType bodyParamType = VoidType.VOID;
                    MethodParameter[] parameters = endpoint.getResourceMethod().getParameters();
                    ArrayList<MethodParameter> pathParams = new ArrayList<MethodParameter>();
                    ArrayList<MethodParameter> queryParams = new ArrayList<MethodParameter>();
                    int parametersLength = parameters.length;
                    for (int i2 = 0; i2 < parametersLength; ++i2) {
                        MethodParameter httpParam = parameters[i2];
                        if (httpParam.parameterType.equals((Object)ParameterType.BODY)) {
                            bodyParamType = endpoint.getMethodInfo().parameterType(i2);
                            continue;
                        }
                        if (httpParam.parameterType.equals((Object)ParameterType.PATH)) {
                            pathParams.add(httpParam);
                            continue;
                        }
                        if (!httpParam.parameterType.equals((Object)ParameterType.QUERY)) continue;
                        queryParams.add(httpParam);
                    }
                    boolean base64 = false;
                    if (bodyParamType instanceof ArrayType && (component = ((ArrayType)bodyParamType).component()) instanceof PrimitiveType) {
                        base64 = component.asPrimitiveType().equals((Object)PrimitiveType.BYTE);
                    }
                    recorder.registerHttpIngress(moduleBuilder.getModuleName(), verbName, base64);
                    java.lang.String path = HTTPProcessor.extractPath(endpoint);
                    URITemplate template = new URITemplate(path, false);
                    ArrayList<IngressPathComponent> pathComponents = new ArrayList<IngressPathComponent>();
                    boolean hasParams = false;
                    for (URITemplate.TemplateComponent i3 : template.components) {
                        if (i3.type == URITemplate.Type.CUSTOM_REGEX) {
                            throw new RuntimeException("Invalid path " + path + " on HTTP endpoint: " + java.lang.String.valueOf(endpoint.getActualClassInfo().name()) + "." + ModuleBuilder.methodToName(endpoint.getMethodInfo()) + " FTL does not support custom regular expressions");
                        }
                        if (i3.type == URITemplate.Type.LITERAL) {
                            for (java.lang.String part : i3.literalText.split("/")) {
                                if (part.isEmpty()) continue;
                                pathComponents.add(IngressPathComponent.newBuilder().setIngressPathLiteral(IngressPathLiteral.newBuilder().setText(part)).build());
                            }
                            continue;
                        }
                        hasParams = true;
                        pathComponents.add(IngressPathComponent.newBuilder().setIngressPathParameter(IngressPathParameter.newBuilder().setName(i3.name)).build());
                    }
                    Type pathParamType = pathParams.isEmpty() && !hasParams ? Type.newBuilder().setUnit(Unit.newBuilder()).build() : Type.newBuilder().setMap(Map.newBuilder().setKey(stringType).setValue(stringType)).build();
                    Type.Builder queryParamsType = queryParams.isEmpty() ? Type.newBuilder().setUnit(Unit.newBuilder()) : Type.newBuilder().setMap(Map.newBuilder().setKey(stringType).setValue(Type.newBuilder().setArray(Array.newBuilder().setElement(stringType))));
                    ModuleBuilder.VerbCustomization verbCustomization = new ModuleBuilder.VerbCustomization();
                    verbCustomization.setCustomHandling(true).setMetadataCallback(builder -> {
                        MetadataIngress.Builder ingressBuilder = MetadataIngress.newBuilder().setType("http").setMethod(endpoint.getResourceMethod().getHttpMethod());
                        for (IngressPathComponent i : pathComponents) {
                            ingressBuilder.addPath(i);
                        }
                        Metadata ingressMetadata = Metadata.newBuilder().setIngress(ingressBuilder.build()).build();
                        builder.addMetadata(ingressMetadata);
                    }).setIgnoreParameter(i -> !parameters[i.intValue()].parameterType.equals((Object)ParameterType.BODY) && !parameters[i.intValue()].parameterType.equals((Object)ParameterType.CUSTOM)).setRequestType(requestTypeParam -> Type.newBuilder().setRef(Ref.newBuilder().setModule("builtin").setName(HttpRequest.class.getSimpleName()).addTypeParameters(requestTypeParam).addTypeParameters(pathParamType).addTypeParameters(queryParamsType)).build()).setResponseType(responseTypeParam -> Type.newBuilder().setRef(Ref.newBuilder().setModule("builtin").setName(HttpResponse.class.getSimpleName()).addTypeParameters(responseTypeParam).addTypeParameters(Type.newBuilder().setUnit(Unit.newBuilder()))).build());
                    moduleBuilder.registerVerbMethod(endpoint.getMethodInfo(), endpoint.getActualClassInfo().name().toString(), Visibility.VISIBILITY_SCOPE_NONE, false, ModuleBuilder.BodyType.ALLOWED, verbCustomization);
                }
            }
        });
    }

    @NotNull
    private static java.lang.String extractPath(ResteasyReactiveResourceMethodEntriesBuildItem.Entry endpoint) {
        StringBuilder pathBuilder = new StringBuilder();
        if (endpoint.getBasicResourceClassInfo().getPath() != null) {
            pathBuilder.append(endpoint.getBasicResourceClassInfo().getPath());
        }
        if (endpoint.getResourceMethod().getPath() != null && !endpoint.getResourceMethod().getPath().isEmpty()) {
            boolean builderEndsSlash = pathBuilder.charAt(pathBuilder.length() - 1) == '/';
            boolean pathStartsSlash = endpoint.getResourceMethod().getPath().startsWith("/");
            if (builderEndsSlash && pathStartsSlash) {
                pathBuilder.setLength(pathBuilder.length() - 1);
            } else if (!builderEndsSlash && !pathStartsSlash) {
                pathBuilder.append('/');
            }
            pathBuilder.append(endpoint.getResourceMethod().getPath());
        }
        return pathBuilder.toString();
    }
}

