/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Singleton;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import xyz.block.ftl.EmptyVerb;
import xyz.block.ftl.FunctionVerb;
import xyz.block.ftl.SQLQueryClient;
import xyz.block.ftl.SinkVerb;
import xyz.block.ftl.SourceVerb;
import xyz.block.ftl.Verb;
import xyz.block.ftl.VerbClient;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.ModuleNameBuildItem;
import xyz.block.ftl.deployment.SQLQueryClientBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TypeAliasBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.deployment.VerbInfo;
import xyz.block.ftl.deployment.VerbType;
import xyz.block.ftl.deployment.VerbUtil;
import xyz.block.ftl.deployment.VisibilityUtil;
import xyz.block.ftl.runtime.VerbClientHelper;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataCronJob;
import xyz.block.ftl.schema.v1.MetadataFixture;
import xyz.block.ftl.schema.v1.Visibility;

public class VerbProcessor {
    public static final DotName VERB_CLIENT = DotName.createSimple(FunctionVerb.class);
    public static final DotName VERB_CLIENT_SINK = DotName.createSimple(SinkVerb.class);
    public static final DotName VERB_CLIENT_SOURCE = DotName.createSimple(SourceVerb.class);
    public static final DotName VERB_CLIENT_EMPTY = DotName.createSimple(EmptyVerb.class);
    public static final String TEST_ANNOTATION = "xyz.block.ftl.java.test.FTLManaged";
    private static final Logger log = Logger.getLogger(VerbProcessor.class);

    @BuildStep
    VerbClientBuildItem handleVerbClients(CombinedIndexBuildItem index, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildItemBuildProducer, ModuleNameBuildItem moduleNameBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        ClassCreator cc;
        ResultHandle helper;
        ResultHandle results;
        GeneratedBeanGizmoAdaptor classOutput;
        Object module;
        Collection clientDefinitions = index.getComputingIndex().getAnnotations(VerbClient.class);
        log.debugf("Processing %d verb clients", clientDefinitions.size());
        HashMap<DotName, VerbClientBuildItem.DiscoveredClients> clients = new HashMap<DotName, VerbClientBuildItem.DiscoveredClients>();
        for (AnnotationInstance clientDefinition : clientDefinitions) {
            ClassInfo iface = clientDefinition.target().asClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@VerbClient can only be applied to interfaces and " + String.valueOf(iface.name()) + " is not an interface");
            }
            AnnotationValue moduleValue = clientDefinition.value("module");
            String name = clientDefinition.value("name").asString();
            module = moduleValue == null || moduleValue.asString().isEmpty() ? moduleNameBuildItem.getModuleName() : moduleValue.asString();
            classOutput = new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer);
            boolean found = false;
            for (Type i : iface.interfaceTypes()) {
                LinkedHashSet<String> signatures;
                Type returnType;
                if (i.name().equals((Object)VERB_CLIENT)) {
                    if (i.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        returnType = (Type)i.asParameterizedType().arguments().get(1);
                        Type paramType = (Type)i.asParameterizedType().arguments().get(0);
                        try (ClassCreator cc3 = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});){
                            if (launchModeBuildItem.isTest()) {
                                cc3.addAnnotation(TEST_ANNOTATION);
                                cc3.addAnnotation(Singleton.class);
                            }
                            LinkedHashSet<Map.Entry<String, String>> linkedHashSet = new LinkedHashSet<Map.Entry<String, String>>();
                            linkedHashSet.add(Map.entry(returnType.name().toString(), paramType.name().toString()));
                            linkedHashSet.add(Map.entry(Object.class.getName(), Object.class.getName()));
                            for (MethodInfo methodInfo : iface.methods()) {
                                if (!methodInfo.name().equals("call") || methodInfo.parameters().size() != 1) continue;
                                linkedHashSet.add(Map.entry(methodInfo.returnType().name().toString(), ((MethodParameterInfo)methodInfo.parameters().get(0)).type().name().toString()));
                            }
                            for (Map.Entry entry : linkedHashSet) {
                                MethodCreator publish = cc3.getMethodCreator("call", (String)entry.getKey(), new String[]{(String)entry.getValue()});
                                ResultHandle helper2 = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                                results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper2, new ResultHandle[]{publish.load(name), publish.load((String)module), publish.getMethodParam(0), publish.loadClass(returnType.name().toString()), publish.load(false), publish.load(false)});
                                publish.returnValue(results);
                            }
                            clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, (String)module, cc3.getClassName()));
                        }
                        found = true;
                        break;
                    }
                    throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + String.valueOf(iface.name()) + " does not have concrete type parameters");
                }
                if (i.name().equals((Object)VERB_CLIENT_SINK)) {
                    if (i.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        Type paramType = (Type)i.asParameterizedType().arguments().get(0);
                        try (ClassCreator cc2 = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});){
                            if (launchModeBuildItem.isTest()) {
                                cc2.addAnnotation(TEST_ANNOTATION);
                                cc2.addAnnotation(Singleton.class);
                            }
                            signatures = new LinkedHashSet<String>();
                            signatures.add(paramType.name().toString());
                            signatures.add(Object.class.getName());
                            for (MethodInfo methodInfo : iface.methods()) {
                                if (!methodInfo.name().equals("call") || methodInfo.parameters().size() != 1) continue;
                                signatures.add(((MethodParameterInfo)methodInfo.parameters().get(0)).type().name().toString());
                            }
                            for (String string : signatures) {
                                MethodCreator methodCreator = cc2.getMethodCreator("call", Void.TYPE, new Object[]{string});
                                helper = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                                methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{methodCreator.load(name), methodCreator.load((String)module), methodCreator.getMethodParam(0), methodCreator.loadClass(Void.class), methodCreator.load(false), methodCreator.load(false)});
                                methodCreator.returnVoid();
                            }
                            clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, (String)module, cc2.getClassName()));
                        }
                        found = true;
                        break;
                    }
                    throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + String.valueOf(iface.name()) + " does not have concrete type parameters");
                }
                if (i.name().equals((Object)VERB_CLIENT_SOURCE)) {
                    if (i.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        returnType = (Type)i.asParameterizedType().arguments().get(0);
                        try (ClassCreator cc2 = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});){
                            if (launchModeBuildItem.isTest()) {
                                cc2.addAnnotation(TEST_ANNOTATION);
                                cc2.addAnnotation(Singleton.class);
                            }
                            signatures = new LinkedHashSet();
                            signatures.add(returnType.name().toString());
                            signatures.add(Object.class.getName());
                            for (MethodInfo methodInfo : iface.methods()) {
                                if (!methodInfo.name().equals("call") || methodInfo.parameters().size() != 0) continue;
                                signatures.add(methodInfo.returnType().name().toString());
                            }
                            for (String string : signatures) {
                                MethodCreator methodCreator = cc2.getMethodCreator("call", string, new String[0]);
                                helper = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                                ResultHandle results2 = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{methodCreator.load(name), methodCreator.load((String)module), methodCreator.loadNull(), methodCreator.loadClass(returnType.name().toString()), methodCreator.load(false), methodCreator.load(false)});
                                methodCreator.returnValue(results2);
                            }
                            clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, (String)module, cc2.getClassName()));
                        }
                        found = true;
                        break;
                    }
                    throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + String.valueOf(iface.name()) + " does not have concrete type parameters");
                }
                if (!i.name().equals((Object)VERB_CLIENT_EMPTY)) continue;
                cc = new ClassCreator((ClassOutput)classOutput, iface.name().toString() + "_fit_verbclient", null, Object.class.getName(), new String[]{iface.name().toString()});
                try {
                    if (launchModeBuildItem.isTest()) {
                        cc.addAnnotation(TEST_ANNOTATION);
                        cc.addAnnotation(Singleton.class);
                    }
                    MethodCreator publish3 = cc.getMethodCreator("call", Void.TYPE, new Class[0]);
                    ResultHandle helper3 = publish3.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                    publish3.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper3, new ResultHandle[]{publish3.load(name), publish3.load((String)module), publish3.loadNull(), publish3.loadClass(Void.class), publish3.load(false), publish3.load(false)});
                    publish3.returnVoid();
                    clients.put(iface.name(), new VerbClientBuildItem.DiscoveredClients(name, (String)module, cc.getClassName()));
                }
                finally {
                    cc.close();
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("@VerbClientDefinition can only be applied to interfaces that directly extend a verb client type with concrete type parameters and " + String.valueOf(iface.name()) + " does not extend a verb client type");
        }
        clientDefinitions = index.getComputingIndex().getAnnotations(Verb.class);
        log.debugf("Processing %d verb types as clients", clientDefinitions.size());
        for (AnnotationInstance clientDefinition : clientDefinitions) {
            if (clientDefinition.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            final ClassInfo verbClass = clientDefinition.target().asClass();
            VerbInfo info = VerbUtil.getVerbInfo(index.getIndex(), verbClass);
            if (info == null) continue;
            boolean hasNoArgCtor = false;
            for (MethodInfo method : verbClass.methods()) {
                if (!method.name().equals("<init>") || !method.parameters().isEmpty()) continue;
                hasNoArgCtor = true;
                break;
            }
            if (!hasNoArgCtor) {
                bytecodeTransformerBuildItemBuildProducer.produce((BuildItem)new BytecodeTransformerBuildItem(verbClass.name().toString(), (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                    @Override
                    public ClassVisitor apply(String className, ClassVisitor classVisitor) {
                        ClassVisitor cv = new ClassVisitor(589824, classVisitor){

                            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                super.visit(version, access & 0xFFFFFFEF, name, signature, superName, interfaces);
                                MethodVisitor ctor = this.visitMethod(4097, "<init>", "()V", null, null);
                                ctor.visitCode();
                                ctor.visitVarInsn(25, 0);
                                ctor.visitMethodInsn(183, verbClass.superName().toString().replaceAll("\\.", "/"), "<init>", "()V", false);
                                ctor.visitInsn(177);
                                ctor.visitMaxs(1, 1);
                                ctor.visitEnd();
                            }
                        };
                        return cv;
                    }
                }));
            }
            if (Modifier.isFinal(verbClass.flags())) {
                bytecodeTransformerBuildItemBuildProducer.produce((BuildItem)new BytecodeTransformerBuildItem(verbClass.name().toString(), (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(this){

                    @Override
                    public ClassVisitor apply(String className, ClassVisitor classVisitor) {
                        return new ClassVisitor(this, 589824, classVisitor){

                            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                super.visit(version, access & 0xFFFFFFEF, name, signature, superName, interfaces);
                            }
                        };
                    }
                }));
            }
            module = moduleNameBuildItem.getModuleName();
            classOutput = new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer);
            MethodInfo callMethod = info.method();
            Type returnType = callMethod.returnType();
            Type paramType = callMethod.parametersCount() > 0 ? callMethod.parameterType(0) : null;
            cc = new ClassCreator((ClassOutput)classOutput, verbClass.name().toString() + "_fit_verbclient", null, verbClass.name().toString(), new String[0]);
            try {
                cc.addAnnotation(RequestScoped.class);
                switch (VerbType.of(callMethod)) {
                    case VERB: {
                        LinkedHashSet<Map.Entry<String, String>> signatures = new LinkedHashSet<Map.Entry<String, String>>();
                        signatures.add(Map.entry(returnType.name().toString(), paramType.name().toString()));
                        signatures.add(Map.entry(Object.class.getName(), Object.class.getName()));
                        for (Map.Entry entry : signatures) {
                            MethodCreator methodCreator = cc.getMethodCreator(callMethod.name(), (String)entry.getKey(), new String[]{(String)entry.getValue()});
                            ResultHandle resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle results3 = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), resultHandle, new ResultHandle[]{methodCreator.load(info.name()), methodCreator.load((String)module), methodCreator.getMethodParam(0), methodCreator.loadClass(returnType.name().toString()), methodCreator.load(false), methodCreator.load(false)});
                            methodCreator.returnValue(results3);
                        }
                        break;
                    }
                    case SINK: {
                        LinkedHashSet<String> sinkSignatures = new LinkedHashSet<String>();
                        sinkSignatures.add(paramType.name().toString());
                        sinkSignatures.add(Object.class.getName());
                        for (String string : sinkSignatures) {
                            MethodCreator methodCreator = cc.getMethodCreator(callMethod.name(), Void.TYPE, new Object[]{string});
                            helper = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper, new ResultHandle[]{methodCreator.load(info.name()), methodCreator.load((String)module), methodCreator.getMethodParam(0), methodCreator.loadClass(Void.class), methodCreator.load(false), methodCreator.load(false)});
                            methodCreator.returnVoid();
                        }
                        break;
                    }
                    case SOURCE: {
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        linkedHashSet.add(returnType.name().toString());
                        linkedHashSet.add(Object.class.getName());
                        for (String string : linkedHashSet) {
                            MethodCreator publish2 = cc.getMethodCreator(callMethod.name(), string, new String[0]);
                            ResultHandle helper2 = publish2.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            results = publish2.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), helper2, new ResultHandle[]{publish2.load(info.name()), publish2.load((String)module), publish2.loadNull(), publish2.loadClass(returnType.name().toString()), publish2.load(false), publish2.load(false)});
                            publish2.returnValue(results);
                        }
                        break;
                    }
                    case EMPTY: {
                        MethodCreator methodCreator = cc.getMethodCreator(callMethod.name(), Void.TYPE, new Class[0]);
                        ResultHandle resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                        methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"call", Object.class, (Class[])new Class[]{String.class, String.class, Object.class, Class.class, Boolean.TYPE, Boolean.TYPE}), resultHandle, new ResultHandle[]{methodCreator.load(info.name()), methodCreator.load((String)module), methodCreator.loadNull(), methodCreator.loadClass(Void.class), methodCreator.load(false), methodCreator.load(false)});
                        methodCreator.returnVoid();
                    }
                }
                clients.put(verbClass.name(), new VerbClientBuildItem.DiscoveredClients(info.name(), (String)module, cc.getClassName()));
            }
            finally {
                cc.close();
            }
        }
        return new VerbClientBuildItem(clients);
    }

    @BuildStep
    SQLQueryClientBuildItem handleSQLQueryClients(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedClients, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, ModuleNameBuildItem moduleNameBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        Collection clientDefinitions = index.getComputingIndex().getAnnotations(SQLQueryClient.class);
        if (clientDefinitions.isEmpty()) {
            return new SQLQueryClientBuildItem(Map.of());
        }
        HashMap<DotName, SQLQueryClientBuildItem.DiscoveredClients> clients = new HashMap<DotName, SQLQueryClientBuildItem.DiscoveredClients>();
        for (AnnotationInstance clientDefinition : clientDefinitions) {
            MethodInfo callMethod = clientDefinition.target().asMethod();
            ClassInfo iface = callMethod.declaringClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@SQLQueryClient can only be applied to methods in interfaces and " + String.valueOf(callMethod) + " is in class " + String.valueOf(iface.name()));
            }
            String name = callMethod.name();
            AnnotationValue moduleValue = clientDefinition.value("module");
            String module = moduleValue == null || moduleValue.asString().isEmpty() ? moduleNameBuildItem.getModuleName() : moduleValue.asString();
            AnnotationValue dbNameValue = clientDefinition.value("dbName");
            String dbName = dbNameValue == null ? "" : dbNameValue.asString();
            AnnotationValue rawSQLValue = clientDefinition.value("rawSQL");
            String rawSQL = rawSQLValue == null ? "" : rawSQLValue.asString();
            AnnotationValue commandValue = clientDefinition.value("command");
            String command = commandValue == null ? "" : commandValue.asString();
            AnnotationValue fieldsValue = clientDefinition.value("fields");
            String[] fields = fieldsValue == null ? new String[]{} : fieldsValue.asStringArray();
            AnnotationValue colToFieldNameValue = clientDefinition.value("colToFieldName");
            String[] colToFieldName = colToFieldNameValue == null ? new String[]{} : colToFieldNameValue.asStringArray();
            Object classOutput = launchModeBuildItem.isTest() ? new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer) : new GeneratedClassGizmoAdaptor(generatedClients, true);
            Type returnType = callMethod.returnType();
            String actualReturnType = returnType.name().toString();
            if (returnType.name().toString().startsWith("java.util.List") && returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                actualReturnType = ((Type)returnType.asParameterizedType().arguments().get(0)).name().toString();
            }
            String className = iface.name().toString() + "_fit_sqlqueryclient";
            Type paramType = callMethod.parametersCount() > 0 ? callMethod.parameterType(0) : null;
            try (ClassCreator cc = new ClassCreator((ClassOutput)classOutput, className, null, Object.class.getName(), new String[]{iface.name().toString()});){
                if (launchModeBuildItem.isTest()) {
                    cc.addAnnotation(TEST_ANNOTATION);
                    cc.addAnnotation(Singleton.class);
                }
                switch (VerbType.of(callMethod)) {
                    case VERB: {
                        ResultHandle helper;
                        MethodCreator publish;
                        LinkedHashSet<Map.Entry<String, String>> signatures = new LinkedHashSet<Map.Entry<String, String>>();
                        signatures.add(Map.entry(returnType.name().toString(), paramType.name().toString()));
                        signatures.add(Map.entry(Object.class.getName(), Object.class.getName()));
                        for (Map.Entry entry : signatures) {
                            publish = cc.getMethodCreator(name, (String)entry.getKey(), new String[]{(String)entry.getValue()});
                            helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle fieldsArray = publish.newArray(String.class, fields.length);
                            for (int i = 0; i < fields.length; ++i) {
                                publish.writeArrayValue(fieldsArray, i, publish.load(fields[i]));
                            }
                            ResultHandle colToFieldNameArray = publish.newArray(String.class, colToFieldName.length);
                            for (int i = 0; i < colToFieldName.length; ++i) {
                                publish.writeArrayValue(colToFieldNameArray, i, publish.load(colToFieldName[i]));
                            }
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.getMethodParam(0), publish.load(dbName), publish.load(command), publish.load(rawSQL), fieldsArray, colToFieldNameArray, publish.loadClass(actualReturnType)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case SINK: {
                        LinkedHashSet<String> sinkSignatures = new LinkedHashSet<String>();
                        sinkSignatures.add(paramType.name().toString());
                        sinkSignatures.add(Object.class.getName());
                        for (Object sig2 : sinkSignatures) {
                            MethodCreator publish = cc.getMethodCreator(name, Void.TYPE, new Object[]{sig2});
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle fieldsArray = publish.newArray(String.class, fields.length);
                            for (int i = 0; i < fields.length; ++i) {
                                publish.writeArrayValue(fieldsArray, i, publish.load(fields[i]));
                            }
                            publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.getMethodParam(0), publish.load(dbName), publish.load(command), publish.load(rawSQL), fieldsArray, publish.newArray(String.class, 0), publish.loadClass(Void.class)});
                            publish.returnVoid();
                        }
                        break;
                    }
                    case SOURCE: {
                        Object sig2;
                        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                        linkedHashSet.add(returnType.name().toString());
                        linkedHashSet.add(Object.class.getName());
                        sig2 = linkedHashSet.iterator();
                        while (sig2.hasNext()) {
                            String sig = (String)sig2.next();
                            MethodCreator publish = cc.getMethodCreator(name, sig, new String[0]);
                            ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle colToFieldNameArray = publish.newArray(String.class, colToFieldName.length);
                            for (int i = 0; i < colToFieldName.length; ++i) {
                                publish.writeArrayValue(colToFieldNameArray, i, publish.load(colToFieldName[i]));
                            }
                            ResultHandle results = publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.loadNull(), publish.load(dbName), publish.load(command), publish.load(rawSQL), publish.newArray(String.class, 0), colToFieldNameArray, publish.loadClass(actualReturnType)});
                            publish.returnValue(results);
                        }
                        break;
                    }
                    case EMPTY: {
                        MethodCreator publish = cc.getMethodCreator(name, Void.TYPE, new Class[0]);
                        ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"instance", VerbClientHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                        publish.invokeVirtualMethod(MethodDescriptor.ofMethod(VerbClientHelper.class, (String)"executeQuery", Object.class, (Class[])new Class[]{Object.class, String.class, String.class, String.class, String[].class, String[].class, Class.class}), helper, new ResultHandle[]{publish.loadNull(), publish.load(dbName), publish.load(command), publish.load(rawSQL), publish.newArray(String.class, 0), publish.newArray(String.class, 0), publish.loadClass(Void.class)});
                        publish.returnVoid();
                    }
                }
                clients.put(iface.name(), new SQLQueryClientBuildItem.DiscoveredClients(name, module, cc.getClassName()));
            }
        }
        return new SQLQueryClientBuildItem(clients);
    }

    @BuildStep
    public void verbsAndCron(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItem, BuildProducer<SchemaContributorBuildItem> schemaContributorBuildItemBuildProducer, List<TypeAliasBuildItem> typeAliasBuildItems) {
        Collection verbAnnotations = index.getIndex().getAnnotations(FTLDotNames.VERB);
        log.debugf("Processing %d verb annotations into decls", verbAnnotations.size());
        AdditionalBeanBuildItem.Builder beans = AdditionalBeanBuildItem.builder().setUnremovable();
        for (Object verb : verbAnnotations) {
            if (verb.target().kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = verb.target().asMethod();
                if (method.hasAnnotation(FTLDotNames.CRON) || method.hasAnnotation(FTLDotNames.SUBSCRIPTION) || method.hasAnnotation(FTLDotNames.FIXTURE)) {
                    throw new RuntimeException("Method " + String.valueOf(method) + " cannot have both @Verb and @Cron, @Fixture or @Subscription");
                }
                String className = method.declaringClass().name().toString();
                beans.addBeanClass(className);
                schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, VisibilityUtil.getVisibility((AnnotationTarget)method), false, ModuleBuilder.BodyType.ALLOWED)));
                continue;
            }
            ClassInfo type = verb.target().asClass();
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(arg_0 -> VerbProcessor.lambda$verbsAndCron$1(type, (AnnotationInstance)verb, arg_0)));
        }
        Collection transactionAnnotations = index.getIndex().getAnnotations(FTLDotNames.TRANSACTIONAL);
        for (Object txn : transactionAnnotations) {
            MethodInfo method = txn.target().asMethod();
            if (method.hasAnnotation(FTLDotNames.VERB) || method.hasAnnotation(FTLDotNames.CRON) || method.hasAnnotation(FTLDotNames.SUBSCRIPTION) || method.hasAnnotation(FTLDotNames.FIXTURE)) {
                throw new RuntimeException("Method " + String.valueOf(method) + " cannot have both @Transaction and @Verb, @Cron, @Fixture or @Subscription");
            }
            String className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, VisibilityUtil.getVisibility((AnnotationTarget)method), true, ModuleBuilder.BodyType.ALLOWED)));
        }
        Collection cronAnnotations = index.getIndex().getAnnotations(FTLDotNames.CRON);
        log.debugf("Processing %d cron job annotations into decls", cronAnnotations.size());
        for (Object cron : cronAnnotations) {
            MethodInfo method = cron.target().asMethod();
            if (method.hasAnnotation(FTLDotNames.VERB) || method.hasAnnotation(FTLDotNames.SUBSCRIPTION)) {
                throw new RuntimeException("Method " + String.valueOf(method) + " cannot have both @Cron and @Verb or @Subscription");
            }
            String className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(arg_0 -> VerbProcessor.lambda$verbsAndCron$4(method, className, (AnnotationInstance)cron, arg_0)));
        }
        Collection fixtureAnnotation = index.getIndex().getAnnotations(FTLDotNames.FIXTURE);
        log.debugf("Processing %d fixture annotations into decls", cronAnnotations.size());
        for (AnnotationInstance fixture : fixtureAnnotation) {
            MethodInfo method = fixture.target().asMethod();
            if (method.hasAnnotation(FTLDotNames.VERB) || method.hasAnnotation(FTLDotNames.SUBSCRIPTION) || method.hasAnnotation(FTLDotNames.CRON)) {
                throw new RuntimeException("Method " + String.valueOf(method) + " cannot have both @Fixture and @Verb, @Cron or @Subscription");
            }
            String className = method.declaringClass().name().toString();
            beans.addBeanClass(className);
            AnnotationValue manualElement = fixture.value("target");
            boolean manual = manualElement != null && manualElement.asBoolean();
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerVerbMethod(method, className, Visibility.VISIBILITY_SCOPE_NONE, false, ModuleBuilder.BodyType.DISALLOWED, new ModuleBuilder.VerbCustomization().setMetadataCallback(builder -> builder.addMetadata(Metadata.newBuilder().setFixture(MetadataFixture.newBuilder().setManual(manual)).build())))));
        }
        Collection sqlQueryClientDefinitions = index.getComputingIndex().getAnnotations(SQLQueryClient.class);
        for (AnnotationInstance clientDefinition : sqlQueryClientDefinitions) {
            String module;
            MethodInfo callMethod = clientDefinition.target().asMethod();
            String className = callMethod.declaringClass().name().toString();
            beans.addBeanClass(className);
            Type returnType = callMethod.returnType();
            Type actualReturnType = returnType.name().toString().startsWith("java.util.List") && returnType.kind() == Type.Kind.PARAMETERIZED_TYPE ? (Type)returnType.asParameterizedType().arguments().get(0) : returnType;
            AnnotationValue moduleValue = clientDefinition.value("module");
            String string = module = moduleValue == null || moduleValue.asString().isEmpty() ? null : moduleValue.asString();
            if (module == null) {
                log.debugf("No module specified for SQLQueryClient %s, skipping", (Object)className);
                continue;
            }
            AnnotationValue dbNameValue = clientDefinition.value("dbName");
            String dbName = dbNameValue == null ? "" : dbNameValue.asString();
            AnnotationValue rawSQLValue = clientDefinition.value("rawSQL");
            String rawSQL = rawSQLValue == null ? "" : rawSQLValue.asString();
            AnnotationValue commandValue = clientDefinition.value("command");
            String command = commandValue == null ? "" : commandValue.asString();
            AnnotationValue fieldsValue = clientDefinition.value("fields");
            String[] fields = fieldsValue == null ? new String[]{} : fieldsValue.asStringArray();
            AnnotationValue colToFieldNameValue = clientDefinition.value("colToFieldName");
            String[] colToFieldName = colToFieldNameValue == null ? new String[]{} : colToFieldNameValue.asStringArray();
            schemaContributorBuildItemBuildProducer.produce((BuildItem)new SchemaContributorBuildItem(moduleBuilder -> moduleBuilder.registerSQLQueryMethod(callMethod, className, actualReturnType, dbName, command, rawSQL, fields, colToFieldName)));
        }
        additionalBeanBuildItem.produce((BuildItem)beans.build());
    }

    private static /* synthetic */ void lambda$verbsAndCron$4(MethodInfo method, String className, AnnotationInstance cron, ModuleBuilder moduleBuilder) {
        moduleBuilder.registerVerbMethod(method, className, Visibility.VISIBILITY_SCOPE_NONE, false, ModuleBuilder.BodyType.DISALLOWED, new ModuleBuilder.VerbCustomization().setMetadataCallback(builder -> builder.addMetadata(Metadata.newBuilder().setCronJob(MetadataCronJob.newBuilder().setCron(cron.value().asString())).build())));
    }

    private static /* synthetic */ void lambda$verbsAndCron$1(ClassInfo type, AnnotationInstance verb, ModuleBuilder moduleBuilder) {
        moduleBuilder.registerVerbType(type, VisibilityUtil.getVisibility(verb.target()), false, ModuleBuilder.BodyType.ALLOWED);
    }
}

