/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import xyz.block.ftl.ConsumableTopic;
import xyz.block.ftl.Export;
import xyz.block.ftl.WriteableTopic;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.Nullability;
import xyz.block.ftl.deployment.PositionUtils;
import xyz.block.ftl.deployment.ProjectRootBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.runtime.TopicHelper;
import xyz.block.ftl.schema.v1.Decl;
import xyz.block.ftl.schema.v1.Metadata;
import xyz.block.ftl.schema.v1.MetadataPartitions;
import xyz.block.ftl.schema.v1.Topic;
import xyz.block.ftl.schema.v1.Visibility;

public class TopicsProcessor {
    public static final DotName WRITEABLE_TOPIC = DotName.createSimple(WriteableTopic.class);
    public static final DotName CONSUMEABLE_TOPIC = DotName.createSimple(ConsumableTopic.class);
    private static final Logger log = Logger.getLogger(TopicsProcessor.class);

    @BuildStep
    TopicsBuildItem handleTopics(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedTopicProducer, BuildProducer<AdditionalBeanBuildItem> beans) {
        Collection topicDefinitions = index.getComputingIndex().getAnnotations(FTLDotNames.TOPIC);
        log.debugf("Processing %d topic definition annotations into decls", topicDefinitions.size());
        HashMap<DotName, TopicsBuildItem.DiscoveredTopic> topics = new HashMap<DotName, TopicsBuildItem.DiscoveredTopic>();
        HashSet<CallSite> names = new HashSet<CallSite>();
        for (AnnotationInstance topicDefinition : topicDefinitions) {
            ClassInfo iface = topicDefinition.target().asClass();
            if (!iface.isInterface()) {
                throw new RuntimeException("@TopicDefinition can only be applied to interfaces " + String.valueOf(iface.name()) + " is not an interface");
            }
            Type paramType = null;
            Type partitionMapperType = null;
            boolean consumer = false;
            for (Type i : iface.interfaceTypes()) {
                if (i.name().equals((Object)WRITEABLE_TOPIC)) {
                    if (i.kind() != Type.Kind.PARAMETERIZED_TYPE) continue;
                    paramType = (Type)i.asParameterizedType().arguments().get(0);
                    partitionMapperType = (Type)i.asParameterizedType().arguments().get(1);
                    continue;
                }
                if (!i.name().equals((Object)CONSUMEABLE_TOPIC)) continue;
                consumer = true;
            }
            if (paramType == null || partitionMapperType == null) {
                if (consumer) continue;
                throw new RuntimeException("@TopicDefinition can only be applied to interfaces that directly extend " + String.valueOf(WRITEABLE_TOPIC) + " with a concrete type parameter " + String.valueOf(iface.name()) + " does not extend this interface");
            }
            DotName partitionMapperClass = partitionMapperType.name();
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)partitionMapperClass.toString()));
            int partitions = 1;
            if (topicDefinition.value("partitions") != null) {
                partitions = topicDefinition.value("partitions").asInt();
            }
            if (partitionMapperClass.equals((Object)FTLDotNames.SINGLE_PARTITION_MAPPER) && partitions != 1) {
                throw new RuntimeException("SinglePartitionMapper can only be used with a single partition");
            }
            AnnotationValue nameValue = topicDefinition.value("name");
            Object name = Character.toLowerCase(iface.simpleName().charAt(0)) + iface.simpleName().substring(1);
            if (nameValue != null && nameValue.asString() != null && !nameValue.asString().isEmpty()) {
                name = nameValue.asString();
            }
            if (names.contains(name)) {
                throw new RuntimeException("Multiple topic definitions found for topic " + (String)name);
            }
            names.add((CallSite)name);
            try (ClassCreator cc = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedTopicProducer, true), iface.name().toString() + "_fit_topic", null, Object.class.getName(), new String[]{iface.name().toString()});){
                FieldCreator verb = cc.getFieldCreator("verb", String.class);
                MethodCreator constructor = cc.getConstructorCreator(new Class[]{String.class});
                constructor.invokeSpecialMethod(MethodDescriptor.ofMethod(Object.class, (String)"<init>", Void.TYPE, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                constructor.writeInstanceField(verb.getFieldDescriptor(), constructor.getThis(), constructor.getMethodParam(0));
                constructor.returnVoid();
                MethodCreator publish = cc.getMethodCreator("publish", Void.TYPE, new Class[]{Object.class});
                ResultHandle helper = publish.invokeStaticMethod(MethodDescriptor.ofMethod(TopicHelper.class, (String)"instance", TopicHelper.class, (Class[])new Class[0]), new ResultHandle[0]);
                publish.invokeVirtualMethod(MethodDescriptor.ofMethod(TopicHelper.class, (String)"publish", Void.TYPE, (Class[])new Class[]{String.class, String.class, Object.class, Class.class}), helper, new ResultHandle[]{publish.load((String)name), publish.readInstanceField(verb.getFieldDescriptor(), publish.getThis()), publish.getMethodParam(0), publish.loadClass(partitionMapperClass.toString())});
                publish.returnVoid();
                topics.put(iface.name(), new TopicsBuildItem.DiscoveredTopic((String)name, cc.getClassName(), paramType, iface.hasAnnotation(Export.class), iface.name().toString(), partitions));
            }
        }
        return new TopicsBuildItem(topics);
    }

    @BuildStep
    public SchemaContributorBuildItem topicSchema(final TopicsBuildItem topics, ProjectRootBuildItem projectRootBuildItem) {
        final String projectRoot = projectRootBuildItem.getProjectRoot();
        return new SchemaContributorBuildItem(new Consumer<ModuleBuilder>(){

            @Override
            public void accept(ModuleBuilder moduleBuilder) {
                for (TopicsBuildItem.DiscoveredTopic topic : topics.getTopics().values()) {
                    Visibility visibility = topic.exported() ? Visibility.VISIBILITY_SCOPE_MODULE : Visibility.VISIBILITY_SCOPE_NONE;
                    moduleBuilder.addDecls(Decl.newBuilder().setTopic(Topic.newBuilder().setVisibility(visibility).setPos(PositionUtils.forClass(projectRoot, topic.interfaceName())).setName(topic.topicName()).setEvent(moduleBuilder.buildType(topic.eventType(), visibility, Nullability.NOT_NULL)).addMetadata(Metadata.newBuilder().setPartitions(MetadataPartitions.newBuilder().setPartitions((long)topic.partitions()).build()).build()).build()).build());
                }
            }
        });
    }
}

