/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.VisibilityUtil;
import xyz.block.ftl.schema.v1.Visibility;

public class EnumProcessor {
    private static final Logger log = Logger.getLogger(EnumProcessor.class);

    @BuildStep
    SchemaContributorBuildItem handleEnums(CombinedIndexBuildItem index) {
        Collection enumAnnotations = index.getIndex().getAnnotations(FTLDotNames.ENUM);
        log.debugf("Processing %d enum annotations into decls", enumAnnotations.size());
        return new SchemaContributorBuildItem(moduleBuilder -> {
            for (AnnotationInstance enumAnnotation : enumAnnotations) {
                ClassInfo enumClass = enumAnnotation.target().asClass();
                Visibility visibility = VisibilityUtil.getVisibility((AnnotationTarget)enumClass);
                moduleBuilder.buildType((Type)ClassType.create((DotName)enumClass.name()), visibility, enumAnnotation.target());
            }
        });
    }
}

