/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.grpc.deployment.BindableServiceBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.vertx.http.deployment.RequireSocketHttpBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import xyz.block.ftl.deployment.CommentsBuildItem;
import xyz.block.ftl.deployment.DefaultOptionalBuildItem;
import xyz.block.ftl.deployment.HotReloadHandler;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.ModuleNameBuildItem;
import xyz.block.ftl.deployment.ModuleNameUtil;
import xyz.block.ftl.deployment.ProjectRootBuildItem;
import xyz.block.ftl.deployment.SQLQueryClientBuildItem;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.deployment.TopicsBuildItem;
import xyz.block.ftl.deployment.VerbClientBuildItem;
import xyz.block.ftl.hotreload.RunnerNotification;
import xyz.block.ftl.hotreload.v1.SchemaState;
import xyz.block.ftl.language.v1.Error;
import xyz.block.ftl.language.v1.ErrorList;
import xyz.block.ftl.runtime.CurrentRequestServerInterceptor;
import xyz.block.ftl.runtime.CurrentTransaction;
import xyz.block.ftl.runtime.FTLDatasourceCredentials;
import xyz.block.ftl.runtime.FTLRecorder;
import xyz.block.ftl.runtime.JsonSerializationConfig;
import xyz.block.ftl.runtime.TopicHelper;
import xyz.block.ftl.runtime.VerbClientHelper;
import xyz.block.ftl.runtime.VerbHandler;
import xyz.block.ftl.runtime.VerbRegistry;
import xyz.block.ftl.runtime.config.FTLConfigSourceFactoryBuilder;
import xyz.block.ftl.runtime.http.FTLHttpHandler;
import xyz.block.ftl.schema.v1.Module;

public class ModuleProcessor {
    private static final Logger log = Logger.getLogger(ModuleProcessor.class);
    private static final String FEATURE = "ftl-java-runtime";
    private static final String SCHEMA_OUT = "schema.pb";
    private static final String ERRORS_OUT = "errors.pb";
    static String schemaHash;

    @BuildStep
    BindableServiceBuildItem verbService() {
        BindableServiceBuildItem ret = new BindableServiceBuildItem(DotName.createSimple(VerbHandler.class));
        ret.registerBlockingMethod("call");
        ret.registerBlockingMethod("publishEvent");
        ret.registerBlockingMethod("acquireLease");
        ret.registerBlockingMethod("getDeploymentContext");
        ret.registerBlockingMethod("ping");
        return ret;
    }

    @BuildStep
    public SystemPropertyBuildItem moduleNameConfig(ApplicationInfoBuildItem applicationInfoBuildItem) {
        return new SystemPropertyBuildItem("ftl.module.name", applicationInfoBuildItem.getName());
    }

    @BuildStep
    ModuleNameBuildItem moduleName() throws IOException {
        String ftlModuleName = System.getenv("FTL_MODULE_NAME");
        if (ftlModuleName == null || ftlModuleName.isEmpty()) {
            return new ModuleNameBuildItem(ModuleNameUtil.getModuleName());
        }
        return new ModuleNameBuildItem(ftlModuleName);
    }

    @BuildStep
    ProjectRootBuildItem projectRoot(ApplicationInfoBuildItem applicationInfoBuildItem) throws IOException {
        String ftlProjectRoot = System.getenv("FTL_PROJECT_ROOT");
        if (ftlProjectRoot == null || ftlProjectRoot.isEmpty()) {
            return new ProjectRootBuildItem(applicationInfoBuildItem.getName());
        }
        return new ProjectRootBuildItem(ftlProjectRoot);
    }

    @BuildStep
    public CommentsBuildItem readComments() throws IOException {
        HashMap<String, Collection<String>> comments = new HashMap<String, Collection<String>>();
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/ftl-verbs.txt");){
            if (input != null) {
                String[] contents;
                for (String content : contents = new String(input.readAllBytes(), StandardCharsets.UTF_8).split("\n")) {
                    int eq = content.indexOf(61);
                    if (eq == -1) continue;
                    String key = content.substring(0, eq);
                    String value = new String(Base64.getDecoder().decode(content.substring(eq + 1)), StandardCharsets.UTF_8);
                    comments.put(key, Arrays.asList(value.split("\n")));
                }
            }
        }
        return new CommentsBuildItem(comments);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Produce(value=ServiceStartBuildItem.class)
    public void generateSchema(CombinedIndexBuildItem index, FTLRecorder recorder, OutputTargetBuildItem outputTargetBuildItem, ModuleNameBuildItem moduleNameBuildItem, TopicsBuildItem topicsBuildItem, VerbClientBuildItem verbClientBuildItem, SQLQueryClientBuildItem sqlQueryClientBuildItem, DefaultOptionalBuildItem defaultOptionalBuildItem, List<SchemaContributorBuildItem> schemaContributorBuildItems, LaunchModeBuildItem launchModeBuildItem, CommentsBuildItem comments, ProjectRootBuildItem projectRootBuildItem) throws Exception {
        String moduleName = moduleNameBuildItem.getModuleName();
        ModuleBuilder moduleBuilder = new ModuleBuilder(index.getIndex(), moduleName, topicsBuildItem.getTopics(), verbClientBuildItem.getVerbClients(), sqlQueryClientBuildItem.getSQLQueryClients(), recorder, comments, defaultOptionalBuildItem.isDefaultToOptional(), projectRootBuildItem.getProjectRoot());
        for (SchemaContributorBuildItem i : schemaContributorBuildItems) {
            i.getSchemaContributor().accept(moduleBuilder);
        }
        moduleBuilder.registerTransactionDbAccess();
        log.debugf("Generating module '%s' schema from %d decls", (Object)moduleName, (Object)moduleBuilder.getDeclsCount());
        Path output = outputTargetBuildItem.getOutputDirectory().resolve(SCHEMA_OUT);
        Path errorOutput = outputTargetBuildItem.getOutputDirectory().resolve(ERRORS_OUT);
        ByteArrayOutputStream sch = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        final AtomicReference errRef = new AtomicReference();
        final AtomicReference schRef = new AtomicReference();
        moduleBuilder.writeTo(sch, err, new BiConsumer<Module, ErrorList>(){

            @Override
            public void accept(Module module, ErrorList errorList) {
                errRef.set(errorList);
                schRef.set(module);
            }
        });
        byte[] schBytes = sch.toByteArray();
        byte[] errBytes = err.toByteArray();
        Files.write(output, schBytes, new OpenOption[0]);
        Files.write(errorOutput, errBytes, new OpenOption[0]);
        if (launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            boolean newRunnerRequired = false;
            String hash = HashUtil.sha256((byte[])schBytes);
            if (!Objects.equals(hash, schemaHash)) {
                schemaHash = hash;
                newRunnerRequired = true;
            }
            boolean fatal = false;
            for (Error e : ((ErrorList)errRef.get()).getErrorsList()) {
                if (e.getLevel() != Error.ErrorLevel.ERROR_LEVEL_ERROR) continue;
                schemaHash = null;
                fatal = true;
            }
            if (fatal) {
                HotReloadHandler.getInstance().setResults(SchemaState.newBuilder().setErrors((ErrorList)errRef.get()).setVersion(RunnerNotification.schemaVersion((boolean)true)).setNewRunnerRequired(true).build());
                Object message = "Schema validation failed: \n";
                for (Error i : ((ErrorList)errRef.get()).getErrorsList()) {
                    message = (String)message + i.getMsg() + "\n";
                }
                recorder.failStartup((String)message);
            } else {
                HotReloadHandler.getInstance().setResults(SchemaState.newBuilder().setModule((Module)schRef.get()).setVersion(RunnerNotification.schemaVersion((boolean)newRunnerRequired)).setNewRunnerRequired(newRunnerRequired).build());
            }
        } else if (launchModeBuildItem.getLaunchMode() == LaunchMode.TEST) {
            HotReloadHandler.getInstance().setResults(SchemaState.newBuilder().setVersion(RunnerNotification.schemaVersion((boolean)false)).setModule((Module)schRef.get()).build());
        } else {
            Path launch = outputTargetBuildItem.getOutputDirectory().resolve("launch");
            try (OutputStream out = Files.newOutputStream(launch, new OpenOption[0]);){
                out.write("#!/bin/bash\nif [ -n \"$FTL_DEBUG_PORT\" ]; then\n    FTL_JVM_OPTS=\"$FTL_JVM_OPTS -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:$FTL_DEBUG_PORT\"\nfi\nexec java $FTL_JVM_OPTS -jar quarkus-app/quarkus-run.jar".getBytes(StandardCharsets.UTF_8));
            }
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(launch, new LinkOption[0]);
            EnumSet<PosixFilePermission> newPerms = EnumSet.copyOf(perms);
            newPerms.add(PosixFilePermission.GROUP_EXECUTE);
            newPerms.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(launch, newPerms);
        }
        recorder.loadModuleContextOnStartup();
    }

    @BuildStep
    RunTimeConfigBuilderBuildItem runTimeConfigBuilderBuildItem() {
        return new RunTimeConfigBuilderBuildItem(FTLConfigSourceFactoryBuilder.class.getName());
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{VerbHandler.class, VerbRegistry.class, FTLHttpHandler.class, CurrentRequestServerInterceptor.class, TopicHelper.class, VerbClientHelper.class, JsonSerializationConfig.class, FTLDatasourceCredentials.class, CurrentTransaction.class}).setUnremovable().build();
    }

    @BuildStep
    void openSocket(BuildProducer<RequireVirtualHttpBuildItem> virtual, BuildProducer<RequireSocketHttpBuildItem> socket) throws IOException {
        socket.produce((BuildItem)RequireSocketHttpBuildItem.MARKER);
        virtual.produce((BuildItem)RequireVirtualHttpBuildItem.MARKER);
    }

    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("io.quarkus", new String[]{"Profile%s %s activated. %s", "Installed features:"}));
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("io.quarkus.grpc.runtime.GrpcServerRecorder", new String[]{"Starting new Quarkus gRPC server", "Registering gRPC reflection service"}));
    }
}

