/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.gizmo.DescriptorUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.block.ftl.schema.v1.Position;

public class PositionUtils {
    private static final Logger LOG = Logger.getLogger(PositionUtils.class);

    public static xyz.block.ftl.language.v1.Position toError(Position position) {
        String fileName = position.getFilename();
        if (RuntimeUpdatesProcessor.INSTANCE != null) {
            for (Path updates : RuntimeUpdatesProcessor.INSTANCE.getSourcesDir()) {
                Path resolved = updates.resolve(fileName);
                if (!Files.exists(resolved, new LinkOption[0])) continue;
                fileName = resolved.toAbsolutePath().toString();
                break;
            }
        }
        return xyz.block.ftl.language.v1.Position.newBuilder().setFilename(fileName).setLine(position.getLine()).build();
    }

    public static Position forMethod(String projectRoot, MethodInfo method) {
        return PositionUtils.getLineNumber(projectRoot, method.declaringClass().name().toString(), method);
    }

    public static Position forClass(String projectRoot, String className) {
        return PositionUtils.getLineNumber(projectRoot, className, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static Position getLineNumber(String projectRoot, String className, MethodInfo method) {
        Position.Builder builder = Position.newBuilder();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL cls = cl.getResource(className.replace('.', '/') + ".class");
            if (cls == null) {
                return builder.build();
            }
            try (InputStream in = cls.openStream();){
                ClassReader reader = new ClassReader(in);
                ClassNode clNode = new ClassNode(589824);
                reader.accept((ClassVisitor)clNode, 589824);
                if (clNode.sourceFile == null) {
                    Position position = builder.build();
                    return position;
                }
                int idx = className.lastIndexOf(".");
                Object packagePart = "";
                if (idx != -1) {
                    packagePart = className.substring(0, idx).replaceAll("\\.", "/") + "/";
                }
                String relativePath = (String)packagePart + clNode.sourceFile;
                Object finalPath = relativePath;
                if (RuntimeUpdatesProcessor.INSTANCE != null) {
                    for (Path updates : RuntimeUpdatesProcessor.INSTANCE.getSourcesDir()) {
                        Path resolved = updates.resolve(relativePath);
                        if (!Files.exists(resolved, new LinkOption[0])) continue;
                        finalPath = resolved.toAbsolutePath().toString();
                        break;
                    }
                }
                if (projectRoot != null && !projectRoot.isEmpty()) {
                    Path absoluteSourcePath;
                    Path projectRootPath = Paths.get(projectRoot, new String[0]);
                    Path potentialPath = projectRootPath.resolve((String)finalPath);
                    Path path = absoluteSourcePath = Files.exists(potentialPath, new LinkOption[0]) ? potentialPath.toAbsolutePath() : null;
                    if (absoluteSourcePath != null) {
                        try {
                            finalPath = projectRootPath.toAbsolutePath().relativize(absoluteSourcePath).toString();
                        }
                        catch (IllegalArgumentException e) {
                            LOG.debugf("Could not relativize path %s against project root %s. Using absolute path. Error: %s", (Object)absoluteSourcePath, (Object)projectRootPath.toAbsolutePath(), (Object)e.getMessage());
                            finalPath = absoluteSourcePath.toString();
                        }
                    } else {
                        LOG.debugf("Could not resolve source file %s relative to project root %s or dev sources.", (Object)relativePath, (Object)projectRoot);
                    }
                }
                builder.setFilename((String)finalPath);
                if (method != null) {
                    String descriptor = DescriptorUtils.methodSignatureToDescriptor((String)method.returnType().descriptor(), (String[])((String[])method.parameters().stream().map(p -> p.type().descriptor()).toArray(String[]::new)));
                    for (MethodNode mNode : clNode.methods) {
                        if (!mNode.name.equals(method.name()) || !mNode.desc.equals(descriptor)) continue;
                        for (AbstractInsnNode inNode : mNode.instructions) {
                            if (!(inNode instanceof LineNumberNode)) continue;
                            builder.setLine((long)Math.max(1, ((LineNumberNode)inNode).line - 2));
                            Position position = builder.build();
                            return position;
                        }
                    }
                }
                Position position = builder.build();
                return position;
            }
            catch (IOException e) {
                LOG.errorf((Throwable)e, "Failed to read class %s", (Object)className);
                return builder.build();
            }
        }
        catch (IllegalStateException e) {
            return builder.build();
        }
    }
}

