/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.VoidType;
import org.jetbrains.annotations.Nullable;
import xyz.block.ftl.deployment.FTLDotNames;
import xyz.block.ftl.deployment.ModuleBuilder;
import xyz.block.ftl.deployment.Nullability;
import xyz.block.ftl.deployment.VerbInfo;
import xyz.block.ftl.deployment.VerbType;

public class VerbUtil {
    @Nullable
    public static VerbInfo getVerbInfo(IndexView index, ClassInfo clazz) {
        MethodInfo method = null;
        VoidType bodyParamType = VoidType.VOID;
        Nullability bodyParamNullability = Nullability.NOT_NULL;
        VerbType type = null;
        String name = ModuleBuilder.classToName(clazz);
        if (clazz.interfaceNames().contains(FTLDotNames.SINK_VERB)) {
            type = VerbType.SINK;
            for (MethodInfo methodInfo : clazz.methods()) {
                if (!methodInfo.name().equals("call") || methodInfo.returnType() != VoidType.VOID || methodInfo.parametersCount() != 1 || methodInfo.isBridge()) continue;
                method = methodInfo;
                MethodParameterInfo param = (MethodParameterInfo)methodInfo.parameters().get(0);
                bodyParamType = param.type();
                bodyParamNullability = ModuleBuilder.nullability((AnnotationTarget)param);
                break;
            }
        } else if (clazz.interfaceNames().contains(FTLDotNames.FUNCTION_VERB)) {
            type = VerbType.VERB;
            for (MethodInfo methodInfo : clazz.methods()) {
                if (!methodInfo.name().equals("call") || methodInfo.returnType() == VoidType.VOID || methodInfo.parametersCount() != 1 || methodInfo.isBridge()) continue;
                method = methodInfo;
                MethodParameterInfo param = (MethodParameterInfo)methodInfo.parameters().get(0);
                bodyParamType = param.type();
                bodyParamNullability = ModuleBuilder.nullability((AnnotationTarget)param);
                break;
            }
        } else if (clazz.interfaceNames().contains(FTLDotNames.EMPTY_VERB)) {
            type = VerbType.EMPTY;
            for (MethodInfo methodInfo : clazz.methods()) {
                if (!methodInfo.name().equals("call") || methodInfo.returnType() != VoidType.VOID || methodInfo.parametersCount() != 0 || methodInfo.isBridge()) continue;
                method = methodInfo;
                break;
            }
        } else if (clazz.interfaceNames().contains(FTLDotNames.SOURCE_VERB)) {
            type = VerbType.SOURCE;
            for (MethodInfo methodInfo : clazz.methods()) {
                if (!methodInfo.name().equals("call") || methodInfo.returnType() == VoidType.VOID || methodInfo.parametersCount() != 0 || methodInfo.isBridge()) continue;
                method = methodInfo;
                break;
            }
        }
        if (method == null) {
            ClassInfo sup = index.getClassByName(clazz.superName());
            if (sup == null) {
                return null;
            }
            VerbInfo verbInfo = VerbUtil.getVerbInfo(index, sup);
            if (verbInfo == null) {
                return null;
            }
            return new VerbInfo(name, verbInfo.type(), verbInfo.method(), verbInfo.bodyParamType(), verbInfo.bodyParamNullability());
        }
        return new VerbInfo(name, type, method, (Type)bodyParamType, bodyParamNullability);
    }
}

