/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.deployment.util.FileUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class PackageOutput
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(PackageOutput.class);
    private final Path outputDir;
    private final String packageName;
    private final Map<String, StringBuilder> files = new HashMap<String, StringBuilder>();

    public PackageOutput(Path outputDir, String packageName) {
        this.outputDir = outputDir;
        this.packageName = packageName.replaceAll("\\.", "/");
    }

    public StringBuilder writeKotlin(String fileName) throws IOException {
        StringBuilder value = new StringBuilder();
        this.files.put(this.packageName + "/" + fileName + ".kt", value);
        return value;
    }

    public StringBuilder writeJava(String fileName) throws IOException {
        StringBuilder value = new StringBuilder();
        this.files.put(fileName, value);
        return value;
    }

    @Override
    public void close() {
        try {
            Path packageDir = this.outputDir.resolve(this.packageName);
            if (Files.exists(packageDir, new LinkOption[0])) {
                try (Stream<Path> s = Files.list(packageDir);){
                    s.forEach(path -> {
                        if (!this.files.containsKey(path.getFileName().toString())) {
                            try {
                                FileUtil.deleteIfExists((Path)path);
                            }
                            catch (IOException e) {
                                log.errorf((Throwable)e, "Failed to delete path: %s", path);
                            }
                        }
                    });
                }
            }
            Files.createDirectories(packageDir, new FileAttribute[0]);
            for (Map.Entry<String, StringBuilder> e : this.files.entrySet()) {
                byte[] existing;
                Path target = this.outputDir.resolve(e.getKey());
                byte[] fileBytes = e.getValue().toString().getBytes(StandardCharsets.UTF_8);
                if (Files.exists(target, new LinkOption[0]) && Arrays.equals(fileBytes, existing = Files.readAllBytes(target))) continue;
                Files.write(target, fileBytes, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

