/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import xyz.block.ftl.deployment.SchemaContributorBuildItem;
import xyz.block.ftl.v1.schema.Database;
import xyz.block.ftl.v1.schema.Decl;

public class DatasourceProcessor {
    @BuildStep
    public SchemaContributorBuildItem registerDatasources(List<JdbcDataSourceBuildItem> datasources, BuildProducer<SystemPropertyBuildItem> systemPropProducer, BuildProducer<GeneratedResourceBuildItem> generatedResourceBuildItemBuildProducer) {
        ArrayList<Decl> decls = new ArrayList<Decl>();
        ArrayList<String> namedDatasources = new ArrayList<String>();
        for (JdbcDataSourceBuildItem ds : datasources) {
            if (!ds.getDbKind().equals("postgresql")) {
                throw new RuntimeException("only postgresql is supported not " + ds.getDbKind());
            }
            String sanitisedName = ds.getName().replace("<", "").replace(">", "");
            if (ds.isDefault()) {
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource.credentials-provider", sanitisedName));
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource.credentials-provider-name", "ftl-datasource-credentials"));
            } else {
                namedDatasources.add(ds.getName());
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource." + ds.getName() + ".credentials-provider", sanitisedName));
                systemPropProducer.produce((BuildItem)new SystemPropertyBuildItem("quarkus.datasource." + ds.getName() + ".credentials-provider-name", "ftl-datasource-credentials"));
            }
            decls.add(Decl.newBuilder().setDatabase(Database.newBuilder().setType("postgres").setName(sanitisedName)).build());
        }
        generatedResourceBuildItemBuildProducer.produce((BuildItem)new GeneratedResourceBuildItem("ftl-datasource-names.txt", String.join((CharSequence)"\n", namedDatasources).getBytes(StandardCharsets.UTF_8)));
        return new SchemaContributorBuildItem(decls);
    }
}

