/*
 * Decompiled with CFR 0.152.
 */
package xyz.block.ftl.java.runtime.it;

import ftl.echo.EchoClient;
import ftl.echo.EchoRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.nio.charset.StandardCharsets;
import xyz.block.ftl.Verb;
import xyz.block.ftl.java.runtime.it.MyTopic;
import xyz.block.ftl.java.runtime.it.Person;

@Path(value="/test")
@ApplicationScoped
public class FtlJavaRuntimeResource {
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/post")
    public String post(Person person) {
        return "Hello " + person.first() + " " + person.last();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/bytes")
    public String bytesHttp(byte[] data) {
        return "Hello " + new String(data, StandardCharsets.UTF_8);
    }

    @Verb
    public String hello(String name, EchoClient echoClient) {
        return "Hello " + echoClient.call(new EchoRequest().setName(name)).getMessage();
    }

    @Verb
    public void publish(Person person, MyTopic topic) {
        topic.publish(person);
    }

    @Verb
    public byte[] bytes(byte[] bytes) {
        return bytes;
    }
}

